/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MetadataCorrelationHeader
extends MetadataCorrelationProperties {
    private Date lastSynchronized = null;

    public MetadataCorrelationHeader() {
    }

    public MetadataCorrelationHeader(MetadataCorrelationHeader template) {
        super(template);
        if (template != null) {
            this.lastSynchronized = template.getLastSynchronized();
        }
    }

    public Date getLastSynchronized() {
        return this.lastSynchronized;
    }

    public void setLastSynchronized(Date lastSynchronized) {
        this.lastSynchronized = lastSynchronized;
    }

    @Override
    public String toString() {
        return "MetadataCorrelationHeader{lastSynchronized=" + this.lastSynchronized + ", assetManagerGUID='" + this.getAssetManagerGUID() + '\'' + ", assetManagerName='" + this.getAssetManagerName() + '\'' + ", permittedSynchronization=" + this.getSynchronizationDirection() + ", synchronizationDescription='" + this.getSynchronizationDescription() + '\'' + ", externalIdentifier='" + this.getExternalIdentifier() + '\'' + ", externalIdentifierName='" + this.getExternalIdentifierName() + '\'' + ", externalIdentifierUsage='" + this.getExternalIdentifierUsage() + '\'' + ", externalIdentifierSource='" + this.getExternalIdentifierSource() + '\'' + ", keyPattern=" + this.getKeyPattern() + ", mappingProperties=" + this.getMappingProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MetadataCorrelationHeader that = (MetadataCorrelationHeader)objectToCompare;
        return Objects.equals(this.getLastSynchronized(), that.getLastSynchronized());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLastSynchronized());
    }
}

