/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PortElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private PortProperties portProperties = null;

    public PortElement() {
    }

    public PortElement(PortElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.correlationHeaders = template.getCorrelationHeaders();
            this.portProperties = template.getPortProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        if (this.correlationHeaders == null) {
            return null;
        }
        if (this.correlationHeaders.isEmpty()) {
            return null;
        }
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public PortProperties getPortProperties() {
        return this.portProperties;
    }

    public void setPortProperties(PortProperties portProperties) {
        this.portProperties = portProperties;
    }

    public String toString() {
        return "PortElement{elementHeader=" + this.elementHeader + ", correlationHeaders=" + this.correlationHeaders + ", portProperties=" + this.portProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PortElement that = (PortElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.correlationHeaders, that.correlationHeaders) && Objects.equals(this.portProperties, that.portProperties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.correlationHeaders, this.portProperties);
    }
}

