/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ProcessProperties.class, name="ProcessProperties")})
public class AssetProperties
extends SupplementaryProperties {
    private static final long serialVersionUID = 1L;
    private String technicalName = null;
    private String technicalDescription = null;
    private String owner = null;
    private OwnerCategory ownerCategory = null;
    private List<String> zoneMembership = null;
    private String originOrganizationGUID = null;
    private String originBusinessCapabilityGUID = null;
    private Map<String, String> otherOriginValues = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.technicalName = template.getTechnicalName();
            this.technicalDescription = template.getTechnicalDescription();
            this.owner = template.getOwner();
            this.ownerCategory = template.getOwnerCategory();
            this.zoneMembership = template.getZoneMembership();
            this.originOrganizationGUID = template.getOriginOrganizationGUID();
            this.originBusinessCapabilityGUID = template.getOriginBusinessCapabilityGUID();
            this.otherOriginValues = template.getOtherOriginValues();
        }
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String getTechnicalDescription() {
        return this.technicalDescription;
    }

    public void setTechnicalDescription(String description) {
        this.technicalDescription = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OwnerCategory getOwnerCategory() {
        return this.ownerCategory;
    }

    public void setOwnerCategory(OwnerCategory ownerType) {
        this.ownerCategory = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getOriginOrganizationGUID() {
        return this.originOrganizationGUID;
    }

    public void setOriginOrganizationGUID(String originOrganizationGUID) {
        this.originOrganizationGUID = originOrganizationGUID;
    }

    public String getOriginBusinessCapabilityGUID() {
        return this.originBusinessCapabilityGUID;
    }

    public void setOriginBusinessCapabilityGUID(String originBusinessCapabilityGUID) {
        this.originBusinessCapabilityGUID = originBusinessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        if (this.otherOriginValues == null) {
            return null;
        }
        if (this.otherOriginValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.otherOriginValues);
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    @Override
    public String toString() {
        return "DataAssetProperties{technicalName='" + this.technicalName + '\'' + ", technicalDescription='" + this.technicalDescription + '\'' + ", owner='" + this.owner + '\'' + ", ownerCategory=" + this.ownerCategory + ", zoneMembership=" + this.zoneMembership + ", originOrganizationGUID='" + this.originOrganizationGUID + '\'' + ", originBusinessCapabilityGUID='" + this.originBusinessCapabilityGUID + '\'' + ", otherOriginValues=" + this.otherOriginValues + ", displayName='" + this.getDisplayName() + '\'' + ", summary='" + this.getSummary() + '\'' + ", description='" + this.getDescription() + '\'' + ", abbreviation='" + this.getAbbreviation() + '\'' + ", usage='" + this.getUsage() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        return Objects.equals(this.getTechnicalName(), that.getTechnicalName()) && Objects.equals(this.getTechnicalDescription(), that.getTechnicalDescription()) && Objects.equals(this.getOwner(), that.getOwner()) && this.getOwnerCategory() == that.getOwnerCategory() && Objects.equals(this.getZoneMembership(), that.getZoneMembership()) && Objects.equals(this.getOriginOrganizationGUID(), that.getOriginOrganizationGUID()) && Objects.equals(this.getOriginBusinessCapabilityGUID(), that.getOriginBusinessCapabilityGUID()) && Objects.equals(this.getOtherOriginValues(), that.getOtherOriginValues());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.technicalName, this.technicalDescription, this.owner, this.ownerCategory, this.zoneMembership, this.originOrganizationGUID, this.originBusinessCapabilityGUID, this.otherOriginValues);
    }
}

