/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EndpointProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private EndpointProperties endpointProperties = null;
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private ElementHeader elementHeader = null;

    public EndpointElement() {
    }

    public EndpointElement(EndpointElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.correlationHeaders = template.getCorrelationHeaders();
            this.endpointProperties = template.getEndpointProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        if (this.correlationHeaders == null) {
            return null;
        }
        if (this.correlationHeaders.isEmpty()) {
            return null;
        }
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public EndpointProperties getEndpointProperties() {
        return this.endpointProperties;
    }

    public void setEndpointProperties(EndpointProperties endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public String toString() {
        return "EndpointElement{endpointProperties=" + this.endpointProperties + ", correlationHeaders=" + this.correlationHeaders + ", elementHeader=" + this.elementHeader + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        EndpointElement that = (EndpointElement)objectToCompare;
        return Objects.equals(this.getEndpointProperties(), that.getEndpointProperties()) && Objects.equals(this.getCorrelationHeaders(), that.getCorrelationHeaders()) && Objects.equals(this.getElementHeader(), that.getElementHeader());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.correlationHeaders, this.endpointProperties);
    }
}

