/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MetadataCorrelationProperties
extends ExternalIdentifierProperties {
    private static final long serialVersionUID = 1L;
    private String assetManagerGUID = null;
    private String assetManagerName = null;

    public MetadataCorrelationProperties() {
    }

    public MetadataCorrelationProperties(MetadataCorrelationProperties template) {
        super(template);
        if (template != null) {
            this.assetManagerGUID = template.getAssetManagerGUID();
            this.assetManagerName = template.getAssetManagerName();
        }
    }

    public MetadataCorrelationProperties(ExternalIdentifierProperties template) {
        super(template);
    }

    public String getAssetManagerGUID() {
        return this.assetManagerGUID;
    }

    public void setAssetManagerGUID(String assetManagerGUID) {
        this.assetManagerGUID = assetManagerGUID;
    }

    public String getAssetManagerName() {
        return this.assetManagerName;
    }

    public void setAssetManagerName(String assetManagerName) {
        this.assetManagerName = assetManagerName;
    }

    @Override
    public String toString() {
        return "MetadataCorrelationProperties{synchronizationDirection=" + this.getSynchronizationDirection() + ", synchronizationDescription='" + this.getSynchronizationDescription() + "', externalIdentifier='" + this.getExternalIdentifier() + "', externalIdentifierName='" + this.getExternalIdentifierName() + "', externalIdentifierUsage='" + this.getExternalIdentifierUsage() + "', externalIdentifierSource='" + this.getExternalIdentifierSource() + "', keyPattern=" + this.getKeyPattern() + ", mappingProperties=" + this.getMappingProperties() + ", assetManagerGUID='" + this.assetManagerGUID + "', assetManagerName='" + this.assetManagerName + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MetadataCorrelationProperties that = (MetadataCorrelationProperties)objectToCompare;
        return Objects.equals(this.assetManagerGUID, that.assetManagerGUID) && Objects.equals(this.assetManagerName, that.assetManagerName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assetManagerGUID, this.assetManagerName);
    }
}

