/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ComplexSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.QueryTargetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SimpleSchemaTypeProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ComplexSchemaTypeProperties.class, name="ComplexSchemaTypeProperties"), @JsonSubTypes.Type(value=LiteralSchemaTypeProperties.class, name="LiteralSchemaTypeProperties"), @JsonSubTypes.Type(value=SimpleSchemaTypeProperties.class, name="SimpleSchemaTypeProperties"), @JsonSubTypes.Type(value=SchemaTypeChoiceProperties.class, name="SchemaTypeChoiceProperties"), @JsonSubTypes.Type(value=MapSchemaTypeProperties.class, name="MapSchemaTypeProperties")})
public class SchemaTypeProperties
extends SchemaProperties {
    private static final long serialVersionUID = 1L;
    private String versionNumber = null;
    private String author = null;
    private String encodingStandard = null;
    private String namespace = null;
    private String formula = null;
    private List<QueryTargetProperties> queries = null;

    public SchemaTypeProperties() {
    }

    public SchemaTypeProperties(SchemaTypeProperties template) {
        super(template);
        if (template != null) {
            this.versionNumber = template.getVersionNumber();
            this.author = template.getAuthor();
            this.encodingStandard = template.getEncodingStandard();
            this.namespace = template.getNamespace();
            this.formula = template.getFormula();
            this.queries = template.getQueries();
        }
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getEncodingStandard() {
        return this.encodingStandard;
    }

    public void setEncodingStandard(String encodingStandard) {
        this.encodingStandard = encodingStandard;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public List<QueryTargetProperties> getQueries() {
        if (this.queries == null) {
            return null;
        }
        if (this.queries.isEmpty()) {
            return null;
        }
        return new ArrayList<QueryTargetProperties>(this.queries);
    }

    public void setQueries(List<QueryTargetProperties> queries) {
        this.queries = queries;
    }

    @Override
    public String toString() {
        return "SchemaTypeProperties{qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + ", isDeprecated=" + this.getIsDeprecated() + ", technicalName='" + this.getTechnicalName() + "', technicalDescription='" + this.getTechnicalDescription() + "', versionNumber='" + this.versionNumber + "', author='" + this.author + "', encodingStandard='" + this.encodingStandard + "', namespace='" + this.namespace + "', formula='" + this.formula + "', queries=" + this.queries + ", displayName='" + this.getDisplayName() + "', summary='" + this.getSummary() + "', description='" + this.getDescription() + "', abbreviation='" + this.getAbbreviation() + "', usage='" + this.getUsage() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaTypeProperties that = (SchemaTypeProperties)objectToCompare;
        return Objects.equals(this.versionNumber, that.versionNumber) && Objects.equals(this.author, that.author) && Objects.equals(this.encodingStandard, that.encodingStandard) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.formula, that.formula) && Objects.equals(this.queries, that.queries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.versionNumber, this.author, this.encodingStandard, this.namespace, this.formula, this.queries);
    }
}

