/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataAssetElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private DataAssetProperties dataAssetProperties = null;
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private ElementHeader elementHeader = null;

    public DataAssetElement() {
    }

    public DataAssetElement(DataAssetElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.correlationHeaders = template.getCorrelationHeaders();
            this.dataAssetProperties = template.getDataAssetProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        if (this.correlationHeaders == null) {
            return null;
        }
        if (this.correlationHeaders.isEmpty()) {
            return null;
        }
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public DataAssetProperties getDataAssetProperties() {
        return this.dataAssetProperties;
    }

    public void setDataAssetProperties(DataAssetProperties dataAssetProperties) {
        this.dataAssetProperties = dataAssetProperties;
    }

    public String toString() {
        return "DataAssetElement{dataAssetProperties=" + this.dataAssetProperties + ", correlationHeaders=" + this.correlationHeaders + ", elementHeader=" + this.elementHeader + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        DataAssetElement that = (DataAssetElement)objectToCompare;
        return Objects.equals(this.getDataAssetProperties(), that.getDataAssetProperties()) && Objects.equals(this.getCorrelationHeaders(), that.getCorrelationHeaders()) && Objects.equals(this.getElementHeader(), that.getElementHeader());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.correlationHeaders, this.dataAssetProperties);
    }
}

