/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GovernanceActionStatus implements Serializable
{
    REQUESTED(0, 0, "Requested", "The governance action has been created and is pending"),
    APPROVED(1, 1, "Approved", "The governance action is approved to run"),
    WAITING(2, 2, "Waiting", "The governance action is waiting for its start time or the right conditions to run"),
    ACTIVATING(3, 3, "Activating", "The governance action service for the governance action is being initialized in the governance engine"),
    IN_PROGRESS(4, 4, "In Progress", "The governance engine is running the associated governance action service for the governance action"),
    ACTIONED(5, 10, "Actioned", "The governance action service for the governance action has successfully completed processing"),
    INVALID(6, 11, "Invalid", "The governance action has not been run because it is not appropriate (for example, a false positive)"),
    IGNORED(7, 12, "Ignored", "The governance action has not been run because a different governance action was chosen"),
    FAILED(8, 13, "Failed", "The governance action service for the governance action failed to execute"),
    OTHER(99, 99, "Other", "Undefined or unknown governance action status");

    private static final long serialVersionUID = 1L;
    private static final String ENUM_TYPE_GUID = "a6e698b0-a4f7-4a39-8c80-db0bb0f972e";
    private static final String ENUM_TYPE_NAME = "GovernanceActionStatus";
    private String statusName;
    private String statusDescription;
    private int statusCode;
    private int openTypeOrdinal;

    private GovernanceActionStatus(int statusCode, int openTypeOrdinal, String statusName, String statusDescription) {
        this.statusCode = statusCode;
        this.openTypeOrdinal = openTypeOrdinal;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getOrdinal() {
        return this.statusCode;
    }

    public String getName() {
        return this.statusName;
    }

    public String getDescription() {
        return this.statusDescription;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "GovernanceActionStatus{statusName='" + this.statusName + "', statusDescription='" + this.statusDescription + "', statusCode=" + this.statusCode + ", openTypeOrdinal=" + this.openTypeOrdinal + "}";
    }
}

