/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataAssetProperties.class, name="DataAssetProperties"), @JsonSubTypes.Type(value=ProcessProperties.class, name="ProcessProperties")})
public class AssetProperties
extends SupplementaryProperties {
    private static final long serialVersionUID = 1L;
    private String technicalName = null;
    private String versionIdentifier = null;
    private String technicalDescription = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.technicalName = template.getTechnicalName();
            this.versionIdentifier = template.getVersionIdentifier();
            this.technicalDescription = template.getTechnicalDescription();
        }
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getTechnicalDescription() {
        return this.technicalDescription;
    }

    public void setTechnicalDescription(String description) {
        this.technicalDescription = description;
    }

    @Override
    public String toString() {
        return "AssetProperties{technicalName='" + this.technicalName + "', versionIdentifier='" + this.versionIdentifier + "', technicalDescription='" + this.technicalDescription + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + ", displayName='" + this.getDisplayName() + "', summary='" + this.getSummary() + "', description='" + this.getDescription() + "', abbreviation='" + this.getAbbreviation() + "', usage='" + this.getUsage() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        return Objects.equals(this.technicalName, that.technicalName) && Objects.equals(this.versionIdentifier, that.versionIdentifier) && Objects.equals(this.technicalDescription, that.technicalDescription);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.technicalName, this.versionIdentifier, this.technicalDescription);
    }
}

