/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SchemaAttributeProperties.class, name="SchemaAttributeProperties"), @JsonSubTypes.Type(value=SchemaTypeProperties.class, name="SchemaTypeProperties")})
public class SchemaProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private boolean isDeprecated = false;
    private String displayName = null;
    private String description = null;

    public SchemaProperties() {
    }

    public SchemaProperties(SchemaProperties template) {
        super(template);
        if (template != null) {
            this.isDeprecated = template.getIsDeprecated();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
        }
    }

    public boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public void setIsDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "SchemaProperties{isDeprecated=" + this.isDeprecated + ", displayName='" + this.displayName + "', description='" + this.description + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaProperties that = (SchemaProperties)objectToCompare;
        return this.isDeprecated == that.isDeprecated && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isDeprecated, this.displayName, this.description);
    }
}

