/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommentProperties
extends ReferenceableProperties {
    private CommentType commentType = null;
    private String commentText = null;
    private String user = null;

    public CommentProperties() {
    }

    public CommentProperties(CommentProperties template) {
        super(template);
        if (template != null) {
            this.commentType = template.getCommentType();
            this.user = template.getUser();
            this.commentText = template.getCommentText();
        }
    }

    public CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return "CommentProperties{commentType=" + this.commentType + ", commentText='" + this.commentText + "', user='" + this.user + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommentProperties that = (CommentProperties)objectToCompare;
        return this.commentType == that.commentType && Objects.equals(this.commentText, that.commentText) && Objects.equals(this.user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.commentType, this.commentText, this.user);
    }
}

