/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TagProperties {
    private boolean isPrivateTag = false;
    private String name = null;
    private String description = null;

    public TagProperties() {
    }

    public TagProperties(TagProperties template) {
        if (template != null) {
            this.isPrivateTag = template.getIsPrivateTag();
            this.name = template.getName();
            this.description = template.getDescription();
        }
    }

    public boolean getIsPrivateTag() {
        return this.isPrivateTag;
    }

    public void setIsPrivateTag(boolean privateTag) {
        this.isPrivateTag = privateTag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tagDescription) {
        this.description = tagDescription;
    }

    public String toString() {
        return "TagProperties{isPrivateTag=" + this.isPrivateTag + ", name='" + this.name + "', description='" + this.description + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TagProperties)) {
            return false;
        }
        TagProperties that = (TagProperties)objectToCompare;
        if (this.isPrivateTag != that.isPrivateTag) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    public int hashCode() {
        int result = this.isPrivateTag ? 1 : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

