/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectionElement
implements CorrelatedMetadataElement {
    private ConnectionProperties connectionProperties = null;
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private ElementHeader elementHeader = null;
    private ElementStub connectorType = null;
    private ElementStub endpoint = null;
    private List<EmbeddedConnection> embeddedConnections = null;

    public ConnectionElement() {
    }

    public ConnectionElement(ConnectionElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.correlationHeaders = template.getCorrelationHeaders();
            this.connectionProperties = template.getConnectionProperties();
            this.connectorType = template.getConnectorType();
            this.endpoint = template.getEndpoint();
            this.embeddedConnections = template.getEmbeddedConnections();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        if (this.correlationHeaders == null) {
            return null;
        }
        if (this.correlationHeaders.isEmpty()) {
            return null;
        }
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(ConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setConnectorType(ElementStub connectorType) {
        this.connectorType = connectorType;
    }

    public ElementStub getConnectorType() {
        return this.connectorType;
    }

    public void setEndpoint(ElementStub endpoint) {
        this.endpoint = endpoint;
    }

    public ElementStub getEndpoint() {
        return this.endpoint;
    }

    public List<EmbeddedConnection> getEmbeddedConnections() {
        if (this.embeddedConnections == null) {
            return null;
        }
        if (this.embeddedConnections.isEmpty()) {
            return null;
        }
        return new ArrayList<EmbeddedConnection>(this.embeddedConnections);
    }

    public void setEmbeddedConnections(List<EmbeddedConnection> embeddedConnections) {
        this.embeddedConnections = embeddedConnections;
    }

    public String toString() {
        return "ConnectionElement{connectionProperties=" + this.connectionProperties + ", correlationHeaders=" + this.correlationHeaders + ", elementHeader=" + this.elementHeader + ", connectorType=" + this.connectorType + ", endpoint=" + this.endpoint + ", embeddedConnections=" + this.embeddedConnections + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ConnectionElement that = (ConnectionElement)objectToCompare;
        return Objects.equals(this.getConnectionProperties(), that.getConnectionProperties()) && Objects.equals(this.getCorrelationHeaders(), that.getCorrelationHeaders()) && Objects.equals(this.getElementHeader(), that.getElementHeader());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.correlationHeaders, this.connectionProperties);
    }
}

