/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferenceableElement
implements CorrelatedMetadataElement {
    private ElementHeader elementHeader = null;
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private ReferenceableProperties referenceableProperties = null;

    public ReferenceableElement() {
    }

    public ReferenceableElement(ReferenceableElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.correlationHeaders = template.getCorrelationHeaders();
            this.referenceableProperties = template.getReferenceableProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        if (this.correlationHeaders == null) {
            return null;
        }
        if (this.correlationHeaders.isEmpty()) {
            return null;
        }
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public ReferenceableProperties getReferenceableProperties() {
        return this.referenceableProperties;
    }

    public void setReferenceableProperties(ReferenceableProperties referenceableProperties) {
        this.referenceableProperties = referenceableProperties;
    }

    public String toString() {
        return "ReferenceableElement{elementHeader=" + this.elementHeader + ", correlationHeaders=" + this.correlationHeaders + ", referenceableProperties=" + this.referenceableProperties + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ReferenceableElement that = (ReferenceableElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.correlationHeaders, that.correlationHeaders) && Objects.equals(this.referenceableProperties, that.referenceableProperties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.correlationHeaders, this.referenceableProperties);
    }
}

