/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetElementsResponse
extends AssetManagerOMASAPIResponse {
    private List<AssetElement> elementList = null;

    public AssetElementsResponse() {
    }

    public AssetElementsResponse(AssetElementsResponse template) {
        super(template);
        if (template != null) {
            this.elementList = template.getElementList();
        }
    }

    public List<AssetElement> getElementList() {
        if (this.elementList == null) {
            return null;
        }
        if (this.elementList.isEmpty()) {
            return null;
        }
        return new ArrayList<AssetElement>(this.elementList);
    }

    public void setElementList(List<AssetElement> elementList) {
        this.elementList = elementList;
    }

    @Override
    public String toString() {
        return "AssetElementsResponse{elementList=" + String.valueOf(this.elementList) + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + String.valueOf(this.getExceptionProperties()) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetElementsResponse that = (AssetElementsResponse)((Object)objectToCompare);
        return Objects.equals(this.elementList, that.elementList);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementList);
    }
}

