/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.InformalTagElement;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InformalTagsResponse
extends AssetManagerOMASAPIResponse {
    private List<InformalTagElement> tags = null;

    public InformalTagsResponse() {
    }

    public InformalTagsResponse(InformalTagsResponse template) {
        super(template);
        if (template != null) {
            this.tags = template.getTags();
        }
    }

    public List<InformalTagElement> getTags() {
        if (this.tags == null) {
            return null;
        }
        if (this.tags.isEmpty()) {
            return null;
        }
        ArrayList<InformalTagElement> clonedList = new ArrayList<InformalTagElement>();
        for (InformalTagElement existingElement : this.tags) {
            clonedList.add(new InformalTagElement(existingElement));
        }
        return clonedList;
    }

    public void setTags(List<InformalTagElement> tags) {
        this.tags = tags;
    }

    @Override
    public String toString() {
        return "InformalTagsResponse{tags=" + String.valueOf(this.tags) + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + String.valueOf(this.getExceptionProperties()) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InformalTagsResponse that = (InformalTagsResponse)((Object)objectToCompare);
        return Objects.equals(this.getTags(), that.getTags());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTags());
    }
}

