/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.DataAssetExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.SchemaExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataAssetExchangeClient
extends SchemaExchangeClientBase
implements DataAssetExchangeInterface {
    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createDataAsset(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String assetExternalIdentifier, String assetExternalIdentifierName, String assetExternalIdentifierUsage, String assetExternalIdentifierSource, KeyPattern assetExternalIdentifierKeyPattern, Map<String, String> mappingProperties, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAsset";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataAsset");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "createDataAsset");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "createDataAsset");
        DataAssetRequestBody requestBody = new DataAssetRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, assetExternalIdentifierName, assetExternalIdentifierUsage, assetExternalIdentifierSource, assetExternalIdentifierKeyPattern, mappingProperties, "createDataAsset"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createDataAssetFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, String assetExternalIdentifier, String assetExternalIdentifierName, String assetExternalIdentifierUsage, String assetExternalIdentifierSource, KeyPattern assetExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAssetFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataAssetFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDataAssetFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDataAssetFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createDataAssetFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, assetExternalIdentifierName, assetExternalIdentifierUsage, assetExternalIdentifierSource, assetExternalIdentifierKeyPattern, mappingProperties, "createDataAssetFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataAssetFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier, boolean isMergeUpdate, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataAsset";
        String assetGUIDParameterName = "assetGUID";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateDataAsset");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "updateDataAsset");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "updateDataAsset");
        DataAssetRequestBody requestBody = new DataAssetRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "updateDataAsset"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateDataAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, isMergeUpdate});
    }

    public void publishDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDataAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "publishDataAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishDataAsset", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, assetGUID});
    }

    public void withdrawDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDataAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "withdrawDataAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawDataAsset", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, assetGUID});
    }

    public void removeDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeDataAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeDataAsset", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "removeDataAsset"), new Object[]{this.serverName, userId, assetGUID});
    }

    public void setDataAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setDataAssetAsReferenceData";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "setDataAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setDataAssetAsReferenceData");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/is-reference-data";
        this.restClient.callVoidPostRESTCall("setDataAssetAsReferenceData", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "setDataAssetAsReferenceData"), new Object[]{this.serverName, userId, assetGUID});
    }

    public void clearDataAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataAssetAsReferenceData";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearDataAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "clearDataAssetAsReferenceData");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/is-reference-data/remove";
        this.restClient.callVoidPostRESTCall("clearDataAssetAsReferenceData", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "clearDataAssetAsReferenceData"), new Object[]{this.serverName, userId, assetGUID});
    }

    public List<DataAssetElement> findDataAssets(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataAssets";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDataAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDataAssets");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataAssets");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/by-search-string?startFrom={2}&pageSize={3}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("findDataAssets", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataAssetElement> scanDataAssets(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "scanDataAssets";
        this.invalidParameterHandler.validateUserId(userId, "scanDataAssets");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "scanDataAssets");
        AssetManagerIdentifiersRequestBody requestBody = new AssetManagerIdentifiersRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/scan?startFrom={2}&pageSize={3}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("scanDataAssets", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataAssetElement> getDataAssetsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDataAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDataAssetsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataAssetsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/by-name?startFrom={2}&pageSize={3}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("getDataAssetsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetsForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataAssetsForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getDataAssetsForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataAssetsForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/by-asset-manager?startFrom={2}&pageSize={3}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("getDataAssetsForAssetManager", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DataAssetElement getDataAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetByGUID";
        String guidParameterName = "openMetadataGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataAssetByGUID");
        this.invalidParameterHandler.validateGUID(openMetadataGUID, "openMetadataGUID", "getDataAssetByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/retrieve";
        DataAssetElementResponse restResult = this.restClient.callDataAssetPostRESTCall("getDataAssetByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, openMetadataGUID);
        return restResult.getElement();
    }
}

