/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CalculatedValueClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeaderResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ForeignKeyRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PrimaryKeyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class SchemaExchangeClientBase
extends ExchangeClientBase
implements SchemaExchangeInterface {
    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createSchemaType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaTypeExternalIdentifier, String schemaTypeExternalIdentifierName, String schemaTypeExternalIdentifierUsage, String schemaTypeExternalIdentifierSource, KeyPattern schemaTypeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaType";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", "createSchemaType");
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody();
        requestBody.setElementProperties(schemaTypeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaTypeExternalIdentifier, schemaTypeExternalIdentifierName, schemaTypeExternalIdentifierUsage, schemaTypeExternalIdentifierSource, schemaTypeExternalIdentifierKeyPattern, mappingProperties, "createSchemaType"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createSchemaTypeFromTemplate(String userId, String assetManagerGUID, String assetManagerName, String templateGUID, String schemaTypeExternalIdentifier, String schemaTypeExternalIdentifierName, String schemaTypeExternalIdentifierUsage, String schemaTypeExternalIdentifierSource, KeyPattern schemaTypeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createSchemaTypeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaTypeExternalIdentifier, schemaTypeExternalIdentifierName, schemaTypeExternalIdentifierUsage, schemaTypeExternalIdentifierSource, schemaTypeExternalIdentifierKeyPattern, mappingProperties, "createSchemaTypeFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaTypeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateSchemaType(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String schemaTypeExternalIdentifier, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaType";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "updateSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "updateSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", "updateSchemaType");
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody();
        requestBody.setElementProperties(schemaTypeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaTypeExternalIdentifier, "updateSchemaType"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaTypeGUID, isMergeUpdate});
    }

    public void setupSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSchemaTypeParent";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "setupSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "setupSchemaTypeParent");
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", "setupSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/{2}/parent/{3}/{4}?assetManagerIsHome={5}";
        this.restClient.callVoidPostRESTCall("setupSchemaTypeParent", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, schemaTypeGUID, parentElementGUID, parentElementTypeName, assetManagerIsHome});
    }

    public void clearSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaTypeParent";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "clearSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "clearSchemaTypeParent");
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", "clearSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/{2}/parent/{3}/{4}/remove";
        this.restClient.callVoidPostRESTCall("clearSchemaTypeParent", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, schemaTypeGUID, parentElementGUID, parentElementTypeName});
    }

    public void removeSchemaType(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String schemaTypeExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaType";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "removeSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeSchemaType", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaTypeExternalIdentifier, "removeSchemaType"), new Object[]{this.serverName, userId, schemaTypeGUID});
    }

    public List<SchemaTypeElement> findSchemaType(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaType";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaType");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaType");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaType");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/by-search-string?startFrom={2}&pageSize={3}";
        SchemaTypeElementsResponse restResult = this.restClient.callSchemaTypesPostRESTCall("findSchemaType", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public SchemaTypeElement getSchemaTypeForElement(String userId, String assetManagerGUID, String assetManagerName, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeForElement";
        String guidParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeForElement");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "getSchemaTypeForElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/elements/{2}/retrieve";
        SchemaTypeElementResponse restResult = this.restClient.callSchemaTypePostRESTCall("getSchemaTypeForElement", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, parentElementGUID);
        return restResult.getElement();
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaTypeByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaTypeByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/by-name?startFrom={2}&pageSize={3}";
        SchemaTypeElementsResponse restResult = this.restClient.callSchemaTypesPostRESTCall("getSchemaTypeByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public SchemaTypeElement getSchemaTypeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByGUID");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/{2}/retrieve";
        SchemaTypeElementResponse restResult = this.restClient.callSchemaTypePostRESTCall("getSchemaTypeByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, schemaTypeGUID);
        return restResult.getElement();
    }

    public ElementHeader getSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeParent";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/elements/{2}/retrieve";
        ElementHeaderResponse restResult = this.restClient.callElementHeaderPostRESTCall("getSchemaTypeParent", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, schemaTypeGUID);
        return restResult.getElement();
    }

    public String createSchemaAttribute(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaElementGUID, String schemaAttributeExternalIdentifier, String schemaAttributeExternalIdentifierName, String schemaAttributeExternalIdentifierUsage, String schemaAttributeExternalIdentifierSource, KeyPattern schemaAttributeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaAttribute");
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", "createSchemaAttribute");
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", "createSchemaAttribute");
        SchemaAttributeRequestBody requestBody = new SchemaAttributeRequestBody();
        requestBody.setElementProperties(schemaAttributeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, schemaAttributeExternalIdentifierName, schemaAttributeExternalIdentifierUsage, schemaAttributeExternalIdentifierSource, schemaAttributeExternalIdentifierKeyPattern, mappingProperties, "createSchemaAttribute"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaAttribute", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createSchemaAttributeFromTemplate(String userId, String assetManagerGUID, String assetManagerName, String templateGUID, String schemaAttributeExternalIdentifier, String schemaAttributeExternalIdentifierName, String schemaAttributeExternalIdentifierUsage, String schemaAttributeExternalIdentifierSource, KeyPattern schemaAttributeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttributeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createSchemaAttributeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, schemaAttributeExternalIdentifierName, schemaAttributeExternalIdentifierUsage, schemaAttributeExternalIdentifierSource, schemaAttributeExternalIdentifierKeyPattern, mappingProperties, "createSchemaAttributeFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaAttributeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateSchemaAttribute(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaAttribute";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "updateSchemaAttribute");
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", "updateSchemaAttribute");
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", "updateSchemaAttribute");
        SchemaAttributeRequestBody requestBody = new SchemaAttributeRequestBody();
        requestBody.setElementProperties(schemaAttributeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, "updateSchemaAttribute"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attribute/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateSchemaAttribute", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID, isMergeUpdate});
    }

    public void setSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, String schemaElementGUID, String schemaElementExternalIdentifier, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setSchemaElementAsCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "setSchemaElementAsCalculatedValue");
        CalculatedValueClassificationRequestBody requestBody = new CalculatedValueClassificationRequestBody();
        requestBody.setFormula(formula);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaElementExternalIdentifier, "setSchemaElementAsCalculatedValue"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-elements/{2}/is-calculated-value";
        this.restClient.callVoidPostRESTCall("setSchemaElementAsCalculatedValue", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaElementGUID});
    }

    public void clearSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, String schemaElementGUID, String schemaElementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaElementAsCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "clearSchemaElementAsCalculatedValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-elements/{2}/is-calculated-value/remove";
        this.restClient.callVoidPostRESTCall("clearSchemaElementAsCalculatedValue", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaElementExternalIdentifier, "clearSchemaElementAsCalculatedValue"), new Object[]{this.serverName, userId, schemaElementGUID});
    }

    public void setupColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, String primaryKeyName, KeyPattern primaryKeyPattern) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupColumnAsPrimaryKey";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupColumnAsPrimaryKey");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "setupColumnAsPrimaryKey");
        PrimaryKeyClassificationRequestBody requestBody = new PrimaryKeyClassificationRequestBody();
        PrimaryKeyProperties primaryKeyProperties = new PrimaryKeyProperties();
        primaryKeyProperties.setName(primaryKeyName);
        primaryKeyProperties.setKeyPattern(primaryKeyPattern);
        requestBody.setPrimaryKeyProperties(primaryKeyProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, "setupColumnAsPrimaryKey"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/{2}/is-primary-key?assetManagerIsHome={3}";
        this.restClient.callVoidPostRESTCall("setupColumnAsPrimaryKey", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID, assetManagerIsHome});
    }

    public void clearColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String schemaAttributeExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearColumnAsPrimaryKey";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearColumnAsPrimaryKey");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "clearColumnAsPrimaryKey");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/{2}/is-primary-key/remove";
        this.restClient.callVoidPostRESTCall("clearColumnAsPrimaryKey", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, "clearColumnAsPrimaryKey"), new Object[]{this.serverName, userId, schemaAttributeGUID});
    }

    public void setupForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupForeignKeyRelationship";
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", "setupForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", "setupForeignKeyRelationship");
        ForeignKeyRequestBody requestBody = new ForeignKeyRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(foreignKeyProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/{2}/relationships/foreign-keys/{3}?assetManagerIsHome={4}";
        this.restClient.callVoidPostRESTCall("setupForeignKeyRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryKeyGUID, foreignKeyGUID, assetManagerIsHome});
    }

    public void updateForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateForeignKeyRelationship";
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", "updateForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", "updateForeignKeyRelationship");
        ForeignKeyRequestBody requestBody = new ForeignKeyRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(foreignKeyProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/{2}/relationships/foreign-keys/{3}/update";
        this.restClient.callVoidPostRESTCall("updateForeignKeyRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryKeyGUID, foreignKeyGUID});
    }

    public void clearForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearForeignKeyRelationship";
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", "clearForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", "clearForeignKeyRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/glossaries/terms/{2}/relationships/{3}/terms/{4}/remove";
        this.restClient.callVoidPostRESTCall("clearForeignKeyRelationship", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, primaryKeyGUID, foreignKeyGUID});
    }

    public void removeSchemaAttribute(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String schemaAttributeExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaAttribute";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "removeSchemaAttribute");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeSchemaAttribute", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, "removeSchemaAttribute"), new Object[]{this.serverName, userId, schemaAttributeGUID});
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaAttributes";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaAttributes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaAttributes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaAttributes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/by-search-string?startFrom={2}&pageSize={3}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("findSchemaAttributes", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<SchemaAttributeElement> getAttributesForSchemaType(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAttributesForSchemaType";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAttributesForSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getAttributesForSchemaType");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAttributesForSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-types/{2}/schema-attributes/retrieve?startFrom={3}&pageSize={4}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("getAttributesForSchemaType", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, schemaTypeGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributesByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaAttributesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaAttributesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/by-name?startFrom={2}&pageSize={3}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("getSchemaAttributesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributeByGUID";
        String guidParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributeByGUID");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "getSchemaAttributeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/schema-attributes/{2}/retrieve";
        SchemaAttributeElementResponse restResult = this.restClient.callSchemaAttributePostRESTCall("getSchemaAttributeByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, schemaAttributeGUID);
        return restResult.getElement();
    }
}

