/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.LineageExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.SchemaExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ControlFlowProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFlowProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessCallProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class LineageExchangeClient
extends SchemaExchangeClientBase
implements LineageExchangeInterface {
    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createProcess(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String processExternalIdentifier, String processExternalIdentifierName, String processExternalIdentifierUsage, String processExternalIdentifierSource, KeyPattern processExternalIdentifierKeyPattern, Map<String, String> mappingProperties, ProcessProperties processProperties, ProcessStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createProcess");
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", "createProcess");
        this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", "createProcess");
        ProcessRequestBody requestBody = new ProcessRequestBody();
        requestBody.setElementProperties(processProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, processExternalIdentifier, processExternalIdentifierName, processExternalIdentifierUsage, processExternalIdentifierSource, processExternalIdentifierKeyPattern, mappingProperties, "createProcess"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes?assetManagerIsHome={2}&initialStatus={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createProcess", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome, initialStatus});
        return restResult.getGUID();
    }

    public String createProcessFromTemplate(String userId, String assetManagerGUID, String assetManagerName, String templateGUID, String processExternalIdentifier, String processExternalIdentifierName, String processExternalIdentifierUsage, String processExternalIdentifierSource, KeyPattern processExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createProcessFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createProcessFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createProcessFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createProcessFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, processExternalIdentifier, processExternalIdentifierName, processExternalIdentifierUsage, processExternalIdentifierSource, processExternalIdentifierKeyPattern, mappingProperties, "createProcessFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createProcessFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String processExternalIdentifier, boolean isMergeUpdate, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        String processGUIDParameterName = "processGUID";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "updateProcess");
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", "updateProcess");
        this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", "updateProcess");
        ProcessRequestBody requestBody = new ProcessRequestBody();
        requestBody.setElementProperties(processProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, processExternalIdentifier, "updateProcess"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateProcess", urlTemplate, requestBody, new Object[]{this.serverName, userId, processGUID, isMergeUpdate});
    }

    public void updateProcessStatus(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String processExternalIdentifier, ProcessStatus processStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        String portGUIDParameterName = "processGUID";
        String propertiesParameterName = "processStatus";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessStatus");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "updateProcessStatus");
        this.invalidParameterHandler.validateObject((Object)processStatus, "processStatus", "updateProcessStatus");
        ProcessStatusRequestBody requestBody = new ProcessStatusRequestBody();
        requestBody.setProcessStatus(processStatus);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, processExternalIdentifier, "updateProcessStatus"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/status";
        this.restClient.callVoidPostRESTCall("updateProcessStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, processGUID});
    }

    public void setupProcessParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentType containmentType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessParent";
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        String containmentTypeParameterName = "containmentType";
        this.invalidParameterHandler.validateUserId(userId, "setupProcessParent");
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", "setupProcessParent");
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", "setupProcessParent");
        this.invalidParameterHandler.validateEnum((Object)containmentType, "containmentType", "setupProcessParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/parent/{2}/child/{3}?assetManagerIsHome={4}&containmentType={5}";
        this.restClient.callVoidPostRESTCall("setupProcessParent", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, parentProcessGUID, childProcessGUID, assetManagerIsHome, containmentType});
    }

    public void clearProcessParent(String userId, String assetManagerGUID, String assetManagerName, String parentProcessGUID, String childProcessGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessParent";
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearProcessParent");
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", "clearProcessParent");
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", "clearProcessParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/parent/{2}/children/{3}/remove";
        this.restClient.callVoidPostRESTCall("clearProcessParent", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, parentProcessGUID, childProcessGUID});
    }

    public void publishProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishProcess";
        String processGUIDParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "publishProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishProcess", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, processGUID});
    }

    public void withdrawProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawProcess";
        String processGUIDParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "withdrawProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawProcess", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, processGUID});
    }

    public void removeProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String processExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeProcess";
        String processGUIDParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "removeProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeProcess", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, processExternalIdentifier, "removeProcess"), new Object[]{this.serverName, userId, processGUID});
    }

    public List<ProcessElement> findProcesses(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findProcesses";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findProcesses");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findProcesses");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findProcesses");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/by-search-string?startFrom={2}&pageSize={3}";
        ProcessElementsResponse restResult = this.restClient.callProcessesPostRESTCall("findProcesses", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ProcessElement> getProcessesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessesForAssetManager";
        this.invalidParameterHandler.validateUserId(userId, "getProcessesForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProcessesForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/by-asset-manager?startFrom={2}&pageSize={3}";
        ProcessElementsResponse restResult = this.restClient.callProcessesPostRESTCall("getProcessesForAssetManager", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ProcessElement> getProcessesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getProcessesByName");
        this.invalidParameterHandler.validateName(name, "name", "getProcessesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProcessesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/by-name?startFrom={2}&pageSize={3}";
        ProcessElementsResponse restResult = this.restClient.callProcessesPostRESTCall("getProcessesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ProcessElement getProcessByGUID(String userId, String assetManagerGUID, String assetManagerName, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessByGUID";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessByGUID");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getProcessByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/retrieve";
        ProcessElementResponse restResult = this.restClient.callProcessPostRESTCall("getProcessByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, processGUID);
        return restResult.getElement();
    }

    public ProcessElement getProcessParent(String userId, String assetManagerGUID, String assetManagerName, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessParent";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessParent");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getProcessParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/parent/retrieve";
        ProcessElementResponse restResult = this.restClient.callProcessPostRESTCall("getProcessParent", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, processGUID);
        return restResult.getElement();
    }

    public List<ProcessElement> getSubProcesses(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubProcesses";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSubProcesses");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getSubProcesses");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSubProcesses");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/children?startFrom={2}&pageSize={3}";
        ProcessElementsResponse restResult = this.restClient.callProcessesPostRESTCall("getSubProcesses", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public String createPort(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String processGUID, String portExternalIdentifier, String portExternalIdentifierName, String portExternalIdentifierUsage, String portExternalIdentifierSource, KeyPattern portExternalIdentifierKeyPattern, Map<String, String> mappingProperties, PortProperties portProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPort";
        String processGUIDParameterName = "processGUID";
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createPort");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "createPort");
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", "createPort");
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", "createPort");
        PortRequestBody requestBody = new PortRequestBody();
        requestBody.setElementProperties(portProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, portExternalIdentifier, portExternalIdentifierName, portExternalIdentifierUsage, portExternalIdentifierSource, portExternalIdentifierKeyPattern, mappingProperties, "createPort"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "processes/{2}/ports?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPort", urlTemplate, requestBody, new Object[]{this.serverName, userId, processGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updatePort(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String portExternalIdentifier, PortProperties portProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePort";
        String portGUIDParameterName = "portGUID";
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updatePort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "updatePort");
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", "updatePort");
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", "updatePort");
        PortRequestBody requestBody = new PortRequestBody();
        requestBody.setElementProperties(portProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, portExternalIdentifier, "updatePort"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/update";
        this.restClient.callVoidPostRESTCall("updatePort", urlTemplate, requestBody, new Object[]{this.serverName, userId, portGUID});
    }

    public void setupProcessPort(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String processGUID, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessPort";
        String processGUIDParameterName = "processGUID";
        String portGUIDParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupProcessPort");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "setupProcessPort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "setupProcessPort");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/ports/{3}?assetManagerIsHome={4}";
        this.restClient.callVoidPostRESTCall("setupProcessPort", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, processGUID, portGUID, assetManagerIsHome});
    }

    public void clearProcessPort(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessPort";
        String processGUIDParameterName = "processGUID";
        String portGUIDParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearProcessPort");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "clearProcessPort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "clearProcessPort");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/ports/{3}/remove";
        this.restClient.callVoidPostRESTCall("clearProcessPort", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, processGUID, portGUID});
    }

    public void setupPortDelegation(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portOneGUID, String portTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortDelegation";
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupPortDelegation");
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", "setupPortDelegation");
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", "setupPortDelegation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/port-delegations/{3}?assetManagerIsHome={4}";
        this.restClient.callVoidPostRESTCall("setupPortDelegation", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, portOneGUID, portTwoGUID, assetManagerIsHome});
    }

    public void clearPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portOneGUID, String portTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortDelegation";
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearPortDelegation");
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", "clearPortDelegation");
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", "clearPortDelegation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/port-delegations/{3}/remove";
        this.restClient.callVoidPostRESTCall("clearPortDelegation", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, portOneGUID, portTwoGUID});
    }

    public void setupPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortSchemaType";
        String portGUIDParameterName = "portGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupPortSchemaType");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "setupPortSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "setupPortSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/schemaType/{3}?assetManagerIsHome={4}";
        this.restClient.callVoidPostRESTCall("setupPortSchemaType", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, portGUID, schemaTypeGUID, assetManagerIsHome});
    }

    public void clearPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortSchemaType";
        String portGUIDParameterName = "portGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearPortSchemaType");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "clearPortSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "clearPortSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/schemaType/{3}/remove";
        this.restClient.callVoidPostRESTCall("clearPortSchemaType", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, portGUID, schemaTypeGUID});
    }

    public void removePort(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String portExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removePort";
        String portGUIDParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "removePort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "removePort");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/remove";
        this.restClient.callVoidPostRESTCall("removePort", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, portExternalIdentifier, "removePort"), new Object[]{this.serverName, userId, portGUID});
    }

    public List<PortElement> findPorts(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findPorts";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findPorts");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findPorts");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findPorts");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/by-search-string?startFrom={2}&pageSize={3}";
        PortElementsResponse restResult = this.restClient.callPortsPostRESTCall("findPorts", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<PortElement> getPortsForProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortsForProcess";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortsForProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getPortsForProcess");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getPortsForProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/processes/{2}/ports/retrieve?startFrom={3}&pageSize={4}";
        PortElementsResponse restResult = this.restClient.callPortsPostRESTCall("getPortsForProcess", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, processGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<PortElement> getPortUse(String userId, String assetManagerGUID, String assetManagerName, String portGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortUse";
        String guidParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortUse");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "getPortUse");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getPortUse");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/used-by/retrieve?startFrom={3}&pageSize={4}";
        PortElementsResponse restResult = this.restClient.callPortsPostRESTCall("getPortUse", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, portGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public PortElement getPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortDelegation";
        String guidParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortDelegation");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "getPortDelegation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/port-delegations/retrieve";
        PortElementResponse restResult = this.restClient.callPortPostRESTCall("getPortDelegation", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, portGUID);
        return restResult.getElement();
    }

    public List<PortElement> getPortsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getPortsByName");
        this.invalidParameterHandler.validateName(name, "name", "getPortsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getPortsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/by-name?startFrom={2}&pageSize={3}";
        PortElementsResponse restResult = this.restClient.callPortsPostRESTCall("getPortsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public PortElement getPortByGUID(String userId, String assetManagerGUID, String assetManagerName, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortByGUID";
        String guidParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortByGUID");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "getPortByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/ports/{2}/retrieve";
        PortElementResponse restResult = this.restClient.callPortPostRESTCall("getPortByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, portGUID);
        return restResult.getElement();
    }

    public void setBusinessSignificant(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setBusinessSignificant";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setBusinessSignificant");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "setBusinessSignificant");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/elements/{2}/is-business-significant";
        this.restClient.callVoidPostRESTCall("setBusinessSignificant", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, elementExternalIdentifier, "setBusinessSignificant"), new Object[]{this.serverName, userId, elementGUID});
    }

    public void clearBusinessSignificant(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearBusinessSignificant";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearBusinessSignificant");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "clearBusinessSignificant");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/elements/{2}/is-business-significant/remove";
        this.restClient.callVoidPostRESTCall("clearBusinessSignificant", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, elementExternalIdentifier, "clearBusinessSignificant"), new Object[]{this.serverName, userId, elementGUID});
    }

    public String setupDataFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupDataFlow");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "setupDataFlow");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "setupDataFlow");
        DataFlowRequestBody requestBody = new DataFlowRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        DataFlowProperties properties = new DataFlowProperties();
        properties.setQualifiedName(qualifiedName);
        properties.setDescription(description);
        properties.setFormula(formula);
        requestBody.setProperties(properties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-flows/suppliers/{2}/consumers/{3}?assetManagerIsHome={4}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupDataFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataSupplierGUID, dataConsumerGUID, assetManagerIsHome});
        return results.getGUID();
    }

    public DataFlowElement getDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlow");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "getDataFlow");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "getDataFlow");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNameParameterName("qualifiedName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-flows/suppliers/{2}/consumers/{3}/retrieve";
        DataFlowElementResponse restResult = this.restClient.callDataFlowPostRESTCall("getDataFlow", urlTemplate, requestBody, this.serverName, userId, dataSupplierGUID, dataConsumerGUID);
        return restResult.getElement();
    }

    public void updateDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataFlow";
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateDataFlow");
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", "updateDataFlow");
        DataFlowRequestBody requestBody = new DataFlowRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        DataFlowProperties properties = new DataFlowProperties();
        properties.setQualifiedName(qualifiedName);
        properties.setDescription(description);
        properties.setFormula(formula);
        requestBody.setProperties(properties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-flows/{2}/update";
        this.restClient.callVoidPostRESTCall("updateDataFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFlowGUID});
    }

    public void clearDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataFlow";
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearDataFlow");
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", "clearDataFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-flows/{2}/remove";
        this.restClient.callVoidPostRESTCall("clearDataFlow", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, dataFlowGUID});
    }

    public List<DataFlowElement> getDataFlowConsumers(String userId, String assetManagerGUID, String assetManagerName, String dataSupplierGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlowConsumers";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlowConsumers");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "getDataFlowConsumers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-flows/suppliers/{2}/consumers/retrieve";
        DataFlowElementsResponse restResult = this.restClient.callDataFlowsPostRESTCall("getDataFlowConsumers", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, dataSupplierGUID);
        return restResult.getElementList();
    }

    public List<DataFlowElement> getDataFlowSuppliers(String userId, String assetManagerGUID, String assetManagerName, String dataConsumerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlowSuppliers";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlowSuppliers");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "getDataFlowSuppliers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-flows/consumers/{2}/suppliers/retrieve";
        DataFlowElementsResponse restResult = this.restClient.callDataFlowsPostRESTCall("getDataFlowSuppliers", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, dataConsumerGUID);
        return restResult.getElementList();
    }

    public String setupControlFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, String qualifiedName, String description, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupControlFlow";
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupControlFlow");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "setupControlFlow");
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", "setupControlFlow");
        ControlFlowRequestBody requestBody = new ControlFlowRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        ControlFlowProperties properties = new ControlFlowProperties();
        properties.setQualifiedName(qualifiedName);
        properties.setDescription(description);
        properties.setGuard(guard);
        requestBody.setProperties(properties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/control-flows/current-steps/{2}/next-steps/{3}?assetManagerIsHome={4}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupControlFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, currentStepGUID, nextStepGUID, assetManagerIsHome});
        return results.getGUID();
    }

    public ControlFlowElement getControlFlow(String userId, String assetManagerGUID, String assetManagerName, String currentStepGUID, String nextStepGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlow";
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlow");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlow");
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", "getControlFlow");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNameParameterName("qualifiedName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/control-flows/current-steps/{2}/next-steps/{3}/retrieve";
        ControlFlowElementResponse restResult = this.restClient.callControlFlowPostRESTCall("getControlFlow", urlTemplate, requestBody, this.serverName, userId, currentStepGUID, nextStepGUID);
        return restResult.getElement();
    }

    public void updateControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID, String qualifiedName, String description, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateControlFlow";
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateControlFlow");
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", "updateControlFlow");
        ControlFlowRequestBody requestBody = new ControlFlowRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        ControlFlowProperties properties = new ControlFlowProperties();
        properties.setQualifiedName(qualifiedName);
        properties.setDescription(description);
        properties.setGuard(guard);
        requestBody.setProperties(properties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/control-flows/{2}/update";
        this.restClient.callVoidPostRESTCall("updateControlFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, controlFlowGUID});
    }

    public void clearControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearControlFlow";
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearControlFlow");
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", "clearControlFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/control-flows/{2}/remove";
        this.restClient.callVoidPostRESTCall("clearControlFlow", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, controlFlowGUID});
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String userId, String assetManagerGUID, String assetManagerName, String currentStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlowNextSteps";
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlowNextSteps");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlowNextSteps");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/control-flows/current-steps/{2}/next-steps/retrieve";
        ControlFlowElementsResponse restResult = this.restClient.callControlFlowsPostRESTCall("getControlFlowNextSteps", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, currentStepGUID);
        return restResult.getElementList();
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String userId, String assetManagerGUID, String assetManagerName, String currentStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlowPreviousSteps";
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlowPreviousSteps");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlowPreviousSteps");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/control-flows/current-steps/{2}/previous-steps/retrieve";
        ControlFlowElementsResponse restResult = this.restClient.callControlFlowsPostRESTCall("getControlFlowPreviousSteps", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, currentStepGUID);
        return restResult.getElementList();
    }

    public String setupProcessCall(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String callerGUID, String calledGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessCall";
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupProcessCall");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "setupProcessCall");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "setupProcessCall");
        ProcessCallRequestBody requestBody = new ProcessCallRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        ProcessCallProperties properties = new ProcessCallProperties();
        properties.setQualifiedName(qualifiedName);
        properties.setDescription(description);
        properties.setFormula(formula);
        requestBody.setProperties(properties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/process-calls/callers/{2}/called/{3}?assetManagerIsHome={4}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupProcessCall", urlTemplate, requestBody, new Object[]{this.serverName, userId, callerGUID, calledGUID, assetManagerIsHome});
        return results.getGUID();
    }

    public ProcessCallElement getProcessCall(String userId, String assetManagerGUID, String assetManagerName, String callerGUID, String calledGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCall";
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCall");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "getProcessCall");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "getProcessCall");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNameParameterName("qualifiedName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/process-calls/callers/{2}/called/{3}/retrieve";
        ProcessCallElementResponse restResult = this.restClient.callProcessCallPostRESTCall("getProcessCall", urlTemplate, requestBody, this.serverName, userId, callerGUID, calledGUID);
        return restResult.getElement();
    }

    public void updateProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessCall";
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessCall");
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", "updateProcessCall");
        ProcessCallRequestBody requestBody = new ProcessCallRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        ProcessCallProperties properties = new ProcessCallProperties();
        properties.setQualifiedName(qualifiedName);
        properties.setDescription(description);
        properties.setFormula(formula);
        requestBody.setProperties(properties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/process-calls/{2}/update";
        this.restClient.callVoidPostRESTCall("updateProcessCall", urlTemplate, requestBody, new Object[]{this.serverName, userId, processCallGUID});
    }

    public void clearProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessCall";
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearProcessCall");
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", "clearProcessCall");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/process-calls/{2}/remove";
        this.restClient.callVoidPostRESTCall("clearProcessCall", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, processCallGUID});
    }

    public List<ProcessCallElement> getProcessCalled(String userId, String assetManagerGUID, String assetManagerName, String callerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCalled";
        String callerGUIDParameterName = "callerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCalled");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "getProcessCalled");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/process-calls/callers/{2}/called/retrieve";
        ProcessCallElementsResponse restResult = this.restClient.callProcessCallsPostRESTCall("getProcessCalled", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, callerGUID);
        return restResult.getElementList();
    }

    public List<ProcessCallElement> getProcessCallers(String userId, String assetManagerGUID, String assetManagerName, String calledGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCallers";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCallers");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "getProcessCallers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/process-calls/called/{2}/callers/retrieve";
        ProcessCallElementsResponse restResult = this.restClient.callProcessCallsPostRESTCall("getProcessCallers", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, calledGUID);
        return restResult.getElementList();
    }

    public void setupLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupLineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupLineageMapping");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "setupLineageMapping");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "setupLineageMapping");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/lineage-mappings/sources/{2}/destinations/{3}";
        this.restClient.callVoidPostRESTCall("setupLineageMapping", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, sourceElementGUID, destinationElementGUID});
    }

    public void clearLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLineageMapping");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "clearLineageMapping");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "clearLineageMapping");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/lineage-mappings/sources/{2}/destinations/{3}/remove";
        this.restClient.callVoidPostRESTCall("clearLineageMapping", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, sourceElementGUID, destinationElementGUID});
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDestinationLineageMappings";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDestinationLineageMappings");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "getDestinationLineageMappings");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/lineage-mappings/sources/{2}/destinations/retrieve";
        LineageMappingElementsResponse results = this.restClient.callLineageMappingsPostRESTCall("getDestinationLineageMappings", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, sourceElementGUID);
        return results.getElementList();
    }

    public List<LineageMappingElement> getSourceLineageMappings(String userId, String assetManagerGUID, String assetManagerName, String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSourceLineageMappings";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSourceLineageMappings");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "getSourceLineageMappings");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/lineage-mappings/destinations/{2}/sources/retrieve";
        LineageMappingElementsResponse results = this.restClient.callLineageMappingsPostRESTCall("getSourceLineageMappings", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, destinationElementGUID);
        return results.getElementList();
    }
}

