/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeadersResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class AssetManagerClient
implements AssetManagerInterface {
    private final String assetManagerGUIDParameterName = "assetManagerGUID";
    private final String assetManagerNameParameterName = "assetManagerName";
    private String serverName;
    private String serverPlatformURLRoot;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private AssetManagerRESTClient restClient;
    private AuditLog auditLog = null;
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers";

    public AssetManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
        this.auditLog = auditLog;
    }

    public AssetManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public AssetManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public AssetManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
        this.auditLog = auditLog;
    }

    public AssetManagerClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String createExternalAssetManager(String userId, AssetManagerProperties assetManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalAssetManager";
        String propertiesParameterName = "assetManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createExternalAssetManager");
        this.invalidParameterHandler.validateObject((Object)assetManagerProperties, "assetManagerProperties", "createExternalAssetManager");
        this.invalidParameterHandler.validateName(assetManagerProperties.getQualifiedName(), "qualifiedName", "createExternalAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalAssetManager", urlTemplate, assetManagerProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String getExternalAssetManagerGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalAssetManagerGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getExternalAssetManagerGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getExternalAssetManagerGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers" + "/by-name/{2}";
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getExternalAssetManagerGUID", urlTemplate, new Object[]{this.serverName, userId, qualifiedName});
        return restResult.getGUID();
    }

    public void addExternalIdentifier(String userId, String assetManagerGUID, String assetManagerName, SynchronizationDirection synchronizationDirection, String synchronizationDescription, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, String externalIdentifierSource, KeyPattern keyPattern, Map<String, String> mappingProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "addExternalIdentifier");
        this.invalidParameterHandler.validateName(assetManagerName, "assetManagerName", "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "addExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "addExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers" + "/elements/{2}/{3}/external-identifiers/add";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSynchronizationDirection(synchronizationDirection);
        requestBody.setSynchronizationDescription(synchronizationDescription);
        requestBody.setExternalIdentifier(externalIdentifier);
        requestBody.setExternalIdentifierName(externalIdentifierName);
        requestBody.setExternalIdentifierUsage(externalIdentifierUsage);
        requestBody.setExternalIdentifierSource(externalIdentifierSource);
        requestBody.setKeyPattern(keyPattern);
        requestBody.setMappingProperties(mappingProperties);
        this.restClient.callVoidPostRESTCall("addExternalIdentifier", urlTemplate, requestBody, new Object[]{this.serverName, userId, openMetadataElementTypeName, openMetadataElementGUID});
    }

    public void updateExternalIdentifier(String userId, String assetManagerGUID, String assetManagerName, SynchronizationDirection synchronizationDirection, String synchronizationDescription, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, String externalIdentifierSource, KeyPattern keyPattern, Map<String, String> mappingProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "updateExternalIdentifier");
        this.invalidParameterHandler.validateName(assetManagerName, "assetManagerName", "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "updateExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "updateExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers" + "/elements/{2}/{3}/external-identifiers/update";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSynchronizationDirection(synchronizationDirection);
        requestBody.setSynchronizationDescription(synchronizationDescription);
        requestBody.setExternalIdentifier(externalIdentifier);
        requestBody.setExternalIdentifierName(externalIdentifierName);
        requestBody.setExternalIdentifierUsage(externalIdentifierUsage);
        requestBody.setExternalIdentifierSource(externalIdentifierSource);
        requestBody.setKeyPattern(keyPattern);
        requestBody.setMappingProperties(mappingProperties);
        this.restClient.callVoidPostRESTCall("updateExternalIdentifier", urlTemplate, requestBody, new Object[]{this.serverName, userId, openMetadataElementTypeName, openMetadataElementGUID});
    }

    public void removeExternalIdentifier(String userId, String assetManagerGUID, String assetManagerName, SynchronizationDirection synchronizationDirection, String synchronizationDescription, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, String externalIdentifierSource, KeyPattern keyPattern, Map<String, String> mappingProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "removeExternalIdentifier");
        this.invalidParameterHandler.validateName(assetManagerName, "assetManagerName", "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "removeExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "removeExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers" + "/elements/{2}/{3}/external-identifiers/remove";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSynchronizationDirection(synchronizationDirection);
        requestBody.setSynchronizationDescription(synchronizationDescription);
        requestBody.setExternalIdentifier(externalIdentifier);
        requestBody.setExternalIdentifierName(externalIdentifierName);
        requestBody.setExternalIdentifierUsage(externalIdentifierUsage);
        requestBody.setExternalIdentifierSource(externalIdentifierSource);
        requestBody.setKeyPattern(keyPattern);
        requestBody.setMappingProperties(mappingProperties);
        this.restClient.callVoidPostRESTCall("removeExternalIdentifier", urlTemplate, requestBody, new Object[]{this.serverName, userId, openMetadataElementTypeName, openMetadataElementGUID});
    }

    public void confirmSynchronization(String userId, String assetManagerGUID, String assetManagerName, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "confirmSynchronization";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "confirmSynchronization");
        this.invalidParameterHandler.validateName(assetManagerName, "assetManagerName", "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "confirmSynchronization");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers" + "/elements/{2}/{3}/synchronized";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setExternalIdentifier(externalIdentifier);
        this.restClient.callVoidPostRESTCall("confirmSynchronization", urlTemplate, requestBody, new Object[]{this.serverName, userId, openMetadataElementGUID, openMetadataElementTypeName});
    }

    public List<ElementHeader> getElementsForExternalIdentifier(String userId, String assetManagerGUID, String assetManagerName, String externalIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsForExternalIdentifier";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateName(assetManagerName, "assetManagerName", "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "getElementsForExternalIdentifier");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsForExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers" + "/external-identifiers/open-metadata-elements?startFrom={2}&pageSize={3}";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setExternalIdentifier(externalIdentifier);
        ElementHeadersResponse restResult = this.restClient.callElementHeadersPostRESTCall("getElementsForExternalIdentifier", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }
}

