/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.DataAssetExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.SchemaExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataAssetExchangeClient
extends SchemaExchangeClientBase
implements DataAssetExchangeInterface {
    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createAsset(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String assetExternalIdentifier, String assetExternalIdentifierName, String assetExternalIdentifierUsage, String assetExternalIdentifierSource, KeyPattern assetExternalIdentifierKeyPattern, Map<String, String> mappingProperties, AssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAsset";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAsset");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "createAsset");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "createAsset");
        AssetRequestBody requestBody = new AssetRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, assetExternalIdentifierName, assetExternalIdentifierUsage, assetExternalIdentifierSource, assetExternalIdentifierKeyPattern, mappingProperties, "createAsset"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createAssetFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, String assetExternalIdentifier, String assetExternalIdentifierName, String assetExternalIdentifierUsage, String assetExternalIdentifierSource, KeyPattern assetExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAssetFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createAssetFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createAssetFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createAssetFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, assetExternalIdentifierName, assetExternalIdentifierUsage, assetExternalIdentifierSource, assetExternalIdentifierKeyPattern, mappingProperties, "createAssetFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAssetFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier, boolean isMergeUpdate, AssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAsset";
        String assetGUIDParameterName = "assetGUID";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAsset");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "updateAsset");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "updateAsset");
        AssetRequestBody requestBody = new AssetRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "updateAsset"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, isMergeUpdate});
    }

    public void publishAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "publishAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishAsset", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, assetGUID});
    }

    public void withdrawAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "withdrawAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawAsset", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, assetGUID});
    }

    public void removeAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeAsset", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "removeAsset"), new Object[]{this.serverName, userId, assetGUID});
    }

    public void setAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setAssetAsReferenceData";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "setAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setAssetAsReferenceData");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/is-reference-data";
        this.restClient.callVoidPostRESTCall("setAssetAsReferenceData", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "setAssetAsReferenceData"), new Object[]{this.serverName, userId, assetGUID});
    }

    public void clearAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetAsReferenceData";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "clearAssetAsReferenceData");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/is-reference-data/remove";
        this.restClient.callVoidPostRESTCall("clearAssetAsReferenceData", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "clearAssetAsReferenceData"), new Object[]{this.serverName, userId, assetGUID});
    }

    public List<AssetElement> findAssets(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findAssets";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAssets");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findAssets");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/by-search-string?startFrom={2}&pageSize={3}";
        AssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("findAssets", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<AssetElement> scanAssets(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "scanAssets";
        this.invalidParameterHandler.validateUserId(userId, "scanAssets");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "scanAssets");
        AssetManagerIdentifiersRequestBody requestBody = new AssetManagerIdentifiersRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/scan?startFrom={2}&pageSize={3}";
        AssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("scanAssets", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<AssetElement> getAssetsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAssetsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAssetsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/by-name?startFrom={2}&pageSize={3}";
        AssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("getAssetsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<AssetElement> getAssetsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetsForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getAssetsForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAssetsForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/by-asset-manager?startFrom={2}&pageSize={3}";
        AssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("getAssetsForAssetManager", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public AssetElement getAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetByGUID";
        String guidParameterName = "openMetadataGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetByGUID");
        this.invalidParameterHandler.validateGUID(openMetadataGUID, "openMetadataGUID", "getAssetByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}" + "/data-assets/{2}/retrieve";
        AssetElementResponse restResult = this.restClient.callDataAssetPostRESTCall("getAssetByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, openMetadataGUID);
        return restResult.getElement();
    }
}

