/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.ConnectionExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ConnectionExchangeClient
extends ExchangeClientBase
implements ConnectionExchangeInterface {
    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionExternalIdentifier, String connectionExternalIdentifierName, String connectionExternalIdentifierUsage, String connectionExternalIdentifierSource, KeyPattern connectionExternalIdentifierKeyPattern, Map<String, String> mappingProperties, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        String propertiesParameterName = "connectionProperties";
        String qualifiedNameParameterName = "connectionProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionProperties", "createConnection");
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionProperties.qualifiedName", "createConnection");
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setElementProperties(connectionProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectionExternalIdentifier, connectionExternalIdentifierName, connectionExternalIdentifierUsage, connectionExternalIdentifierSource, connectionExternalIdentifierKeyPattern, mappingProperties, "createConnection"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createConnectionFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, String connectionExternalIdentifier, String connectionExternalIdentifierName, String connectionExternalIdentifierUsage, String connectionExternalIdentifierSource, KeyPattern connectionExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectionFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createConnectionFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectionExternalIdentifier, connectionExternalIdentifierName, connectionExternalIdentifierUsage, connectionExternalIdentifierSource, connectionExternalIdentifierKeyPattern, mappingProperties, "createConnectionFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectionFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateConnection(String userId, String assetManagerGUID, String assetManagerName, String connectorTypeGUID, String connectionExternalIdentifier, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        String propertiesParameterName = "connectionProperties";
        String qualifiedNameParameterName = "connectionProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnection");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "updateConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionProperties", "updateConnection");
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionProperties.qualifiedName", "updateConnection");
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setElementProperties(connectionProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectionExternalIdentifier, "updateConnection"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectorTypeGUID, isMergeUpdate});
    }

    public void setupConnectorType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "setupConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/connector-types/{3}?assetManagerIsHome={4}";
        this.restClient.callVoidPostRESTCall("setupConnectorType", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID, assetManagerIsHome});
    }

    public void clearConnectorType(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "clearConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/connector-types/{3}/delete}";
        this.restClient.callVoidPostRESTCall("clearConnectorType", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID});
    }

    public void setupEndpoint(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "setupEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/endpoints/{3}?assetManagerIsHome={4}";
        this.restClient.callVoidPostRESTCall("setupEndpoint", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, connectionGUID, endpointGUID, assetManagerIsHome});
    }

    public void clearEndpoint(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "clearEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/endpoints/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearEndpoint", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, connectionGUID, endpointGUID});
    }

    public void setupEmbeddedConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "setupEmbeddedConnection");
        EmbeddedConnectionRequestBody requestBody = new EmbeddedConnectionRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setPosition(position);
        requestBody.setDisplayName(displayName);
        requestBody.setArguments(arguments);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/embedded-connections/{3}?assetManagerIsHome={4}";
        this.restClient.callVoidPostRESTCall("setupEmbeddedConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID, assetManagerIsHome});
    }

    public void clearEmbeddedConnection(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "clearEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/embedded-connections/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearEmbeddedConnection", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID});
    }

    public void setupAssetConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        String assetGUIDParameterName = "assetGUID";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/connections/{3}?assetManagerIsHome={4}";
        AssetConnectionRequestBody requestBody = new AssetConnectionRequestBody();
        requestBody.setAssetSummary(assetSummary);
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        this.restClient.callVoidPostRESTCall("setupAssetConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, connectionGUID, assetManagerIsHome});
    }

    public void clearAssetConnection(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        String assetGUIDParameterName = "assetGUID";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/connections/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearAssetConnection", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), new Object[]{this.serverName, userId, assetGUID, connectionGUID});
    }

    public void removeConnection(String userId, String assetManagerGUID, String assetManagerName, String connectorTypeGUID, String connectionExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnection");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "removeConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeConnection", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectionExternalIdentifier, "removeConnection"), new Object[]{this.serverName, userId, connectorTypeGUID});
    }

    public List<ConnectionElement> findConnections(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnections";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnections");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnections");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnections");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/by-search-string?startFrom={2}&pageSize={3}";
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("findConnections", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ConnectionElement> getConnectionsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectionsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/by-name?startFrom={2}&pageSize={3}";
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("getConnectionsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ConnectionElement> getConnectionsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionsForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionsForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getConnectionsForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionsForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/by-asset-manager?startFrom={2}&pageSize={3}";
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("getConnectionsForAssetManager", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ConnectionElement getConnectionByGUID(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByGUID";
        String guidParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectionByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/retrieve";
        ConnectionResponse restResult = this.restClient.callConnectionPostRESTCall("getConnectionByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, connectionGUID);
        return restResult.getElement();
    }

    public String createEndpoint(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String endpointExternalIdentifier, String endpointExternalIdentifierName, String endpointExternalIdentifierUsage, String endpointExternalIdentifierSource, KeyPattern endpointExternalIdentifierKeyPattern, Map<String, String> mappingProperties, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpoint";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "endpointProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "createEndpoint");
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", "createEndpoint");
        EndpointRequestBody requestBody = new EndpointRequestBody();
        requestBody.setElementProperties(endpointProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, endpointExternalIdentifier, endpointExternalIdentifierName, endpointExternalIdentifierUsage, endpointExternalIdentifierSource, endpointExternalIdentifierKeyPattern, mappingProperties, "createEndpoint"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createEndpointFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, String endpointExternalIdentifier, String endpointExternalIdentifierName, String endpointExternalIdentifierUsage, String endpointExternalIdentifierSource, KeyPattern endpointExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEndpointFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createEndpointFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, endpointExternalIdentifier, endpointExternalIdentifierName, endpointExternalIdentifierUsage, endpointExternalIdentifierSource, endpointExternalIdentifierKeyPattern, mappingProperties, "createEndpointFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpointFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateEndpoint(String userId, String assetManagerGUID, String assetManagerName, String endpointGUID, String endpointExternalIdentifier, boolean isMergeUpdate, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "endpointProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "updateEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "updateEndpoint");
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", "updateEndpoint");
        EndpointRequestBody requestBody = new EndpointRequestBody();
        requestBody.setElementProperties(endpointProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, endpointExternalIdentifier, "updateEndpoint"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, endpointGUID, isMergeUpdate});
    }

    public void removeEndpoint(String userId, String assetManagerGUID, String assetManagerName, String connectorTypeGUID, String endpointExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeEndpoint");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "removeEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeEndpoint", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, endpointExternalIdentifier, "removeEndpoint"), new Object[]{this.serverName, userId, connectorTypeGUID});
    }

    public List<EndpointElement> findEndpoints(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEndpoints";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findEndpoints");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findEndpoints");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findEndpoints");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/by-search-string?startFrom={2}&pageSize={3}";
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("findEndpoints", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<EndpointElement> getEndpointsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsByName");
        this.invalidParameterHandler.validateName(name, "name", "getEndpointsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/by-name?startFrom={2}&pageSize={3}";
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("getEndpointsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<EndpointElement> getEndpointsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getEndpointsForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/by-asset-manager?startFrom={2}&pageSize={3}";
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("getEndpointsForAssetManager", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public EndpointElement getEndpointByGUID(String userId, String assetManagerGUID, String assetManagerName, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointByGUID";
        String guidParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointByGUID");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "getEndpointByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/{2}/retrieve";
        EndpointResponse restResult = this.restClient.callEndpointPostRESTCall("getEndpointByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, endpointGUID);
        return restResult.getElement();
    }

    public String createConnectorType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectorTypeExternalIdentifier, String connectorTypeExternalIdentifierName, String connectorTypeExternalIdentifierUsage, String connectorTypeExternalIdentifierSource, KeyPattern connectorTypeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, ConnectorTypeProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorType";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectorType");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "createConnectorType");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "createConnectorType");
        ConnectorTypeRequestBody requestBody = new ConnectorTypeRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectorTypeExternalIdentifier, connectorTypeExternalIdentifierName, connectorTypeExternalIdentifierUsage, connectorTypeExternalIdentifierSource, connectorTypeExternalIdentifierKeyPattern, mappingProperties, "createConnectorType"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createConnectorTypeFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, String connectorTypeExternalIdentifier, String connectorTypeExternalIdentifierName, String connectorTypeExternalIdentifierUsage, String connectorTypeExternalIdentifierSource, KeyPattern connectorTypeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createConnectorTypeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectorTypeExternalIdentifier, connectorTypeExternalIdentifierName, connectorTypeExternalIdentifierUsage, connectorTypeExternalIdentifierSource, connectorTypeExternalIdentifierKeyPattern, mappingProperties, "createConnectorTypeFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectorTypeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateConnectorType(String userId, String assetManagerGUID, String assetManagerName, String connectorTypeGUID, String connectorTypeExternalIdentifier, boolean isMergeUpdate, ConnectorTypeProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnectorType";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "updateConnectorType");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "updateConnectorType");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "updateConnectorType");
        ConnectorTypeRequestBody requestBody = new ConnectorTypeRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectorTypeExternalIdentifier, "updateConnectorType"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectorTypeGUID, isMergeUpdate});
    }

    public void removeConnectorType(String userId, String assetManagerGUID, String assetManagerName, String connectorTypeGUID, String connectorTypeExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnectorType";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "removeConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeConnectorType", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectorTypeExternalIdentifier, "removeConnectorType"), new Object[]{this.serverName, userId, connectorTypeGUID});
    }

    public List<ConnectorTypeElement> findConnectorTypes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnectorTypes";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnectorTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnectorTypes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnectorTypes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/by-search-string?startFrom={2}&pageSize={3}";
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("findConnectorTypes", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypesByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectorTypesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/by-name?startFrom={2}&pageSize={3}";
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("getConnectorTypesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ConnectorTypeElement> getConnectorTypesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypesForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypesForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getConnectorTypesForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypesForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/by-asset-manager?startFrom={2}&pageSize={3}";
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("getConnectorTypesForAssetManager", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByGUID";
        String guidParameterName = "openMetadataGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByGUID");
        this.invalidParameterHandler.validateGUID(openMetadataGUID, "openMetadataGUID", "getConnectorTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/retrieve";
        ConnectorTypeResponse restResult = this.restClient.callConnectorTypePostRESTCall("getConnectorTypeByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, openMetadataGUID);
        return restResult.getElement();
    }
}

