/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.ffdc.AssetManagerErrorCode;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class ExchangeClientBase {
    final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}";
    String serverName;
    String serverPlatformURLRoot;
    InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    AssetManagerRESTClient restClient;
    AuditLog auditLog = null;

    public ExchangeClientBase(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
        this.auditLog = auditLog;
    }

    public ExchangeClientBase(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public ExchangeClientBase(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
        this.auditLog = auditLog;
    }

    public ExchangeClientBase(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public ExchangeClientBase(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    private void handleMissingScope(String externalIdentifier, String methodName) throws InvalidParameterException {
        String externalIdentifierParameterName = "externalIdentifier";
        throw new InvalidParameterException(AssetManagerErrorCode.NO_SCOPE_FOR_EXTERNAL_ID.getMessageDefinition(new String[]{externalIdentifier, methodName}), this.getClass().getName(), methodName, "externalIdentifier");
    }

    MetadataCorrelationProperties getCorrelationProperties(String assetManagerGUID, String assetManagerName, String externalIdentifier, String methodName) throws InvalidParameterException {
        MetadataCorrelationProperties correlationProperties = new MetadataCorrelationProperties();
        if (assetManagerGUID != null) {
            correlationProperties.setAssetManagerGUID(assetManagerGUID);
            correlationProperties.setAssetManagerName(assetManagerName);
            correlationProperties.setExternalIdentifier(externalIdentifier);
            return correlationProperties;
        }
        if (externalIdentifier != null) {
            this.handleMissingScope(externalIdentifier, methodName);
        }
        return correlationProperties;
    }

    UpdateRequestBody getUpdateRequestBody(String assetManagerGUID, String assetManagerName, String externalIdentifier, Date effectiveTime, String methodName) throws InvalidParameterException {
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifier, methodName));
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    MetadataCorrelationProperties getCorrelationProperties(String assetManagerGUID, String assetManagerName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, String externalIdentifierSource, KeyPattern externalIdentifierKeyPattern, Map<String, String> mappingProperties, String methodName) throws InvalidParameterException {
        MetadataCorrelationProperties correlationProperties = new MetadataCorrelationProperties();
        if (assetManagerGUID != null) {
            correlationProperties.setAssetManagerGUID(assetManagerGUID);
            correlationProperties.setAssetManagerName(assetManagerName);
            if (externalIdentifier != null) {
                correlationProperties.setKeyPattern(KeyPattern.LOCAL_KEY);
                correlationProperties.setExternalIdentifier(externalIdentifier);
                correlationProperties.setExternalIdentifierName(externalIdentifierName);
                correlationProperties.setExternalIdentifierUsage(externalIdentifierUsage);
                correlationProperties.setExternalIdentifierSource(externalIdentifierSource);
                correlationProperties.setKeyPattern(externalIdentifierKeyPattern);
                correlationProperties.setMappingProperties(mappingProperties);
            }
        } else if (externalIdentifier != null) {
            this.handleMissingScope(externalIdentifier, methodName);
        }
        return correlationProperties;
    }

    MetadataCorrelationProperties getCorrelationProperties(String assetManagerGUID, String assetManagerName, ExternalIdentifierProperties externalIdentifierProperties, String methodName) throws InvalidParameterException {
        MetadataCorrelationProperties correlationProperties = new MetadataCorrelationProperties(externalIdentifierProperties);
        if (assetManagerGUID != null) {
            correlationProperties.setAssetManagerGUID(assetManagerGUID);
            correlationProperties.setAssetManagerName(assetManagerName);
        } else if (externalIdentifierProperties != null && externalIdentifierProperties.getExternalIdentifier() != null) {
            this.handleMissingScope(externalIdentifierProperties.getExternalIdentifier(), methodName);
        }
        return correlationProperties;
    }

    AssetManagerIdentifiersRequestBody getAssetManagerIdentifiersRequestBody(String assetManagerGUID, String assetManagerName) {
        AssetManagerIdentifiersRequestBody requestBody = new AssetManagerIdentifiersRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        return requestBody;
    }

    EffectiveTimeQueryRequestBody getEffectiveTimeQueryRequestBody(String assetManagerGUID, String assetManagerName, Date effectiveTime) {
        EffectiveTimeQueryRequestBody requestBody = new EffectiveTimeQueryRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    RelationshipRequestBody getRelationshipRequestBody(String assetManagerGUID, String assetManagerName, Date effectiveTime, RelationshipProperties relationshipProperties) {
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setProperties(relationshipProperties);
        return requestBody;
    }

    NameRequestBody getNameRequestBody(String assetManagerGUID, String assetManagerName, String name, String nameParameterName, Date effectiveTime) {
        NameRequestBody requestBody = new NameRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setName(name);
        requestBody.setNameParameterName(nameParameterName);
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    NameRequestBody getNameRequestBody(String assetManagerGUID, String assetManagerName, String name, Date effectiveTime, String methodName) throws InvalidParameterException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateName(name, "name", methodName);
        return this.getNameRequestBody(assetManagerGUID, assetManagerName, name, "name", effectiveTime);
    }

    NameRequestBody getQualifiedNameRequestBody(String assetManagerGUID, String assetManagerName, String qualifiedName, Date effectiveTime) {
        String nameParameterName = "qualifiedName";
        return this.getNameRequestBody(assetManagerGUID, assetManagerName, qualifiedName, "qualifiedName", effectiveTime);
    }

    SearchStringRequestBody getSearchStringRequestBody(String assetManagerGUID, String assetManagerName, String searchString, Date effectiveTime, String methodName) throws InvalidParameterException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }
}

