/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.GlossaryExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalGlossaryLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryElementLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermActivityType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermContextDefinition;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationship;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ActivityTermClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CanonicalVocabularyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ContextDefinitionClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryElementLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TaxonomyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TermRelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GlossaryExchangeClient
extends ExchangeClientBase
implements GlossaryExchangeInterface {
    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createGlossary(String userId, String assetManagerGUID, String assetManagerName, ExternalIdentifierProperties externalIdentifierProperties, GlossaryProperties glossaryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossary";
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createGlossary");
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", "createGlossary");
        this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", "createGlossary");
        GlossaryRequestBody requestBody = new GlossaryRequestBody();
        requestBody.setElementProperties(glossaryProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossary"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossary", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createGlossaryFromTemplate(String userId, String assetManagerGUID, String assetManagerName, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createGlossaryFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createGlossaryFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createGlossaryFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createGlossaryFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossaryFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossaryFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, GlossaryProperties glossaryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "updateGlossary");
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", "updateGlossary");
        this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", "updateGlossary");
        GlossaryRequestBody requestBody = new GlossaryRequestBody();
        requestBody.setElementProperties(glossaryProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryExternalIdentifier, "updateGlossary"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}";
        this.restClient.callVoidPostRESTCall("updateGlossary", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryGUID});
    }

    public void setGlossaryAsTaxonomy(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, String organizingPrinciple) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsTaxonomy";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "setGlossaryAsTaxonomy");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "setGlossaryAsTaxonomy");
        TaxonomyClassificationRequestBody requestBody = new TaxonomyClassificationRequestBody();
        requestBody.setOrganizingPrinciple(organizingPrinciple);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryExternalIdentifier, "setGlossaryAsTaxonomy"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-taxonomy";
        this.restClient.callVoidPostRESTCall("setGlossaryAsTaxonomy", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryGUID});
    }

    public void clearGlossaryAsTaxonomy(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsTaxonomy";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearGlossaryAsTaxonomy");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "clearGlossaryAsTaxonomy");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-taxonomy/remove";
        this.restClient.callVoidPostRESTCall("clearGlossaryAsTaxonomy", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryExternalIdentifier, "clearGlossaryAsTaxonomy"), new Object[]{this.serverName, userId, glossaryGUID});
    }

    public void setGlossaryAsCanonical(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, String scope) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsCanonical";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "setGlossaryAsCanonical");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "setGlossaryAsCanonical");
        CanonicalVocabularyClassificationRequestBody requestBody = new CanonicalVocabularyClassificationRequestBody();
        requestBody.setScope(scope);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryExternalIdentifier, "setGlossaryAsCanonical"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-canonical";
        this.restClient.callVoidPostRESTCall("setGlossaryAsCanonical", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryGUID});
    }

    public void clearGlossaryAsCanonical(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsCanonical";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearGlossaryAsCanonical");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "clearGlossaryAsCanonical");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-canonical/remove";
        this.restClient.callVoidPostRESTCall("clearGlossaryAsCanonical", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryExternalIdentifier, "clearGlossaryAsCanonical"), new Object[]{this.serverName, userId, glossaryGUID});
    }

    public void removeGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "removeGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeGlossary", urlTemplate, this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryExternalIdentifier, "removeGlossary"), new Object[]{this.serverName, userId, glossaryGUID});
    }

    public List<GlossaryElement> findGlossaries(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGlossaries";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findGlossaries");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGlossaries");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGlossaries");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-search-string?startFrom={2}&pageSize={3}";
        GlossaryElementsResponse restResult = this.restClient.callGlossariesPostRESTCall("findGlossaries", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<GlossaryElement> getGlossariesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossariesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getGlossariesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGlossariesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossariesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-name?startFrom={2}&pageSize={3}";
        GlossaryElementsResponse restResult = this.restClient.callGlossariesPostRESTCall("getGlossariesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<GlossaryElement> getGlossariesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossariesForAssetManager";
        this.invalidParameterHandler.validateUserId(userId, "getGlossariesForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossariesForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-asset-manager?startFrom={2}&pageSize={3}";
        GlossaryElementsResponse restResult = this.restClient.callGlossariesPostRESTCall("getGlossariesForAssetManager", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public GlossaryElement getGlossaryByGUID(String userId, String assetManagerGUID, String assetManagerName, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGlossaryByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/retrieve";
        GlossaryElementResponse restResult = this.restClient.callGlossaryPostRESTCall("getGlossaryByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, ExternalIdentifierProperties externalIdentifierProperties, GlossaryCategoryProperties glossaryCategoryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryCategory";
        String guidParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createGlossaryCategory");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "createGlossaryCategory");
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", "createGlossaryCategory");
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", "createGlossaryCategory");
        GlossaryCategoryRequestBody requestBody = new GlossaryCategoryRequestBody();
        requestBody.setElementProperties(glossaryCategoryProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossaryCategory"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/categories";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossaryCategory", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryGUID});
        return restResult.getGUID();
    }

    public String createGlossaryCategoryFromTemplate(String userId, String assetManagerGUID, String assetManagerName, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryCategoryFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createGlossaryCategoryFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createGlossaryCategoryFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createGlossaryCategoryFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createGlossaryCategoryFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossaryCategoryFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/from-template/{1}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossaryCategoryFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryCategoryExternalIdentifier, boolean isMergeUpdate, GlossaryCategoryProperties glossaryCategoryProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryCategory";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateGlossaryCategory");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "updateGlossaryCategory");
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", "updateGlossaryCategory");
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", "updateGlossaryCategory");
        GlossaryCategoryRequestBody requestBody = new GlossaryCategoryRequestBody();
        requestBody.setElementProperties(glossaryCategoryProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryCategoryExternalIdentifier, "updateGlossaryCategory"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateGlossaryCategory", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryCategoryGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void setupCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupCategoryParent";
        String glossaryParentGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryChildCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupCategoryParent");
        this.invalidParameterHandler.validateGUID(glossaryParentCategoryGUID, "glossaryParentCategoryGUID", "setupCategoryParent");
        this.invalidParameterHandler.validateGUID(glossaryChildCategoryGUID, "glossaryChildCategoryGUID", "setupCategoryParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/subcategories/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("setupCategoryParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing});
    }

    public void clearCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCategoryParent";
        String glossaryParentGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryChildCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearCategoryParent");
        this.invalidParameterHandler.validateGUID(glossaryParentCategoryGUID, "glossaryParentCategoryGUID", "clearCategoryParent");
        this.invalidParameterHandler.validateGUID(glossaryChildCategoryGUID, "glossaryChildCategoryGUID", "clearCategoryParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/subcategory/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearCategoryParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing});
    }

    public void removeGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryCategoryExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossaryCategory";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeGlossaryCategory");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "removeGlossaryCategory");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeGlossaryCategory", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryCategoryExternalIdentifier, effectiveTime, "removeGlossaryCategory"), new Object[]{this.serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing});
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGlossaryCategories";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findGlossaryCategories");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGlossaryCategories");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGlossaryCategories");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callGlossaryCategoriesPostRESTCall("findGlossaryCategories", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryCategoryElement> getCategoriesForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCategoriesForGlossary";
        String guidParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCategoriesForGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "getCategoriesForGlossary");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCategoriesForGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/categories/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callGlossaryCategoriesPostRESTCall("getCategoriesForGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoriesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoriesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGlossaryCategoriesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossaryCategoriesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callGlossaryCategoriesPostRESTCall("getGlossaryCategoriesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public GlossaryCategoryElement getGlossaryCategoryByGUID(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoryByGUID";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoryByGUID");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getGlossaryCategoryByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryCategoryElementResponse restResult = this.restClient.callGlossaryCategoryPostRESTCall("getGlossaryCategoryByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public GlossaryCategoryElement getGlossaryCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoryParent";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoryParent");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getGlossaryCategoryParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/parent/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryCategoryElementResponse restResult = this.restClient.callGlossaryCategoryPostRESTCall("getGlossaryCategoryParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public List<GlossaryCategoryElement> getGlossarySubCategories(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoriesByName";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoriesByName");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getGlossaryCategoriesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossaryCategoriesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/subcategories/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callGlossaryCategoriesPostRESTCall("getGlossaryCategoriesByName", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryCategoryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public String createGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, ExternalIdentifierProperties externalIdentifierProperties, GlossaryTermProperties glossaryTermProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryTerm";
        String guidParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createGlossaryTerm");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "createGlossaryTerm");
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", "createGlossaryTerm");
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", "createGlossaryTerm");
        GlossaryTermRequestBody requestBody = new GlossaryTermRequestBody();
        requestBody.setElementProperties(glossaryTermProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossaryTerm"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/terms";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossaryTerm", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryGUID});
        return restResult.getGUID();
    }

    public String createControlledGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, ExternalIdentifierProperties externalIdentifierProperties, GlossaryTermProperties glossaryTermProperties, GlossaryTermStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createControlledGlossaryTerm";
        String guidParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createControlledGlossaryTerm");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "createControlledGlossaryTerm");
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", "createControlledGlossaryTerm");
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", "createControlledGlossaryTerm");
        ControlledGlossaryTermRequestBody requestBody = new ControlledGlossaryTermRequestBody();
        requestBody.setElementProperties(glossaryTermProperties);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createControlledGlossaryTerm"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/terms/new-controlled";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createControlledGlossaryTerm", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryGUID});
        return restResult.getGUID();
    }

    public String createGlossaryTermFromTemplate(String userId, String assetManagerGUID, String assetManagerName, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryTermFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createGlossaryTermFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossaryTermFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/from-template/{1}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossaryTermFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, boolean isMergeUpdate, GlossaryTermProperties glossaryTermProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryTerm";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateGlossaryTerm");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "updateGlossaryTerm");
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", "updateGlossaryTerm");
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", "updateGlossaryTerm");
        GlossaryTermRequestBody requestBody = new GlossaryTermRequestBody();
        requestBody.setElementProperties(glossaryTermProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "updateGlossaryTerm"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateGlossaryTerm", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void updateGlossaryTermStatus(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, GlossaryTermStatus glossaryTermStatus, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryTermStatus";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String propertiesParameterName = "glossaryTermStatus";
        this.invalidParameterHandler.validateUserId(userId, "updateGlossaryTermStatus");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "updateGlossaryTermStatus");
        this.invalidParameterHandler.validateObject((Object)glossaryTermStatus, "glossaryTermStatus", "updateGlossaryTermStatus");
        GlossaryTermStatusRequestBody requestBody = new GlossaryTermStatusRequestBody();
        requestBody.setGlossaryTermStatus(glossaryTermStatus);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "updateGlossaryTermStatus"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/status?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updateGlossaryTermStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setupTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, GlossaryTermCategorization categorizationProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupTermCategory";
        String glossaryParentGUIDParameterName = "glossaryCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupTermCategory");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "setupTermCategory");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setupTermCategory");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/terms/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("setupTermCategory", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)categorizationProperties), new Object[]{this.serverName, userId, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermCategory";
        String glossaryParentGUIDParameterName = "glossaryCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermCategory");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "clearTermCategory");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermCategory");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/terms/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearTermCategory", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setupTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupTermRelationship";
        String glossaryParentGUIDParameterName = "glossaryTermOneGUID";
        String glossaryChildGUIDParameterName = "glossaryTermTwoGUID";
        String glossaryTypeParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupTermRelationship");
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, "glossaryTermOneGUID", "setupTermRelationship");
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, "glossaryTermTwoGUID", "setupTermRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupTermRelationship");
        TermRelationshipRequestBody requestBody = new TermRelationshipRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(relationshipsProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/relationships/{3}/terms/{4}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("setupTermRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing});
    }

    public void updateTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateTermRelationship";
        String glossaryParentGUIDParameterName = "glossaryTermOneGUID";
        String glossaryChildGUIDParameterName = "glossaryTermTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateTermRelationship");
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, "glossaryTermOneGUID", "updateTermRelationship");
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, "glossaryTermTwoGUID", "updateTermRelationship");
        TermRelationshipRequestBody requestBody = new TermRelationshipRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(relationshipsProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/relationships/{3}/terms/{4}/update?forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("updateTermRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermRelationship";
        String glossaryParentGUIDParameterName = "glossaryTermOneGUID";
        String glossaryChildGUIDParameterName = "glossaryTermTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermRelationship");
        this.invalidParameterHandler.validateGUID(glossaryTermOneGUID, "glossaryTermOneGUID", "clearTermRelationship");
        this.invalidParameterHandler.validateGUID(glossaryTermTwoGUID, "glossaryTermTwoGUID", "clearTermRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/relationships/{3}/terms/{4}/remove?forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("clearTermRelationship", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing});
    }

    public void setTermAsAbstractConcept(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsAbstractConcept";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setTermAsAbstractConcept");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setTermAsAbstractConcept");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-abstract-concept?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setTermAsAbstractConcept", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "setTermAsAbstractConcept"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermAsAbstractConcept(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsAbstractConcept";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermAsAbstractConcept");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermAsAbstractConcept");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-abstract-concept/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearTermAsAbstractConcept", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "clearTermAsAbstractConcept"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setTermAsDataValue(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsDataValue";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setTermAsDataValue");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setTermAsDataValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-data-value?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setTermAsDataValue", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "setTermAsDataValue"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermAsDataValue(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsDataValue";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermAsDataValue");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermAsDataValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-data-value/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearTermAsDataValue", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "clearTermAsDataValue"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setTermAsActivity(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, GlossaryTermActivityType activityType, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsActivity";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setTermAsActivity");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setTermAsActivity");
        ActivityTermClassificationRequestBody requestBody = new ActivityTermClassificationRequestBody();
        requestBody.setActivityType(activityType);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "setTermAsActivity"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-activity?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setTermAsActivity", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermAsActivity(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsActivity";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermAsActivity");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermAsActivity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-activity/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearTermAsActivity", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "clearTermAsActivity"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setTermAsContext(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, GlossaryTermContextDefinition contextDefinition, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsContext";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setTermAsContext");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setTermAsContext");
        ContextDefinitionClassificationRequestBody requestBody = new ContextDefinitionClassificationRequestBody();
        requestBody.setContextDefinition(contextDefinition);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "setTermAsContext"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-context-definition?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setTermAsContext", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermAsContext(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsContext";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermAsContext");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermAsContext");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-context-definition/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearTermAsContext", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "clearTermAsContext"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setTermAsSpineObject(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsSpineObject";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setTermAsSpineObject");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setTermAsSpineObject");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-object?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setTermAsSpineObject", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "setTermAsSpineObject"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermAsSpineObject(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsSpineObject";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermAsSpineObject");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermAsSpineObject");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-object/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearTermAsSpineObject", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "clearTermAsSpineObject"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setTermAsSpineAttribute(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsSpineAttribute";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setTermAsSpineAttribute");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setTermAsSpineAttribute");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-attribute?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setTermAsSpineAttribute", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "setTermAsSpineAttribute"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermAsSpineAttribute(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsSpineAttribute";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermAsSpineAttribute");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermAsSpineAttribute");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-attribute/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearTermAsSpineAttribute", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "clearTermAsSpineAttribute"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setTermAsObjectIdentifier(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsObjectIdentifier";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "setTermAsObjectIdentifier");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "setTermAsObjectIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-object-identifier?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setTermAsObjectIdentifier", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "setTermAsObjectIdentifier"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void clearTermAsObjectIdentifier(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsObjectIdentifier";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearTermAsObjectIdentifier");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "clearTermAsObjectIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-object-identifier/remove&forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearTermAsObjectIdentifier", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "clearTermAsObjectIdentifier"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void removeGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossaryTerm";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeGlossaryTerm");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "removeGlossaryTerm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeGlossaryTerm", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "removeGlossaryTerm"), new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public List<GlossaryTermElement> findGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGlossaryTerms";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findGlossaryTerms");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGlossaryTerms");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGlossaryTerms");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryTermElementsResponse restResult = this.restClient.callGlossaryTermsPostRESTCall("findGlossaryTerms", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryTermElement> getTermsForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTermsForGlossary";
        String guidParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTermsForGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "getTermsForGlossary");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTermsForGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/terms/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryTermElementsResponse restResult = this.restClient.callGlossaryTermsPostRESTCall("getTermsForGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryTermElement> getTermsForGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTermsForGlossaryCategory";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTermsForGlossaryCategory");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getTermsForGlossaryCategory");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTermsForGlossaryCategory");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/terms/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryTermElementsResponse restResult = this.restClient.callGlossaryTermsPostRESTCall("getTermsForGlossaryCategory", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryCategoryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryTermsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryTermsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGlossaryTermsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossaryTermsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryTermElementsResponse restResult = this.restClient.callGlossaryTermsPostRESTCall("getGlossaryTermsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public GlossaryTermElement getGlossaryTermByGUID(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryTermByGUID";
        String guidParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryTermByGUID");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "getGlossaryTermByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryTermElementResponse restResult = this.restClient.callGlossaryTermPostRESTCall("getGlossaryTermByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public String createExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, ExternalGlossaryLinkProperties linkProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalGlossaryLink";
        String propertiesParameterName = "linkProperties";
        this.invalidParameterHandler.validateUserId(userId, "createExternalGlossaryLink");
        this.invalidParameterHandler.validateObject((Object)linkProperties, "linkProperties", "createExternalGlossaryLink");
        ExternalGlossaryLinkRequestBody requestBody = new ExternalGlossaryLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/external-links";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalGlossaryLink", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, boolean isMergeUpdate, ExternalGlossaryLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalGlossaryLink";
        String guidParameterName = "externalLinkGUID";
        String propertiesParameterName = "linkProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalGlossaryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "updateExternalGlossaryLink");
        this.invalidParameterHandler.validateObject((Object)linkProperties, "linkProperties", "updateExternalGlossaryLink");
        ExternalGlossaryLinkRequestBody requestBody = new ExternalGlossaryLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/external-links/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateExternalGlossaryLink", urlTemplate, requestBody, new Object[]{this.serverName, userId, externalLinkGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void removeExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeExternalGlossaryLink";
        String guidParameterName = "externalLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeExternalGlossaryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "removeExternalGlossaryLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/external-links/{2}/remove&forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeExternalGlossaryLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void attachExternalLinkToGlossary(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalLinkToGlossary";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachExternalLinkToGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "attachExternalLinkToGlossary");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "attachExternalLinkToGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/external-links/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("attachExternalLinkToGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void detachExternalLinkFromGlossary(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalLinkFromGlossary";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachExternalLinkFromGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "detachExternalLinkFromGlossary");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "detachExternalLinkFromGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/external-links/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("detachExternalLinkFromGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public List<ExternalGlossaryLinkElement> getExternalLinksForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalLinksForGlossary";
        String guidParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalLinksForGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "getExternalLinksForGlossary");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalLinksForGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/external-links/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        ExternalGlossaryLinkElementsResponse restResult = this.restClient.callExternalGlossaryLinksPostRESTCall("getExternalLinksForGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryElement> getGlossariesForExternalLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossariesForExternalLink";
        String guidParameterName = "externalLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossariesForExternalLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "getGlossariesForExternalLink");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossariesForExternalLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-external-links/{2}/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryElementsResponse restResult = this.restClient.callGlossariesPostRESTCall("getGlossariesForExternalLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, externalLinkGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public void attachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryCategoryGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalCategoryLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "attachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "attachExternalCategoryLink");
        ExternalGlossaryElementLinkRequestBody requestBody = new ExternalGlossaryElementLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/external-links/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("attachExternalCategoryLink", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryCategoryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void detachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalCategoryLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "detachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "detachExternalCategoryLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/external-links/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("detachExternalCategoryLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryCategoryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void attachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryTermGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalTermLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachExternalTermLink");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "attachExternalTermLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "attachExternalTermLink");
        ExternalGlossaryElementLinkRequestBody requestBody = new ExternalGlossaryElementLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/external-links/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("attachExternalTermLink", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void detachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalTermLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachExternalTermLink");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "detachExternalTermLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "detachExternalTermLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/external-links/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("detachExternalTermLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryTermGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }
}

