/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CalculatedValueClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeaderResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ForeignKeyRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PrimaryKeyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

public class SchemaExchangeClientBase
extends ExchangeClientBase
implements SchemaExchangeInterface {
    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public SchemaExchangeClientBase(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createSchemaType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, boolean forLineage, boolean forDuplicateProcessing, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaType";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", "createSchemaType");
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody();
        requestBody.setElementProperties(schemaTypeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createSchemaType"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-types?assetManagerIsHome={2}&forLineage={3}&forDuplicateProcessing={4}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return restResult.getGUID();
    }

    public String createSchemaTypeFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createSchemaTypeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createSchemaTypeFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-types/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaTypeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateSchemaType(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String schemaTypeExternalIdentifier, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaType";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "updateSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "updateSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", "updateSchemaType");
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody();
        requestBody.setElementProperties(schemaTypeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaTypeExternalIdentifier, "updateSchemaType"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-types/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaTypeGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void setupSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, RelationshipProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSchemaTypeParent";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "setupSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "setupSchemaTypeParent");
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", "setupSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/parents/{2}/{3}/schema-types/{4}?assetManagerIsHome={5}&forLineage={6}&forDuplicateProcessing={7}";
        this.restClient.callVoidPostRESTCall("setupSchemaTypeParent", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, properties), new Object[]{this.serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaTypeParent";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "clearSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "clearSchemaTypeParent");
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", "clearSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/parents/{2}/{3}/schema-types/{4}/remove?forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("clearSchemaTypeParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, forLineage, forDuplicateProcessing});
    }

    public void removeSchemaType(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String schemaTypeExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaType";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "removeSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-types/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeSchemaType", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, schemaTypeExternalIdentifier, effectiveTime, "removeSchemaType"), new Object[]{this.serverName, userId, schemaTypeGUID, forLineage, forDuplicateProcessing});
    }

    public List<SchemaTypeElement> findSchemaType(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaType";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaType");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaType");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaType");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-types/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        SchemaTypeElementsResponse restResult = this.restClient.callSchemaTypesPostRESTCall("findSchemaType", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public SchemaTypeElement getSchemaTypeForElement(String userId, String assetManagerGUID, String assetManagerName, String parentElementGUID, String parentElementTypeName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeForElement";
        String guidParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeForElement");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "getSchemaTypeForElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/parents/{2}/schema-types/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        SchemaTypeElementResponse restResult = this.restClient.callSchemaTypePostRESTCall("getSchemaTypeForElement", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, parentElementGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaTypeByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaTypeByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-types/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        SchemaTypeElementsResponse restResult = this.restClient.callSchemaTypesPostRESTCall("getSchemaTypeByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public SchemaTypeElement getSchemaTypeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByGUID");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-types/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        SchemaTypeElementResponse restResult = this.restClient.callSchemaTypePostRESTCall("getSchemaTypeByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, schemaTypeGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public ElementHeader getSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeParent";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/parents/schema-types/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        ElementHeaderResponse restResult = this.restClient.callElementHeaderPostRESTCall("getSchemaTypeParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, schemaTypeGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public String createSchemaAttribute(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaElementGUID, ExternalIdentifierProperties externalIdentifierProperties, SchemaAttributeProperties schemaAttributeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "createSchemaAttribute");
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", "createSchemaAttribute");
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", "createSchemaAttribute");
        SchemaAttributeRequestBody requestBody = new SchemaAttributeRequestBody();
        requestBody.setElementProperties(schemaAttributeProperties);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createSchemaAttribute"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-elements/{2}/schema-attributes?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaAttribute", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaElementGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return restResult.getGUID();
    }

    public String createSchemaAttributeFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaElementGUID, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttributeFromTemplate";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createSchemaAttributeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createSchemaAttributeFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-elements/{2}/schema-attributes/from-template/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaAttributeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaElementGUID, templateGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return restResult.getGUID();
    }

    public void updateSchemaAttribute(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaAttribute";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "updateSchemaAttribute");
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", "updateSchemaAttribute");
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", "updateSchemaAttribute");
        SchemaAttributeRequestBody requestBody = new SchemaAttributeRequestBody();
        requestBody.setElementProperties(schemaAttributeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, "updateSchemaAttribute"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attribute/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateSchemaAttribute", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void setSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaElementGUID, String schemaElementExternalIdentifier, String formula, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setSchemaElementAsCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "setSchemaElementAsCalculatedValue");
        CalculatedValueClassificationRequestBody requestBody = new CalculatedValueClassificationRequestBody();
        requestBody.setFormula(formula);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, schemaElementExternalIdentifier, "setSchemaElementAsCalculatedValue"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-elements/{2}/is-calculated-value?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("setSchemaElementAsCalculatedValue", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaElementGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, String schemaElementGUID, String schemaElementExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaElementAsCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "clearSchemaElementAsCalculatedValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-elements/{2}/is-calculated-value/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearSchemaElementAsCalculatedValue", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, schemaElementExternalIdentifier, effectiveTime, "clearSchemaElementAsCalculatedValue"), new Object[]{this.serverName, userId, schemaElementGUID, forLineage, forDuplicateProcessing});
    }

    public void setupColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, String primaryKeyName, KeyPattern primaryKeyPattern, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupColumnAsPrimaryKey";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupColumnAsPrimaryKey");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "setupColumnAsPrimaryKey");
        PrimaryKeyClassificationRequestBody requestBody = new PrimaryKeyClassificationRequestBody();
        PrimaryKeyProperties primaryKeyProperties = new PrimaryKeyProperties();
        primaryKeyProperties.setName(primaryKeyName);
        primaryKeyProperties.setKeyPattern(primaryKeyPattern);
        requestBody.setPrimaryKeyProperties(primaryKeyProperties);
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/{2}/is-primary-key?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("setupColumnAsPrimaryKey", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearColumnAsPrimaryKey";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearColumnAsPrimaryKey");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "clearColumnAsPrimaryKey");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/{2}/is-primary-key/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearColumnAsPrimaryKey", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, effectiveTime, "clearColumnAsPrimaryKey"), new Object[]{this.serverName, userId, schemaAttributeGUID, forLineage, forDuplicateProcessing});
    }

    public void setupForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupForeignKeyRelationship";
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", "setupForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", "setupForeignKeyRelationship");
        ForeignKeyRequestBody requestBody = new ForeignKeyRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(foreignKeyProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/{2}/relationships/foreign-keys/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("setupForeignKeyRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryKeyGUID, foreignKeyGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void updateForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateForeignKeyRelationship";
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", "updateForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", "updateForeignKeyRelationship");
        ForeignKeyRequestBody requestBody = new ForeignKeyRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(foreignKeyProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/{2}/relationships/foreign-keys/{3}/update?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateForeignKeyRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryKeyGUID, foreignKeyGUID, forLineage, forDuplicateProcessing});
    }

    public void clearForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearForeignKeyRelationship";
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", "clearForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", "clearForeignKeyRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/relationships/{3}/foreign-keys/{4}/remove?forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("clearForeignKeyRelationship", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, primaryKeyGUID, foreignKeyGUID, forLineage, forDuplicateProcessing});
    }

    public void removeSchemaAttribute(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaAttribute";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "removeSchemaAttribute");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeSchemaAttribute", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, schemaAttributeExternalIdentifier, effectiveTime, "removeSchemaAttribute"), new Object[]{this.serverName, userId, schemaAttributeGUID, forLineage, forDuplicateProcessing});
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaAttributes";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaAttributes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaAttributes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaAttributes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("findSchemaAttributes", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<SchemaAttributeElement> getNestedSchemaAttributes(String userId, String assetManagerGUID, String assetManagerName, String parentSchemaElementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedSchemaAttributes";
        String guidParameterName = "parentSchemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNestedSchemaAttributes");
        this.invalidParameterHandler.validateGUID(parentSchemaElementGUID, "parentSchemaElementGUID", "getNestedSchemaAttributes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNestedSchemaAttributes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-elements/{2}/schema-attributes/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("getNestedSchemaAttributes", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, parentSchemaElementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributesByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaAttributesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaAttributesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("getSchemaAttributesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributeByGUID";
        String guidParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributeByGUID");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "getSchemaAttributeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/schema-attributes/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        SchemaAttributeElementResponse restResult = this.restClient.callSchemaAttributePostRESTCall("getSchemaAttributeByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, schemaAttributeGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }
}

