/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.DataAssetExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.SchemaExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelationshipElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataAssetExchangeClient
extends SchemaExchangeClientBase
implements DataAssetExchangeInterface {
    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public DataAssetExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createDataAsset(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAsset";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataAsset");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "createDataAsset");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "createDataAsset");
        DataAssetRequestBody requestBody = new DataAssetRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createDataAsset"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createDataAssetFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAssetFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataAssetFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDataAssetFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDataAssetFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createDataAssetFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createDataAssetFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataAssetFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier, boolean isMergeUpdate, DataAssetProperties assetProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataAsset";
        String assetGUIDParameterName = "assetGUID";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateDataAsset");
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", "updateDataAsset");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "updateDataAsset");
        }
        DataAssetRequestBody requestBody = new DataAssetRequestBody();
        requestBody.setElementProperties(assetProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, assetExternalIdentifier, "updateDataAsset"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateDataAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void publishDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDataAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "publishDataAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/publish?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("publishDataAsset", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, assetGUID, forLineage, forDuplicateProcessing});
    }

    public void withdrawDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDataAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "withdrawDataAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/withdraw?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("withdrawDataAsset", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, assetGUID, forLineage, forDuplicateProcessing});
    }

    public void removeDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataAsset";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeDataAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeDataAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeDataAsset", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, assetExternalIdentifier, effectiveTime, "removeDataAsset"), new Object[]{this.serverName, userId, assetGUID, forLineage, forDuplicateProcessing});
    }

    public void setDataAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setDataAssetAsReferenceData";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "setDataAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setDataAssetAsReferenceData");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/is-reference-data?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setDataAssetAsReferenceData", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, assetExternalIdentifier, effectiveTime, "setDataAssetAsReferenceData"), new Object[]{this.serverName, userId, assetGUID, forLineage, forDuplicateProcessing});
    }

    public void clearDataAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataAssetAsReferenceData";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearDataAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "clearDataAssetAsReferenceData");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/is-reference-data/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearDataAssetAsReferenceData", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, assetExternalIdentifier, effectiveTime, "clearDataAssetAsReferenceData"), new Object[]{this.serverName, userId, assetGUID, forLineage, forDuplicateProcessing});
    }

    public String setupRelatedDataAsset(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, RelationshipProperties relationshipProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupRelatedDataAsset";
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupRelatedDataAsset");
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "setupRelatedDataAsset");
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "setupRelatedDataAsset");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupRelatedDataAsset");
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(relationshipProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/relationships/{2}/from-asset/{3}/to-asset/{4}?assetManagerIsHome={5}&forLineage={6}&forDuplicateProcessing={7}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupRelatedDataAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipTypeName, fromAssetGUID, toAssetGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return results.getGUID();
    }

    public RelationshipElement getAssetRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetRelationship";
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "getAssetRelationship");
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "getAssetRelationship");
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "getAssetRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getAssetRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/relationships/{2}/from-asset/{3}/to-asset/{4}/retrieve?forLineage={5}&forDuplicateProcessing={6}";
        RelationshipElementResponse restResult = this.restClient.callRelationshipPostRESTCall("getAssetRelationship", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, relationshipTypeName, fromAssetGUID, toAssetGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public void updateAssetRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, RelationshipProperties relationshipProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetRelationship";
        String relationshipGUIDParameterName = "relationshipGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetRelationship");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateAssetRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "updateAssetRelationship");
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(relationshipProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/relationships/{2}/{3}/update?isMergeUpdate={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("updateAssetRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipTypeName, relationshipGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void clearAssetRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String relationshipGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetRelationship";
        String relationshipGUIDParameterName = "relationshipGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetRelationship");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "clearAssetRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "clearAssetRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/relationships/{2}/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearAssetRelationship", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, relationshipTypeName, relationshipGUID, forLineage, forDuplicateProcessing});
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd2(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String fromAssetGUID, int startingFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedAssetsAtEnd2";
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedAssetsAtEnd2");
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "getRelatedAssetsAtEnd2");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedAssetsAtEnd2");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/relationships/{2}/from-asset/{3}/retrieve/end2?startFrom={4}&pageSize={5}&forLineage={6}&forDuplicateProcessing={7}";
        RelationshipElementsResponse restResult = this.restClient.callRelationshipsPostRESTCall("getRelatedAssetsAtEnd2", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, relationshipTypeName, fromAssetGUID, startingFrom, pageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd1(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String toAssetGUID, int startingFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedAssetsAtEnd1";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedAssetsAtEnd1");
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "getRelatedAssetsAtEnd1");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedAssetsAtEnd1");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/relationships/{2}/to-asset/{3}/retrieve/end1?startFrom={4}&pageSize={5}&forLineage={6}&forDuplicateProcessing={7}";
        RelationshipElementsResponse restResult = this.restClient.callRelationshipsPostRESTCall("getRelatedAssetsAtEnd1", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, relationshipTypeName, toAssetGUID, startingFrom, pageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<DataAssetElement> findDataAssets(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataAssets";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDataAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDataAssets");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataAssets");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("findDataAssets", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<DataAssetElement> scanDataAssets(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "scanDataAssets";
        this.invalidParameterHandler.validateUserId(userId, "scanDataAssets");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "scanDataAssets");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/scan?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("scanDataAssets", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<DataAssetElement> getDataAssetsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDataAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDataAssetsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataAssetsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("getDataAssetsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetsForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataAssetsForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getDataAssetsForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataAssetsForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/by-asset-manager?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        DataAssetElementsResponse restResult = this.restClient.callDataAssetsPostRESTCall("getDataAssetsForAssetManager", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public DataAssetElement getDataAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetByGUID";
        String guidParameterName = "openMetadataGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataAssetByGUID");
        this.invalidParameterHandler.validateGUID(openMetadataGUID, "openMetadataGUID", "getDataAssetByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        DataAssetElementResponse restResult = this.restClient.callDataAssetPostRESTCall("getDataAssetByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, openMetadataGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }
}

