/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.GovernanceExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NextGovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GovernanceDefinitionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NextGovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceExchangeClient
extends ExchangeClientBase
implements GovernanceExchangeInterface {
    public GovernanceExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public GovernanceExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createGovernanceDefinition(String userId, String assetManagerGUID, String assetManagerName, String typeName, String definitionExternalIdentifier, String definitionExternalIdentifierName, String definitionExternalIdentifierUsage, String definitionExternalIdentifierSource, KeyPattern definitionExternalIdentifierKeyPattern, Map<String, String> mappingProperties, GovernanceDefinitionProperties definitionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateGovernanceDefinition(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, boolean isMergeUpdate, GovernanceDefinitionProperties definitionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void deleteGovernanceDefinition(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void linkDefinitions(String userId, String assetManagerGUID, String assetManagerName, String definitionOneGUID, String definitionTwoGUID, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void unlinkDefinitions(String userId, String assetManagerGUID, String assetManagerName, String definitionOneGUID, String definitionTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void setupGovernanceDelegation(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String delegatedToDefinitionGUID, String rationale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearGovernanceDelegation(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String delegatedToDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public GovernanceDefinitionElement getGovernanceDefinitionByGUID(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public GovernanceDefinitionElement getGovernanceDefinitionByDocId(String userId, String assetManagerGUID, String assetManagerName, String documentIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void addGovernanceDefinitionToElement(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String elementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeGovernanceDefinitionFromElement(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String elementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void addElementToSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier, String subjectAreaName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeElementFromSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalElementIdentifier, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<GovernanceActionProcessElement> findGovernanceActionProcesses(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionProcesses";
        String searchStringParameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionProcesses");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionProcesses");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceActionProcessElementsResponse restResult = this.restClient.callGovernanceActionProcessElementsPostRESTCall("findGovernanceActionProcesses", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionProcessElement> getGovernanceActionProcessesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessesByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionProcessesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceActionProcessElementsResponse restResult = this.restClient.callGovernanceActionProcessElementsPostRESTCall("getGovernanceActionProcessesByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public GovernanceActionProcessElement getGovernanceActionProcessByGUID(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessByGUID";
        String guidParameterName = "processGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessByGUID");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse restResult = this.restClient.callGovernanceActionProcessGetRESTCall("getGovernanceActionProcessByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/{2}", this.serverName, userId, processGUID);
        return restResult.getElement();
    }

    public List<GovernanceActionTypeElement> findGovernanceActionTypes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionTypes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceActionTypeElementsResponse restResult = this.restClient.callGovernanceActionTypeElementsPostRESTCall("findGovernanceActionTypes", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionTypeElement> getGovernanceActionTypesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionTypesByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionTypesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionTypesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceActionTypeElementsResponse restResult = this.restClient.callGovernanceActionTypeElementsPostRESTCall("getGovernanceActionTypesByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public GovernanceActionTypeElement getGovernanceActionTypeByGUID(String userId, String actionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionTypeByGUID";
        String guidParameterName = "actionTypeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionTypeByGUID");
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", "getGovernanceActionTypeByGUID");
        GovernanceActionTypeElementResponse restResult = this.restClient.callGovernanceActionTypeGetRESTCall("getGovernanceActionTypeByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/{2}", this.serverName, userId, actionTypeGUID);
        return restResult.getElement();
    }

    public GovernanceActionTypeElement getFirstActionType(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFirstActionType";
        String guidParameterName = "processGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/{2}/first-action-type";
        this.invalidParameterHandler.validateUserId(userId, "getFirstActionType");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getFirstActionType");
        GovernanceActionTypeElementResponse restResult = this.restClient.callGovernanceActionTypeGetRESTCall("getFirstActionType", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-processes/{2}/first-action-type", this.serverName, userId, processGUID);
        return restResult.getElement();
    }

    public List<NextGovernanceActionTypeElement> getNextGovernanceActionTypes(String userId, String actionTypeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNextGovernanceActionTypes";
        String guidParameterName = "actionTypeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/{2}/next-action-type?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getNextGovernanceActionTypes");
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", "getNextGovernanceActionTypes");
        NextGovernanceActionTypeElementsResponse restResult = this.restClient.callNextGovernanceActionTypesGetRESTCall("getNextGovernanceActionTypes", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-action-types/{2}/next-action-type?startFrom={4}&pageSize={5}", this.serverName, userId, actionTypeGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public GovernanceActionElement getGovernanceAction(String userId, String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceAction";
        String guidParameterName = "governanceActionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-actions/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceAction");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "getGovernanceAction");
        GovernanceActionElementResponse restResult = this.restClient.callGovernanceActionGetRESTCall("getGovernanceAction", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-actions/{2}", this.serverName, userId, governanceActionGUID);
        return restResult.getElement();
    }

    public List<GovernanceActionElement> getGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-actions?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getGovernanceActions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-actions?startFrom={2}&pageSize={3}", this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getActiveGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveGovernanceActions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-actions/active?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getActiveGovernanceActions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/governance-actions/active?startFrom={2}&pageSize={3}", this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }
}

