/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.StewardshipExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetOriginProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFieldQueryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFieldValuesProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FindAssetOriginProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FindNameProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FindProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GovernanceClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.LevelIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.OwnerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RetentionClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SecurityTagsProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SemanticAssignmentProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SubjectAreaMemberProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class StewardshipExchangeClient
extends ExchangeClientBase
implements StewardshipExchangeInterface {
    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public void setElementAsDataField(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, DataFieldValuesProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setElementAsDataField";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/data-field";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setElementAsDataField");
    }

    public void clearElementAsDataField(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearElementAsDataField";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/data-field/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearElementAsDataField");
    }

    public List<ElementStub> getDataFieldClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, DataFieldQueryProperties properties, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFieldClassifiedElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-data-field";
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, (FindProperties)properties, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getDataFieldClassifiedElements");
    }

    public void setConfidenceClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, GovernanceClassificationProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConfidenceClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidence";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setConfidenceClassification");
    }

    public void clearConfidenceClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConfidenceClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidence/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearConfidenceClassification");
    }

    public List<ElementStub> getConfidenceClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConfidenceClassifiedElements";
        LevelIdentifierProperties properties = new LevelIdentifierProperties();
        properties.setLevelIdentifier(levelIdentifier);
        properties.setReturnSpecificLevel(returnSpecificLevel);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-confidence";
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, (FindProperties)properties, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getConfidenceClassifiedElements");
    }

    public void setCriticalityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, GovernanceClassificationProperties properties, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setCriticalityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/criticality";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setCriticalityClassification");
    }

    public void clearCriticalityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCriticalityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/criticality/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearCriticalityClassification");
    }

    public List<ElementStub> getCriticalityClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCriticalityClassifiedElements";
        LevelIdentifierProperties properties = new LevelIdentifierProperties();
        properties.setLevelIdentifier(levelIdentifier);
        properties.setReturnSpecificLevel(returnSpecificLevel);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-criticality";
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, (FindProperties)properties, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getCriticalityClassifiedElements");
    }

    public void setConfidentialityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, GovernanceClassificationProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConfidentialityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidentiality";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setConfidentialityClassification");
    }

    public void clearConfidentialityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConfidentialityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidentiality/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearConfidentialityClassification");
    }

    public List<ElementStub> getConfidentialityClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConfidentialityClassifiedElements";
        LevelIdentifierProperties properties = new LevelIdentifierProperties();
        properties.setLevelIdentifier(levelIdentifier);
        properties.setReturnSpecificLevel(returnSpecificLevel);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-confidentiality";
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, (FindProperties)properties, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getConfidentialityClassifiedElements");
    }

    public void setRetentionClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, RetentionClassificationProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setRetentionClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/retention";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setRetentionClassification");
    }

    public void clearRetentionClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearRetentionClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/retention/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearRetentionClassification");
    }

    public List<ElementStub> getRetentionClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificBasisIdentifier, int basisIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRetentionClassifiedElements";
        LevelIdentifierProperties properties = new LevelIdentifierProperties();
        properties.setLevelIdentifier(basisIdentifier);
        properties.setReturnSpecificLevel(returnSpecificBasisIdentifier);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-confidentiality";
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, (FindProperties)properties, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getRetentionClassifiedElements");
    }

    public void addSecurityTags(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, SecurityTagsProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSecurityTags";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/security-tags";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addSecurityTags");
    }

    public void clearSecurityTags(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSecurityTags";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/security-tags/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearSecurityTags");
    }

    public List<ElementStub> getSecurityTaggedElements(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSecurityTaggedElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-security-tags";
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, null, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getSecurityTaggedElements");
    }

    public void addOwnership(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, OwnerProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addOwnership";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/ownership";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addOwnership");
    }

    public void clearOwnership(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearOwnership";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/ownership/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearOwnership");
    }

    public List<ElementStub> getOwnersElements(String userId, String assetManagerGUID, String assetManagerName, String owner, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getOwnersElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-ownership";
        FindNameProperties properties = new FindNameProperties();
        properties.setName(owner);
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, (FindProperties)properties, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getOwnersElements");
    }

    public void addAssetOrigin(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String externalIdentifier, AssetOriginProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetOrigin";
        String elementGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/assets/{2}/origin";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, assetGUID, "assetGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addAssetOrigin");
    }

    public void clearAssetOrigin(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetOrigin";
        String elementGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/assets/{2}/origin/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, assetGUID, "assetGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearAssetOrigin");
    }

    public List<AssetElement> getAssetsByOrigin(String userId, String assetManagerGUID, String assetManagerName, FindAssetOriginProperties properties, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetsByOrigin";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/assets/by-origin";
        String requestParamsURLTemplate = "?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByOrigin");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAssetsByOrigin");
        FindByPropertiesRequestBody requestBody = new FindByPropertiesRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setProperties((FindProperties)properties);
        AssetElementsResponse restResult = this.restClient.callAssetsPostRESTCall("getAssetsByOrigin", urlTemplate + "?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}", requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public void addElementToSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, SubjectAreaMemberProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addElementToSubjectArea";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/subject-area-member";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addElementToSubjectArea");
    }

    public void removeElementFromSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeElementFromSubjectArea";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/subject-area-member/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeElementFromSubjectArea");
    }

    public List<ElementStub> getMembersOfSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String subjectAreaName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMembersOfSubjectArea";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-subject-area-membership";
        FindNameProperties properties = new FindNameProperties();
        properties.setName(subjectAreaName);
        return super.getClassifiedElements(userId, assetManagerGUID, assetManagerName, (FindProperties)properties, urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getMembersOfSubjectArea");
    }

    public void setupSemanticAssignment(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String glossaryTermGUID, SemanticAssignmentProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSemanticAssignment";
        String elementGUIDParameterName = "elementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/semantic-assignment/terms/{3}";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", (RelationshipProperties)properties, glossaryTermGUID, "glossaryTermGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setupSemanticAssignment");
    }

    public void clearSemanticAssignment(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSemanticAssignment";
        String elementGUIDParameterName = "elementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/semantic-assignment/terms/{3}/remove";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", glossaryTermGUID, "glossaryTermGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearSemanticAssignment");
    }

    public List<GlossaryTermElement> getMeanings(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMeanings";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/by-semantic-assignment/{2}?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, "getMeanings");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMeanings");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getMeanings");
        GlossaryTermElementsResponse restResult = this.restClient.callGlossaryTermsPostRESTCall("getMeanings", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, elementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<RelatedElement> getSemanticAssignees(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSemanticAssignees";
        String elementGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-semantic-assignment/{2}";
        return super.getRelatedElements(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getSemanticAssignees");
    }

    public void addGovernanceDefinitionToElement(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String elementGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addGovernanceDefinitionToElement";
        String elementGUIDParameterName = "elementGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/governed-by/definition/{3}";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", null, definitionGUID, "definitionGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addGovernanceDefinitionToElement");
    }

    public void removeGovernanceDefinitionFromElement(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String elementGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceDefinitionFromElement";
        String elementGUIDParameterName = "elementGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/governed-by/definition/{3}/remove";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", definitionGUID, "definitionGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeGovernanceDefinitionFromElement");
    }

    public List<GovernanceDefinitionElement> getGovernedByDefinitions(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernedByDefinitions";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/governed-by";
        String requestParamsURLTemplate = "?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernedByDefinitions");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getGovernedByDefinitions");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernedByDefinitions");
        GovernanceDefinitionsResponse restResult = this.restClient.callGovernanceDefinitionsPostRESTCall("getGovernedByDefinitions", urlTemplate + "?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}", this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, elementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElements();
    }

    public List<RelatedElement> getGovernedElements(String userId, String assetManagerGUID, String assetManagerName, String governanceDefinitionGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernedElements";
        String elementGUIDParameterName = "governanceDefinitionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/governed-by/{2}";
        return super.getRelatedElements(userId, assetManagerGUID, assetManagerName, governanceDefinitionGUID, "governanceDefinitionGUID", urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getGovernedElements");
    }

    public List<RelatedElement> getSourceElements(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSourceElements";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/sourced-from/{2}";
        return super.getRelatedElements(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getSourceElements");
    }

    public List<RelatedElement> getElementsSourceFrom(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsSourceFrom";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/sourced-from";
        return super.getRelatedElements(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getElementsSourceFrom");
    }
}

