/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.management;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.management.GlossaryManagementInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalGlossaryLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ActivityDescriptionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CanonicalVocabularyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFieldValuesProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EditingGlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryElementLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermContextDefinition;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationship;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.StagingGlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TaxonomyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GlossaryManagementClient
implements GlossaryManagementInterface {
    final GlossaryExchangeClient client;

    public GlossaryManagementClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        this.client = new GlossaryExchangeClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GlossaryManagementClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        this.client = new GlossaryExchangeClient(serverName, serverPlatformURLRoot);
    }

    public GlossaryManagementClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.client = new GlossaryExchangeClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GlossaryManagementClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        this.client = new GlossaryExchangeClient(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public GlossaryManagementClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        this.client = new GlossaryExchangeClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createGlossary(String userId, GlossaryProperties glossaryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createGlossary(userId, null, null, false, null, glossaryProperties);
    }

    public String createGlossaryFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties, boolean deepCopy) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createGlossaryFromTemplate(userId, null, null, false, templateGUID, null, deepCopy, templateProperties);
    }

    public void updateGlossary(String userId, String glossaryGUID, boolean isMergeUpdate, GlossaryProperties glossaryProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateGlossary(userId, null, null, glossaryGUID, null, isMergeUpdate, glossaryProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setGlossaryAsEditingGlossary(String userId, String glossaryGUID, EditingGlossaryProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setGlossaryAsEditingGlossary(userId, null, null, glossaryGUID, null, properties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearGlossaryAsEditingGlossary(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearGlossaryAsEditingGlossary(userId, null, null, glossaryGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setGlossaryAsStagingGlossary(String userId, String glossaryGUID, StagingGlossaryProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setGlossaryAsStagingGlossary(userId, null, null, glossaryGUID, null, properties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearGlossaryAsStagingGlossary(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearGlossaryAsStagingGlossary(userId, null, null, glossaryGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setGlossaryAsTaxonomy(String userId, String glossaryGUID, TaxonomyProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setGlossaryAsTaxonomy(userId, null, null, glossaryGUID, null, properties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearGlossaryAsTaxonomy(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearGlossaryAsTaxonomy(userId, null, null, glossaryGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setGlossaryAsCanonical(String userId, String glossaryGUID, CanonicalVocabularyProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setGlossaryAsCanonical(userId, null, null, glossaryGUID, null, properties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearGlossaryAsCanonical(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearGlossaryAsCanonical(userId, null, null, glossaryGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void removeGlossary(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeGlossary(userId, null, null, glossaryGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryElement> findGlossaries(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findGlossaries(userId, null, null, searchString, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryElement> getGlossariesByName(String userId, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossariesByName(userId, null, null, name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public GlossaryElement getGlossaryByGUID(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossaryByGUID(userId, null, null, glossaryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public String createGlossaryCategory(String userId, String glossaryGUID, GlossaryCategoryProperties glossaryCategoryProperties, boolean isRootCategory, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createGlossaryCategory(userId, null, null, false, glossaryGUID, null, glossaryCategoryProperties, isRootCategory, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public String createGlossaryCategoryFromTemplate(String userId, String glossaryGUID, String templateGUID, TemplateProperties templateProperties, boolean deepCopy) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createGlossaryCategoryFromTemplate(userId, null, null, false, glossaryGUID, templateGUID, null, deepCopy, templateProperties);
    }

    public void updateGlossaryCategory(String userId, String glossaryCategoryGUID, boolean isMergeUpdate, GlossaryCategoryProperties glossaryCategoryProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateGlossaryCategory(userId, null, null, glossaryCategoryGUID, null, isMergeUpdate, glossaryCategoryProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setupCategoryParent(String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setupCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearCategoryParent(String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void removeGlossaryCategory(String userId, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeGlossaryCategory(userId, null, null, glossaryCategoryGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String userId, String glossaryGUID, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findGlossaryCategories(userId, null, null, glossaryGUID, searchString, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getCategoriesForGlossary(String userId, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getCategoriesForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String userId, String glossaryGUID, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossaryCategoriesByName(userId, null, null, glossaryGUID, name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public GlossaryCategoryElement getGlossaryCategoryByGUID(String userId, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossaryCategoryByGUID(userId, null, null, glossaryCategoryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public GlossaryCategoryElement getGlossaryCategoryParent(String userId, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossaryCategoryParent(userId, null, null, glossaryCategoryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getGlossarySubCategories(String userId, String glossaryCategoryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossarySubCategories(userId, null, null, glossaryCategoryGUID, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public String createGlossaryTerm(String userId, String glossaryGUID, GlossaryTermProperties glossaryTermProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createGlossaryTerm(userId, null, null, false, glossaryGUID, null, glossaryTermProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public String createControlledGlossaryTerm(String userId, String glossaryGUID, GlossaryTermProperties glossaryTermProperties, GlossaryTermStatus initialStatus, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createControlledGlossaryTerm(userId, null, null, false, glossaryGUID, null, glossaryTermProperties, initialStatus, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public String createGlossaryTermFromTemplate(String userId, String glossaryGUID, String templateGUID, TemplateProperties templateProperties, boolean deepCopy, boolean templateSubstitute, GlossaryTermStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createGlossaryTermFromTemplate(userId, null, null, false, glossaryGUID, templateGUID, null, deepCopy, initialStatus, templateProperties);
    }

    public void updateGlossaryTerm(String userId, String glossaryTermGUID, boolean isMergeUpdate, GlossaryTermProperties glossaryTermProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateGlossaryTerm(userId, null, null, glossaryTermGUID, null, isMergeUpdate, glossaryTermProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void updateGlossaryTermStatus(String userId, String glossaryTermGUID, GlossaryTermStatus glossaryTermStatus, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateGlossaryTermStatus(userId, null, null, glossaryTermGUID, null, glossaryTermStatus, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void updateGlossaryTermFromTemplate(String userId, String glossaryTermGUID, String templateGUID, boolean isMergeClassifications, boolean isMergeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateGlossaryTermFromTemplate(userId, null, null, glossaryTermGUID, null, templateGUID, isMergeClassifications, isMergeProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void moveGlossaryTerm(String userId, String glossaryTermGUID, String newGlossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.moveGlossaryTerm(userId, null, null, glossaryTermGUID, null, newGlossaryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setupTermCategory(String userId, String glossaryCategoryGUID, String glossaryTermGUID, GlossaryTermCategorization categorizationProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setupTermCategory(userId, null, null, glossaryCategoryGUID, glossaryTermGUID, categorizationProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermCategory(String userId, String glossaryCategoryGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermCategory(userId, null, null, glossaryCategoryGUID, glossaryTermGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<String> getTermRelationshipTypeNames(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTermRelationshipTypeNames(userId);
    }

    public void setupTermRelationship(String userId, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setupTermRelationship(userId, null, null, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, relationshipsProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void updateTermRelationship(String userId, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateTermRelationship(userId, null, null, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, relationshipsProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermRelationship(String userId, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermRelationship(userId, null, null, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsAbstractConcept(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsAbstractConcept(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsAbstractConcept(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsAbstractConcept(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsDataField(String userId, String glossaryTermGUID, DataFieldValuesProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsDataField(userId, null, null, glossaryTermGUID, null, properties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsDataField(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsDataField(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsDataValue(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsDataValue(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsDataValue(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsDataValue(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsActivity(String userId, String glossaryTermGUID, ActivityDescriptionProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsActivity(userId, null, null, glossaryTermGUID, null, properties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsActivity(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsActivity(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsContext(String userId, String glossaryTermGUID, GlossaryTermContextDefinition contextDefinition, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsContext(userId, null, null, glossaryTermGUID, null, contextDefinition, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsContext(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsContext(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsSpineObject(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsSpineObject(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsSpineObject(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsSpineObject(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsSpineAttribute(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsSpineAttribute(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsSpineAttribute(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsSpineAttribute(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void setTermAsObjectIdentifier(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setTermAsObjectIdentifier(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void clearTermAsObjectIdentifier(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearTermAsObjectIdentifier(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public GlossaryTermElement undoGlossaryTermUpdate(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.undoGlossaryTermUpdate(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void archiveGlossaryTerm(String userId, String glossaryTermGUID, ArchiveProperties archiveProperties, Date effectiveTime, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.archiveGlossaryTerm(userId, null, null, glossaryTermGUID, null, archiveProperties, effectiveTime, forDuplicateProcessing);
    }

    public void removeGlossaryTerm(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeGlossaryTerm(userId, null, null, glossaryTermGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryTermElement> findGlossaryTerms(String userId, String glossaryGUID, String searchString, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findGlossaryTerms(userId, null, null, glossaryGUID, searchString, limitResultsByStatus, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getTermsForGlossary(String userId, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTermsForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getTermsForGlossaryCategory(String userId, String glossaryCategoryGUID, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTermsForGlossaryCategory(userId, null, null, glossaryCategoryGUID, limitResultsByStatus, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getRelatedTerms(String userId, String glossaryTermGUID, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getRelatedTerms(userId, null, null, glossaryTermGUID, limitResultsByStatus, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String userId, String glossaryGUID, String name, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossaryTermsByName(userId, null, null, glossaryGUID, name, limitResultsByStatus, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public GlossaryTermElement getGlossaryTermByGUID(String userId, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossaryTermByGUID(userId, null, null, glossaryTermGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getGlossaryTermHistory(String userId, String glossaryTermGUID, Date fromTime, Date toTime, int startFrom, int pageSize, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.client.getGlossaryTermHistory(userId, null, null, glossaryTermGUID, fromTime, toTime, startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String createExternalGlossaryLink(String userId, ExternalGlossaryLinkProperties linkProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createExternalGlossaryLink(userId, null, null, linkProperties);
    }

    public void updateExternalGlossaryLink(String userId, String externalLinkGUID, boolean isMergeUpdate, ExternalGlossaryLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateExternalGlossaryLink(userId, null, null, externalLinkGUID, isMergeUpdate, linkProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void removeExternalGlossaryLink(String userId, String externalLinkGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeExternalGlossaryLink(userId, null, null, externalLinkGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void attachExternalLinkToGlossary(String userId, String externalLinkGUID, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.attachExternalLinkToGlossary(userId, null, null, externalLinkGUID, glossaryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void detachExternalLinkFromGlossary(String userId, String externalLinkGUID, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.detachExternalLinkFromGlossary(userId, null, null, externalLinkGUID, glossaryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<ExternalGlossaryLinkElement> getExternalLinksForGlossary(String userId, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getExternalLinksForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public List<GlossaryElement> getGlossariesForExternalLink(String userId, String externalLinkGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getGlossariesForExternalLink(userId, null, null, externalLinkGUID, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void attachExternalCategoryLink(String userId, String externalLinkGUID, String glossaryCategoryGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.attachExternalCategoryLink(userId, null, null, externalLinkGUID, glossaryCategoryGUID, linkProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void detachExternalCategoryLink(String userId, String externalLinkGUID, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.detachExternalCategoryLink(userId, null, null, externalLinkGUID, glossaryCategoryGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void attachExternalTermLink(String userId, String externalLinkGUID, String glossaryTermGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.attachExternalTermLink(userId, null, null, externalLinkGUID, glossaryTermGUID, linkProperties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void detachExternalTermLink(String userId, String externalLinkGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.detachExternalTermLink(userId, null, null, externalLinkGUID, glossaryTermGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }
}

