/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.ffdc.AssetManagerErrorCode;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FindProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class AssetManagerBaseClient {
    protected final String serverName;
    protected final String serverPlatformURLRoot;
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected final AssetManagerRESTClient restClient;
    protected final NullRequestBody nullRequestBody = new NullRequestBody();
    protected final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}";
    AuditLog auditLog = null;

    public AssetManagerBaseClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public AssetManagerBaseClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public AssetManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public AssetManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new AssetManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public AssetManagerBaseClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor (with REST client)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with REST client)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.auditLog = auditLog;
        this.restClient = restClient;
    }

    protected void handleMissingScope(String externalIdentifier, String methodName) throws InvalidParameterException {
        String externalIdentifierParameterName = "externalIdentifier";
        throw new InvalidParameterException(AssetManagerErrorCode.NO_SCOPE_FOR_EXTERNAL_ID.getMessageDefinition(new String[]{externalIdentifier, methodName}), this.getClass().getName(), methodName, "externalIdentifier");
    }

    protected MetadataCorrelationProperties getCorrelationProperties(String assetManagerGUID, String assetManagerName, String externalIdentifier, String methodName) throws InvalidParameterException {
        MetadataCorrelationProperties correlationProperties = new MetadataCorrelationProperties();
        if (assetManagerGUID != null) {
            correlationProperties.setAssetManagerGUID(assetManagerGUID);
            correlationProperties.setAssetManagerName(assetManagerName);
            correlationProperties.setExternalIdentifier(externalIdentifier);
            return correlationProperties;
        }
        if (externalIdentifier != null) {
            this.handleMissingScope(externalIdentifier, methodName);
        }
        return correlationProperties;
    }

    protected UpdateRequestBody getUpdateRequestBody(String assetManagerGUID, String assetManagerName, String externalIdentifier, Date effectiveTime, String methodName) throws InvalidParameterException {
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifier, methodName));
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    protected MetadataCorrelationProperties getCorrelationProperties(String assetManagerGUID, String assetManagerName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, String externalIdentifierSource, KeyPattern externalIdentifierKeyPattern, Map<String, String> mappingProperties, String methodName) throws InvalidParameterException {
        MetadataCorrelationProperties correlationProperties = new MetadataCorrelationProperties();
        if (assetManagerGUID != null) {
            correlationProperties.setAssetManagerGUID(assetManagerGUID);
            correlationProperties.setAssetManagerName(assetManagerName);
            if (externalIdentifier != null) {
                correlationProperties.setKeyPattern(KeyPattern.LOCAL_KEY);
                correlationProperties.setExternalIdentifier(externalIdentifier);
                correlationProperties.setExternalIdentifierName(externalIdentifierName);
                correlationProperties.setExternalIdentifierUsage(externalIdentifierUsage);
                correlationProperties.setExternalIdentifierSource(externalIdentifierSource);
                correlationProperties.setKeyPattern(externalIdentifierKeyPattern);
                correlationProperties.setMappingProperties(mappingProperties);
            }
        } else if (externalIdentifier != null) {
            this.handleMissingScope(externalIdentifier, methodName);
        }
        return correlationProperties;
    }

    protected MetadataCorrelationProperties getCorrelationProperties(String assetManagerGUID, String assetManagerName, ExternalIdentifierProperties externalIdentifierProperties, String methodName) throws InvalidParameterException {
        MetadataCorrelationProperties correlationProperties = new MetadataCorrelationProperties(externalIdentifierProperties);
        if (assetManagerGUID != null) {
            correlationProperties.setAssetManagerGUID(assetManagerGUID);
            correlationProperties.setAssetManagerName(assetManagerName);
        } else if (externalIdentifierProperties != null && externalIdentifierProperties.getExternalIdentifier() != null) {
            this.handleMissingScope(externalIdentifierProperties.getExternalIdentifier(), methodName);
        }
        return correlationProperties;
    }

    protected AssetManagerIdentifiersRequestBody getAssetManagerIdentifiersRequestBody(String assetManagerGUID, String assetManagerName) {
        AssetManagerIdentifiersRequestBody requestBody = new AssetManagerIdentifiersRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        return requestBody;
    }

    protected EffectiveTimeQueryRequestBody getEffectiveTimeQueryRequestBody(String assetManagerGUID, String assetManagerName, Date effectiveTime) {
        EffectiveTimeQueryRequestBody requestBody = new EffectiveTimeQueryRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    protected GlossaryTermRelationshipRequestBody getGlossaryTermRelationshipRequestBody(String assetManagerGUID, String assetManagerName, List<GlossaryTermRelationshipStatus> limitResultsByStatus, Date effectiveTime) {
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    protected RelationshipRequestBody getRelationshipRequestBody(String assetManagerGUID, String assetManagerName, Date effectiveTime, RelationshipProperties relationshipProperties) {
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setProperties(relationshipProperties);
        return requestBody;
    }

    protected NameRequestBody getNameRequestBody(String assetManagerGUID, String assetManagerName, String name, String nameParameterName, Date effectiveTime) {
        NameRequestBody requestBody = new NameRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setName(name);
        requestBody.setNameParameterName(nameParameterName);
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    protected NameRequestBody getNameRequestBody(String assetManagerGUID, String assetManagerName, String name, Date effectiveTime, String methodName) throws InvalidParameterException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateName(name, "name", methodName);
        return this.getNameRequestBody(assetManagerGUID, assetManagerName, name, "name", effectiveTime);
    }

    protected NameRequestBody getQualifiedNameRequestBody(String assetManagerGUID, String assetManagerName, String qualifiedName, Date effectiveTime) {
        String nameParameterName = "qualifiedName";
        return this.getNameRequestBody(assetManagerGUID, assetManagerName, qualifiedName, "qualifiedName", effectiveTime);
    }

    protected SearchStringRequestBody getSearchStringRequestBody(String assetManagerGUID, String assetManagerName, String searchString, Date effectiveTime, String methodName) throws InvalidParameterException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        if (assetManagerGUID != null) {
            requestBody.setAssetManagerGUID(assetManagerGUID);
            requestBody.setAssetManagerName(assetManagerName);
        }
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }

    protected String createReferenceable(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={2}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        requestBody.setElementProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={2}", requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    protected String createReferenceableFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, ExternalIdentifierProperties externalIdentifierProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={3}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={3}", requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    protected String createReferenceableFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, ExternalIdentifierProperties externalIdentifierProperties, String urlTemplate, boolean deepCopy, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={3}&deepCopy={4}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={3}&deepCopy={4}", requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome, deepCopy});
        return restResult.getGUID();
    }

    protected String createReferenceableFromTemplateWithParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentGUID, String parentGUIDParameterName, String templateGUID, TemplateProperties templateProperties, ExternalIdentifierProperties externalIdentifierProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={4}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        requestBody.setParentGUID(parentGUID);
        requestBody.setElementProperties(templateProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={4}", requestBody, new Object[]{this.serverName, userId, parentGUID, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    protected String createReferenceableFromTemplateWithParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentGUID, String parentGUIDParameterName, String templateGUID, TemplateProperties templateProperties, ExternalIdentifierProperties externalIdentifierProperties, boolean deepCopy, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={4}&deepCopy={5}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        requestBody.setParentGUID(parentGUID);
        requestBody.setElementProperties(templateProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={4}&deepCopy={5}", requestBody, new Object[]{this.serverName, userId, parentGUID, templateGUID, assetManagerIsHome, deepCopy});
        return restResult.getGUID();
    }

    protected String createFeedbackFromTemplateWithParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentGUID, String parentGUIDParameterName, boolean isPublic, String templateGUID, TemplateProperties templateProperties, ExternalIdentifierProperties externalIdentifierProperties, boolean deepCopy, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={4}&deepCopy={5}&isPublic={6}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        requestBody.setParentGUID(parentGUID);
        requestBody.setElementProperties(templateProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={4}&deepCopy={5}&isPublic={6}", requestBody, new Object[]{this.serverName, userId, parentGUID, templateGUID, assetManagerIsHome, deepCopy, isPublic});
        return restResult.getGUID();
    }

    protected String createReferenceableWithParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentGUID, String parentGUIDParameterName, ReferenceableProperties properties, String propertiesParameterName, ExternalIdentifierProperties externalIdentifierProperties, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        requestBody.setParentGUID(parentGUID);
        requestBody.setElementProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}", requestBody, new Object[]{this.serverName, userId, parentGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return restResult.getGUID();
    }

    protected String createFeedbackWithParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentGUID, String parentGUIDParameterName, boolean isPublic, ReferenceableProperties properties, String propertiesParameterName, ExternalIdentifierProperties externalIdentifierProperties, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?assetManagerIsHome={3}&isPublic={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, methodName));
        requestBody.setParentGUID(parentGUID);
        requestBody.setElementProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate + "?assetManagerIsHome={3}&isPublic={4}&forLineage={5}&forDuplicateProcessing={6}", requestBody, new Object[]{this.serverName, userId, parentGUID, assetManagerIsHome, isPublic, forLineage, forDuplicateProcessing});
        return restResult.getGUID();
    }

    protected void updateReferenceable(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementGUIDParameterName, String externalIdentifierName, boolean isMergeUpdate, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierName, methodName));
        requestBody.setElementProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}", requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    protected void updateFeedback(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementGUIDParameterName, String externalIdentifierName, boolean isMergeUpdate, boolean isPublic, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?isMergeUpdate={3}&isPublic={4}forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierName, methodName));
        requestBody.setElementProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?isMergeUpdate={3}&isPublic={4}forLineage={5}&forDuplicateProcessing={6}", requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate, isPublic, forLineage, forDuplicateProcessing});
    }

    protected void setReferenceableClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementGUIDParameter, String externalIdentifierName, ClassificationProperties properties, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?forLineage={3}&forDuplicateProcessing={4}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierName, methodName));
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?forLineage={3}&forDuplicateProcessing={4}", requestBody, new Object[]{this.serverName, userId, elementGUID, forLineage, forDuplicateProcessing});
    }

    protected void removeReferenceableClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementGUIDParameter, String externalIdentifierName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?forLineage={3}&forDuplicateProcessing={4}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierName, methodName));
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?forLineage={3}&forDuplicateProcessing={4}", requestBody, new Object[]{this.serverName, userId, elementGUID, forLineage, forDuplicateProcessing});
    }

    protected void setupRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryElementGUID, String primaryElementGUIDParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?forLineage={4}&forDuplicateProcessing={5}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?forLineage={4}&forDuplicateProcessing={5}", requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID, forLineage, forDuplicateProcessing});
    }

    protected void setupRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipTypeName, String relationshipTypeNameParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeNameParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?forLineage={5}&forDuplicateProcessing={6}", requestBody, new Object[]{this.serverName, userId, primaryElementGUID, relationshipTypeName, secondaryElementGUID, forLineage, forDuplicateProcessing});
    }

    protected void clearRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryElementGUID, String primaryElementGUIDParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?forLineage={4}&forDuplicateProcessing={5}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?forLineage={4}&forDuplicateProcessing={5}", this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID, forLineage, forDuplicateProcessing});
    }

    protected void clearRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipTypeName, String relationshipTypeNameParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeNameParameterName, methodName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?forLineage={5}&forDuplicateProcessing={6}", this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, primaryElementGUID, relationshipTypeName, secondaryElementGUID, forLineage, forDuplicateProcessing});
    }

    protected List<RelatedElement> getRelatedElements(String userId, String assetManagerGUID, String assetManagerName, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RelatedElementsResponse restResult = this.restClient.callRelatedElementsPostRESTCall(methodName, urlTemplate + "?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}", this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startingElementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    protected List<ElementStub> getClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, FindProperties properties, String urlTemplate, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        FindByPropertiesRequestBody requestBody = new FindByPropertiesRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setProperties(properties);
        ElementStubsResponse restResult = this.restClient.callElementStubsPostRESTCall(methodName, urlTemplate + "?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}", requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    protected void removeReferenceable(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementGUIDParameterName, String externalIdentifierName, String urlTemplate, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestParamsURLTemplate = "?forLineage={3}&forDuplicateProcessing={4}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierName, methodName));
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate + "?forLineage={3}&forDuplicateProcessing={4}", requestBody, new Object[]{this.serverName, userId, elementGUID, forLineage, forDuplicateProcessing});
    }
}

