/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.CollaborationExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerBaseClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.CommentElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.InformalTagElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NoteElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NoteLogElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CommentProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FeedbackProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteLogProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TagProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CollaborationExchangeClient
extends AssetManagerBaseClient
implements CollaborationExchangeInterface {
    public CollaborationExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public CollaborationExchangeClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public CollaborationExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public CollaborationExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public CollaborationExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public String addRatingToElement(String userId, String elementGUID, boolean isPublic, RatingProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addRatingToElement";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/ratings?isPublic={3}";
        this.invalidParameterHandler.validateUserId(userId, "addRatingToElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "addRatingToElement");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("addRatingToElement", urlTemplate, properties, new Object[]{this.serverName, userId, elementGUID, isPublic});
        return response.getGUID();
    }

    public void removeRatingFromElement(String userId, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeRatingFromElement";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/ratings/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeRatingFromElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "removeRatingFromElement");
        this.restClient.callVoidPostRESTCall("removeRatingFromElement", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public void addLikeToElement(String userId, String elementGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLikeToElement";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/likes?isPublic={3}";
        this.invalidParameterHandler.validateUserId(userId, "addLikeToElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "addLikeToElement");
        this.restClient.callVoidPostRESTCall("addLikeToElement", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, elementGUID, isPublic});
    }

    public void removeLikeFromElement(String userId, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeLikeFromElement";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/likes/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeLikeFromElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "removeLikeFromElement");
        this.restClient.callVoidPostRESTCall("removeLikeFromElement", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public String addCommentToElement(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String elementGUID, ExternalIdentifierProperties externalIdentifierProperties, boolean isPublic, CommentProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToElement";
        String guidParameterName = "elementGUID";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/comments";
        return super.createFeedbackWithParent(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, elementGUID, "elementGUID", isPublic, (ReferenceableProperties)properties, "properties", externalIdentifierProperties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addCommentToElement");
    }

    public String addCommentReply(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String commentGUID, ExternalIdentifierProperties externalIdentifierProperties, boolean isPublic, CommentProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentReply";
        String commentGUIDParameter = "commentGUID";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/comments/{2}/replies";
        return super.createFeedbackWithParent(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, commentGUID, "commentGUID", isPublic, (ReferenceableProperties)properties, "properties", externalIdentifierProperties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addCommentReply");
    }

    public void updateComment(String userId, String assetManagerGUID, String assetManagerName, String commentGUID, String externalIdentifier, boolean isMergeUpdate, boolean isPublic, CommentProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateComment";
        String commentGUIDParameter = "commentGUID";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/comments/{2}/update";
        super.updateFeedback(userId, assetManagerGUID, assetManagerName, commentGUID, "commentGUID", externalIdentifier, isMergeUpdate, isPublic, (ReferenceableProperties)properties, "properties", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "updateComment");
    }

    public void setupAcceptedAnswer(String userId, String assetManagerGUID, String assetManagerName, String questionCommentGUID, String answerCommentGUID, FeedbackProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAcceptedAnswer";
        String questionCommentGUIDParameterName = "questionCommentGUID";
        String answerCommentGUIDParameterName = "answerCommentGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/comments/questions/{2}/answers/{3}";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, questionCommentGUID, "questionCommentGUID", (RelationshipProperties)properties, answerCommentGUID, "answerCommentGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setupAcceptedAnswer");
    }

    public void clearAcceptedAnswer(String userId, String assetManagerGUID, String assetManagerName, String questionCommentGUID, String answerCommentGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAcceptedAnswer";
        String questionCommentGUIDParameterName = "questionCommentGUID";
        String answerCommentGUIDParameterName = "answerCommentGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/comments/questions/{2}/answers/{3}/remove";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, questionCommentGUID, "questionCommentGUID", answerCommentGUID, "answerCommentGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearAcceptedAnswer");
    }

    public void removeComment(String userId, String assetManagerGUID, String assetManagerName, String commentGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeComment";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/comments/{2}/remove";
        super.removeReferenceable(userId, assetManagerGUID, assetManagerName, commentGUID, "commentGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeComment");
    }

    public CommentElement getComment(String userId, String assetManagerGUID, String assetManagerName, String commentGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getComment";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/comments/{2}?forLineage={3}&forDuplicateProcessing={4}";
        String guidParameter = "commentGUID";
        this.invalidParameterHandler.validateUserId(userId, "getComment");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "getComment");
        CommentElementResponse restResult = this.restClient.callCommentElementPostRESTCall("getComment", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, commentGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public List<CommentElement> getAttachedComments(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttachedComments";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/comments/retrieve?startFrom={3}&pageSize={4}&forLineage={}&forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, "getAttachedComments");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getAttachedComments");
        CommentElementsResponse restResult = this.restClient.callCommentElementsPostRESTCall("getAttachedComments", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<CommentElement> findComments(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findComments";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findComments");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findComments");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findComments");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/comments/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        CommentElementsResponse restResult = this.restClient.callCommentElementsPostRESTCall("findComments", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public String createInformalTag(String userId, TagProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createInformalTag";
        String propertiesParameterName = "properties";
        String nameParameterName = "properties.tagName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags";
        this.invalidParameterHandler.validateUserId(userId, "createInformalTag");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createInformalTag");
        this.invalidParameterHandler.validateName(properties.getName(), "properties.tagName", "createInformalTag");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createInformalTag", urlTemplate, properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateTagDescription";
        String guidParameter = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateTagDescription");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "updateTagDescription");
        InformalTagUpdateRequestBody tagRequestBody = new InformalTagUpdateRequestBody();
        tagRequestBody.setDescription(tagDescription);
        this.restClient.callVoidPostRESTCall("updateTagDescription", urlTemplate, tagRequestBody, new Object[]{this.serverName, userId, tagGUID});
    }

    public void deleteTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteTag";
        String guidParameter = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags/{2}/remove";
        this.invalidParameterHandler.validateUserId(userId, "deleteTag");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "deleteTag");
        this.restClient.callVoidPostRESTCall("deleteTag", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, tagGUID});
    }

    public InformalTagElement getTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTag";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags/{2}";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getTag");
        this.invalidParameterHandler.validateGUID(tagGUID, "guid", "getTag");
        InformalTagResponse restResult = this.restClient.callInformalTagGetRESTCall("getTag", urlTemplate, this.serverName, userId, tagGUID);
        return restResult.getTag();
    }

    public List<InformalTagElement> getTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTagsByName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags/by-name?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "getTagsByName");
        this.invalidParameterHandler.validateName(tag, "tag", "getTagsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(tag);
        requestBody.setNameParameterName("tag");
        InformalTagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("getTagsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public List<InformalTagElement> getMyTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTagsByName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags/private/by-name?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "getTagsByName");
        this.invalidParameterHandler.validateName(tag, "tag", "getTagsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(tag);
        requestBody.setNameParameterName("tag");
        InformalTagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("getTagsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public List<InformalTagElement> findTags(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTags";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags/by-search-string?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "findTags");
        this.invalidParameterHandler.validateName(tag, "tag", "findTags");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(tag);
        requestBody.setSearchStringParameterName("tag");
        InformalTagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("findTags", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public List<InformalTagElement> findMyTags(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findMyTags";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/tags/private/by-search-string?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "findMyTags");
        this.invalidParameterHandler.validateName(tag, "tag", "findMyTags");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(tag);
        requestBody.setSearchStringParameterName("tag");
        InformalTagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("findMyTags", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public void addTagToElement(String userId, String elementGUID, String tagGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addTagToElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/tags/{3}";
        this.invalidParameterHandler.validateUserId(userId, "addTagToElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "addTagToElement");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "addTagToElement");
        FeedbackProperties requestBody = new FeedbackProperties();
        requestBody.setIsPublic(isPublic);
        this.restClient.callVoidPostRESTCall("addTagToElement", urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, tagGUID});
    }

    public void removeTagFromElement(String userId, String elementGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTagFromElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/tags/{3}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeTagFromElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "removeTagFromElement");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "removeTagFromElement");
        this.restClient.callVoidPostRESTCall("removeTagFromElement", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, elementGUID, tagGUID});
    }

    public List<String> getElementsByTag(String userId, String tagGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getElementsByTag";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/by-tag/{2}?startFrom={3}&pageSize={4}";
        String tagGUIDParameterName = "tagGUID";
        this.invalidParameterHandler.validateUserId(userId, "getElementsByTag");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "getElementsByTag");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getElementsByTag", urlTemplate, new Object[]{this.serverName, userId, tagGUID, startFrom, pageSize});
        return restResult.getGUIDs();
    }

    public String createNoteLog(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String elementGUID, ExternalIdentifierProperties externalIdentifierProperties, NoteLogProperties noteLogProperties, boolean isPublic, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createNoteLog";
        String guidParameterName = "elementGUID";
        String propertiesParameterName = "noteLogProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(noteLogProperties.getQualifiedName(), "qualifiedName", "createNoteLog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/note-logs";
        return super.createFeedbackWithParent(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, elementGUID, "elementGUID", isPublic, (ReferenceableProperties)noteLogProperties, "noteLogProperties", externalIdentifierProperties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "createNoteLog");
    }

    public void updateNoteLog(String userId, String assetManagerGUID, String assetManagerName, String noteLogGUID, String noteLogExternalIdentifier, boolean isMergeUpdate, boolean isPublic, NoteLogProperties noteLogProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateNoteLog";
        String noteLogGUIDParameterName = "noteLogGUID";
        String propertiesParameterName = "noteLogProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/{2}/update";
        super.updateFeedback(userId, assetManagerGUID, assetManagerName, noteLogGUID, "noteLogGUID", noteLogExternalIdentifier, isMergeUpdate, isPublic, (ReferenceableProperties)noteLogProperties, "noteLogProperties", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "updateNoteLog");
    }

    public void removeNoteLog(String userId, String assetManagerGUID, String assetManagerName, String noteLogGUID, String noteLogExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeNoteLog";
        String noteLogGUIDParameterName = "noteLogGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/{2}/remove";
        super.removeReferenceable(userId, assetManagerGUID, assetManagerName, noteLogGUID, "noteLogGUID", noteLogExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeNoteLog");
    }

    public List<NoteLogElement> findNoteLogs(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findNoteLogs";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findNoteLogs");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findNoteLogs");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findNoteLogs");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        NoteLogElementsResponse restResult = this.restClient.callNoteLogElementsPostRESTCall("findNoteLogs", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<NoteLogElement> getNoteLogsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteLogsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getNoteLogsByName");
        this.invalidParameterHandler.validateName(name, "name", "getNoteLogsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNoteLogsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        NoteLogElementsResponse restResult = this.restClient.callNoteLogElementsPostRESTCall("getNoteLogsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<NoteLogElement> getNoteLogsForElement(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteLogsForElement";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNoteLogsForElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getNoteLogsForElement");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNoteLogsForElement");
        EffectiveTimeQueryRequestBody requestBody = new EffectiveTimeQueryRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/note-logs/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        NoteLogElementsResponse restResult = this.restClient.callNoteLogElementsPostRESTCall("getNoteLogsForElement", urlTemplate, requestBody, this.serverName, userId, elementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public NoteLogElement getNoteLogByGUID(String userId, String assetManagerGUID, String assetManagerName, String noteLogGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteLogByGUID";
        String guidParameterName = "noteLogGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNoteLogByGUID");
        this.invalidParameterHandler.validateGUID(noteLogGUID, "noteLogGUID", "getNoteLogByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        NoteLogElementResponse restResult = this.restClient.callNoteLogElementPostRESTCall("getNoteLogByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, noteLogGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public String createNote(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String noteLogGUID, ExternalIdentifierProperties externalIdentifierProperties, NoteProperties noteProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createNote";
        String guidParameterName = "noteLogGUID";
        String propertiesParameterName = "noteProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/{2}/notes";
        return super.createReferenceableWithParent(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, noteLogGUID, "noteLogGUID", (ReferenceableProperties)noteProperties, "noteProperties", externalIdentifierProperties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "createNote");
    }

    public void updateNote(String userId, String assetManagerGUID, String assetManagerName, String noteGUID, String noteExternalIdentifier, boolean isMergeUpdate, NoteProperties noteProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateNote";
        String noteGUIDParameterName = "noteGUID";
        String propertiesParameterName = "noteProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/notes/{2}/update";
        super.updateReferenceable(userId, assetManagerGUID, assetManagerName, noteGUID, "noteGUID", noteExternalIdentifier, isMergeUpdate, (ReferenceableProperties)noteProperties, "noteProperties", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "updateNote");
    }

    public void removeNote(String userId, String assetManagerGUID, String assetManagerName, String noteGUID, String noteExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeNote";
        String noteGUIDParameterName = "noteGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/notes/{2}/remove";
        super.removeReferenceable(userId, assetManagerGUID, assetManagerName, noteGUID, "noteGUID", noteExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeNote");
    }

    public List<NoteElement> findNotes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findNotes";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findNotes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findNotes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findNotes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/notes/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        NoteElementsResponse restResult = this.restClient.callNoteElementsPostRESTCall("findNotes", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<NoteElement> getNotesForNoteLog(String userId, String assetManagerGUID, String assetManagerName, String noteLogGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNotesForNoteLog";
        String guidParameterName = "noteLogGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNotesForNoteLog");
        this.invalidParameterHandler.validateGUID(noteLogGUID, "noteLogGUID", "getNotesForNoteLog");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNotesForNoteLog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/{2}/notes/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        NoteElementsResponse restResult = this.restClient.callNoteElementsPostRESTCall("getNotesForNoteLog", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, noteLogGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public NoteElement getNoteByGUID(String userId, String assetManagerGUID, String assetManagerName, String noteGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteByGUID";
        String guidParameterName = "noteGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNoteByGUID");
        this.invalidParameterHandler.validateGUID(noteGUID, "noteGUID", "getNoteByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/note-logs/notes/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        NoteElementResponse restResult = this.restClient.callNoteElementPostRESTCall("getNoteByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, noteGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }
}

