/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.GlossaryExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerBaseClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ArchiveRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryElementLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.HistoryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ExternalGlossaryLinkElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.ActivityDescriptionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.CanonicalVocabularyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.EditingGlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.ExternalGlossaryElementLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.ExternalGlossaryLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryCategoryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermCategorization;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermContextDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.StagingGlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.TaxonomyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.DataFieldValuesProperties;

public class GlossaryExchangeClient
extends AssetManagerBaseClient
implements GlossaryExchangeInterface {
    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public GlossaryExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public String createGlossary(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, GlossaryProperties glossaryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossary";
        String propertiesParameterName = "glossaryProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries";
        return super.createReferenceable(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, externalIdentifierProperties, (ReferenceableProperties)glossaryProperties, "glossaryProperties", urlTemplate, "createGlossary");
    }

    public String createGlossaryFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, boolean deepCopy, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryFromTemplate";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/from-template/{2}";
        return super.createReferenceableFromTemplate(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, templateGUID, templateProperties, externalIdentifierProperties, urlTemplate, deepCopy, "createGlossaryFromTemplate");
    }

    public void updateGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, boolean isMergeUpdate, GlossaryProperties glossaryProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/update";
        super.updateReferenceable(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, isMergeUpdate, (ReferenceableProperties)glossaryProperties, "glossaryProperties", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "updateGlossary");
    }

    public void setGlossaryAsEditingGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, EditingGlossaryProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsEditingGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-editing-glossary";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setGlossaryAsEditingGlossary");
    }

    public void clearGlossaryAsEditingGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsEditingGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-editing-glossary/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearGlossaryAsEditingGlossary");
    }

    public void setGlossaryAsStagingGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, StagingGlossaryProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsStagingGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-staging-glossary";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setGlossaryAsStagingGlossary");
    }

    public void clearGlossaryAsStagingGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsStagingGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-staging-glossary/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearGlossaryAsStagingGlossary");
    }

    public void setGlossaryAsTaxonomy(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, TaxonomyProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsTaxonomy";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-taxonomy";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setGlossaryAsTaxonomy");
    }

    public void clearGlossaryAsTaxonomy(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsTaxonomy";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-taxonomy/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearGlossaryAsTaxonomy");
    }

    public void setGlossaryAsCanonical(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, CanonicalVocabularyProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsCanonical";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-canonical";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setGlossaryAsCanonical");
    }

    public void clearGlossaryAsCanonical(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsCanonical";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/is-canonical/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearGlossaryAsCanonical");
    }

    public void removeGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossary";
        String glossaryGUIDParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/remove";
        super.removeReferenceable(userId, assetManagerGUID, assetManagerName, glossaryGUID, "glossaryGUID", glossaryExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeGlossary");
    }

    public List<GlossaryElement> findGlossaries(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGlossaries";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findGlossaries");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGlossaries");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGlossaries");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryElementsResponse restResult = this.restClient.callMyGlossariesPostRESTCall("findGlossaries", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryElement> getGlossariesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossariesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getGlossariesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGlossariesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossariesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryElementsResponse restResult = this.restClient.callMyGlossariesPostRESTCall("getGlossariesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryElement> getGlossariesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossariesForAssetManager";
        this.invalidParameterHandler.validateUserId(userId, "getGlossariesForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossariesForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-asset-manager?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryElementsResponse restResult = this.restClient.callMyGlossariesPostRESTCall("getGlossariesForAssetManager", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public GlossaryElement getGlossaryByGUID(String userId, String assetManagerGUID, String assetManagerName, String guid, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGlossaryByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryElementResponse restResult = this.restClient.callMyGlossaryPostRESTCall("getGlossaryByGUID", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, guid, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public GlossaryElement getGlossaryForCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryForCategory";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryForCategory");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getGlossaryForCategory");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/for-category/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryElementResponse restResult = this.restClient.callMyGlossaryPostRESTCall("getGlossaryForCategory", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public GlossaryElement getGlossaryForTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryForTerm";
        String guidParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryForTerm");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "getGlossaryForTerm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/for-term/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryElementResponse restResult = this.restClient.callMyGlossaryPostRESTCall("getGlossaryForTerm", urlTemplate, this.getAssetManagerIdentifiersRequestBody(assetManagerGUID, assetManagerName), this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public String createGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String glossaryGUID, ExternalIdentifierProperties externalIdentifierProperties, GlossaryCategoryProperties glossaryCategoryProperties, boolean isRootCategory, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryCategory";
        String guidParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryCategoryProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/categories";
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}&isRootCategory";
        this.invalidParameterHandler.validateUserId(userId, "createGlossaryCategory");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "createGlossaryCategory");
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", "createGlossaryCategory");
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "qualifiedName", "createGlossaryCategory");
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossaryCategory"));
        requestBody.setParentGUID(glossaryGUID);
        requestBody.setElementProperties((ReferenceableProperties)glossaryCategoryProperties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossaryCategory", urlTemplate + "?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}&isRootCategory", requestBody, new Object[]{this.serverName, userId, glossaryGUID, assetManagerIsHome, forLineage, forDuplicateProcessing, isRootCategory});
        return restResult.getGUID();
    }

    public String createGlossaryCategoryFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String glossaryGUID, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, boolean deepCopy, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryCategoryFromTemplate";
        String guidParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/categories/from-template/{3}";
        return super.createReferenceableFromTemplateWithParent(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, glossaryGUID, "glossaryGUID", templateGUID, templateProperties, externalIdentifierProperties, deepCopy, urlTemplate, "createGlossaryCategoryFromTemplate");
    }

    public void updateGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryCategoryExternalIdentifier, boolean isMergeUpdate, GlossaryCategoryProperties glossaryCategoryProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryCategory";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        String propertiesParameterName = "glossaryCategoryProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/update";
        super.updateReferenceable(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, "glossaryCategoryGUID", glossaryCategoryExternalIdentifier, isMergeUpdate, (ReferenceableProperties)glossaryCategoryProperties, "glossaryCategoryProperties", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "updateGlossaryCategory");
    }

    public void setupCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupCategoryParent";
        String glossaryParentGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryChildCategoryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/subcategories/{3}";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, glossaryParentCategoryGUID, "glossaryParentCategoryGUID", null, glossaryChildCategoryGUID, "glossaryChildCategoryGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setupCategoryParent");
    }

    public void clearCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCategoryParent";
        String glossaryParentGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryChildCategoryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/subcategory/{3}/remove";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, glossaryParentCategoryGUID, "glossaryParentCategoryGUID", glossaryChildCategoryGUID, "glossaryChildCategoryGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearCategoryParent");
    }

    public void removeGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryCategoryExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossaryCategory";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/remove";
        super.removeReferenceable(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, "glossaryCategoryGUID", glossaryCategoryExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeGlossaryCategory");
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGlossaryCategories";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findGlossaryCategories");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGlossaryCategories");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGlossaryCategories");
        GlossarySearchStringRequestBody requestBody = new GlossarySearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setGlossaryGUID(glossaryGUID);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callMyGlossaryCategoriesPostRESTCall("findGlossaryCategories", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryCategoryElement> getCategoriesForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCategoriesForGlossary";
        String guidParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCategoriesForGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "getCategoriesForGlossary");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCategoriesForGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/categories/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callMyGlossaryCategoriesPostRESTCall("getCategoriesForGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryCategoryElement> getCategoriesForTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCategoriesForTerm";
        String guidParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCategoriesForTerm");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryGUID", "getCategoriesForTerm");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCategoriesForTerm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/categories/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callMyGlossaryCategoriesPostRESTCall("getCategoriesForTerm", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryTermGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoriesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoriesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGlossaryCategoriesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossaryCategoriesByName");
        GlossaryNameRequestBody requestBody = new GlossaryNameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setGlossaryGUID(glossaryGUID);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callMyGlossaryCategoriesPostRESTCall("getGlossaryCategoriesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public GlossaryCategoryElement getGlossaryCategoryByGUID(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoryByGUID";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoryByGUID");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getGlossaryCategoryByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryCategoryElementResponse restResult = this.restClient.callMyGlossaryCategoryPostRESTCall("getGlossaryCategoryByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public GlossaryCategoryElement getGlossaryCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoryParent";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoryParent");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getGlossaryCategoryParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/parent/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryCategoryElementResponse restResult = this.restClient.callMyGlossaryCategoryPostRESTCall("getGlossaryCategoryParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public List<GlossaryCategoryElement> getGlossarySubCategories(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoriesByName";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryCategoriesByName");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getGlossaryCategoriesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossaryCategoriesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/subcategories/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryCategoryElementsResponse restResult = this.restClient.callMyGlossaryCategoriesPostRESTCall("getGlossaryCategoriesByName", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryCategoryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public String createGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String glossaryGUID, ExternalIdentifierProperties externalIdentifierProperties, GlossaryTermProperties glossaryTermProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryTerm";
        String guidParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryTermProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/terms";
        return super.createReferenceableWithParent(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, glossaryGUID, "glossaryGUID", (ReferenceableProperties)glossaryTermProperties, "glossaryTermProperties", externalIdentifierProperties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "createGlossaryTerm");
    }

    public String createControlledGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String glossaryGUID, ExternalIdentifierProperties externalIdentifierProperties, GlossaryTermProperties glossaryTermProperties, GlossaryTermStatus initialStatus, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createControlledGlossaryTerm";
        String guidParameterName = "glossaryGUID";
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createControlledGlossaryTerm");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "createControlledGlossaryTerm");
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", "createControlledGlossaryTerm");
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", "createControlledGlossaryTerm");
        ControlledGlossaryTermRequestBody requestBody = new ControlledGlossaryTermRequestBody();
        requestBody.setElementProperties(glossaryTermProperties);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createControlledGlossaryTerm"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/terms/new-controlled";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createControlledGlossaryTerm", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryGUID});
        return restResult.getGUID();
    }

    public String createGlossaryTermFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String glossaryGUID, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, boolean deepCopy, GlossaryTermStatus initialStatus, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryTermFromTemplate";
        String guidParameterName = "glossaryGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/terms/from-template/{3}";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String requestParamsURLTemplate = "?assetManagerIsHome={4}&deepCopy={5}";
        this.invalidParameterHandler.validateUserId(userId, "createGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "createGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createGlossaryTermFromTemplate");
        GlossaryTemplateRequestBody requestBody = new GlossaryTemplateRequestBody();
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createGlossaryTermFromTemplate"));
        requestBody.setParentGUID(glossaryGUID);
        requestBody.setElementProperties(templateProperties);
        requestBody.setGlossaryTermStatus(initialStatus);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGlossaryTermFromTemplate", urlTemplate + "?assetManagerIsHome={4}&deepCopy={5}", requestBody, new Object[]{this.serverName, userId, glossaryGUID, templateGUID, assetManagerIsHome, deepCopy});
        return restResult.getGUID();
    }

    public void updateGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, boolean isMergeUpdate, GlossaryTermProperties glossaryTermProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryTerm";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String propertiesParameterName = "glossaryTermProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/update";
        super.updateReferenceable(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, isMergeUpdate, (ReferenceableProperties)glossaryTermProperties, "glossaryTermProperties", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "updateGlossaryTerm");
    }

    public void updateGlossaryTermStatus(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, GlossaryTermStatus glossaryTermStatus, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryTermStatus";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String propertiesParameterName = "glossaryTermStatus";
        this.invalidParameterHandler.validateUserId(userId, "updateGlossaryTermStatus");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "updateGlossaryTermStatus");
        this.invalidParameterHandler.validateObject((Object)glossaryTermStatus, "glossaryTermStatus", "updateGlossaryTermStatus");
        GlossaryTermStatusRequestBody requestBody = new GlossaryTermStatusRequestBody();
        requestBody.setGlossaryTermStatus(glossaryTermStatus);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "updateGlossaryTermStatus"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/status?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updateGlossaryTermStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void updateGlossaryTermFromTemplate(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, String templateGUID, boolean isMergeClassifications, boolean isMergeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryTermFromTemplate";
        String glossaryGUIDParameterName = "templateGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "templateGUID", "updateGlossaryTermFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "glossaryTermGUID", "updateGlossaryTermFromTemplate");
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setParentGUID(templateGUID);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "updateGlossaryTermFromTemplate"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/update/from-template?isMergeClassifications={3}&isMergeProperties={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("updateGlossaryTermFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, isMergeClassifications, isMergeProperties, forLineage, forDuplicateProcessing});
    }

    public void moveGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, String newGlossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "moveGlossaryTerm";
        String glossaryGUIDParameterName = "newGlossaryGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "moveGlossaryTerm");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "newGlossaryGUID", "moveGlossaryTerm");
        this.invalidParameterHandler.validateGUID(newGlossaryGUID, "glossaryTermGUID", "moveGlossaryTerm");
        ReferenceableUpdateRequestBody requestBody = new ReferenceableUpdateRequestBody();
        requestBody.setParentGUID(newGlossaryGUID);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "moveGlossaryTerm"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/move?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("moveGlossaryTerm", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing});
    }

    public void setupTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, GlossaryTermCategorization categorizationProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupTermCategory";
        String glossaryParentGUIDParameterName = "glossaryCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/terms/{3}";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, "glossaryCategoryGUID", (RelationshipProperties)categorizationProperties, glossaryTermGUID, "glossaryTermGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setupTermCategory");
    }

    public void clearTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermCategory";
        String glossaryParentGUIDParameterName = "glossaryCategoryGUID";
        String glossaryChildGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/terms/{3}/remove";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, "glossaryCategoryGUID", glossaryTermGUID, "glossaryTermGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermCategory");
    }

    public List<String> getTermRelationshipTypeNames(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTermRelationshipTypeNames";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/relationships/type-names";
        this.invalidParameterHandler.validateUserId(userId, "getTermRelationshipTypeNames");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTermRelationshipTypeNames", urlTemplate, new Object[]{this.serverName, userId});
        return restResult.getNames();
    }

    public void setupTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupTermRelationship";
        String glossaryParentGUIDParameterName = "glossaryTermOneGUID";
        String glossaryChildGUIDParameterName = "glossaryTermTwoGUID";
        String glossaryTypeParameterName = "relationshipTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/relationships/{3}/terms/{4}";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", (RelationshipProperties)relationshipsProperties, glossaryTermTwoGUID, "glossaryTermTwoGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setupTermRelationship");
    }

    public void updateTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateTermRelationship";
        String glossaryParentGUIDParameterName = "glossaryTermOneGUID";
        String glossaryChildGUIDParameterName = "glossaryTermTwoGUID";
        String glossaryTypeParameterName = "relationshipTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/relationships/{3}/terms/{4}/update";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", (RelationshipProperties)relationshipsProperties, glossaryTermTwoGUID, "glossaryTermTwoGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "updateTermRelationship");
    }

    public void clearTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermRelationship";
        String glossaryParentGUIDParameterName = "glossaryTermOneGUID";
        String glossaryChildGUIDParameterName = "glossaryTermTwoGUID";
        String glossaryTypeParameterName = "relationshipTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/relationships/{3}/terms/{4}/remove";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermRelationship");
    }

    public void setTermAsAbstractConcept(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsAbstractConcept";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-abstract-concept";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, null, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsAbstractConcept");
    }

    public void clearTermAsAbstractConcept(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsAbstractConcept";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-abstract-concept/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsAbstractConcept");
    }

    public void setTermAsDataField(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, DataFieldValuesProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsDataField";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-data-field";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsDataField");
    }

    public void clearTermAsDataField(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsDataField";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-data-field/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsDataField");
    }

    public void setTermAsDataValue(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsDataValue";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-data-value";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, null, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsDataValue");
    }

    public void clearTermAsDataValue(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsDataValue";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-data-value/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsDataValue");
    }

    public void setTermAsActivity(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, ActivityDescriptionProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsActivity";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-activity";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsActivity");
    }

    public void clearTermAsActivity(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsActivity";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-activity/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsActivity");
    }

    public void setTermAsContext(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, GlossaryTermContextDefinition contextDefinition, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsContext";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-context-definition";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, (ClassificationProperties)contextDefinition, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsContext");
    }

    public void clearTermAsContext(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsContext";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-context-definition/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsContext");
    }

    public void setTermAsSpineObject(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsSpineObject";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-object";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, null, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsSpineObject");
    }

    public void clearTermAsSpineObject(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsSpineObject";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-object/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsSpineObject");
    }

    public void setTermAsSpineAttribute(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsSpineAttribute";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-attribute";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, null, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsSpineAttribute");
    }

    public void clearTermAsSpineAttribute(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsSpineAttribute";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-spine-attribute/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsSpineAttribute");
    }

    public void setTermAsObjectIdentifier(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsObjectIdentifier";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-object-identifier";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, null, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setTermAsObjectIdentifier");
    }

    public void clearTermAsObjectIdentifier(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsObjectIdentifier";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/is-object-identifier/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearTermAsObjectIdentifier");
    }

    public GlossaryTermElement undoGlossaryTermUpdate(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "undoGlossaryTermUpdate";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "undoGlossaryTermUpdate");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "undoGlossaryTermUpdate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/undo&forLineage={3}&forDuplicateProcessing={4}";
        GlossaryTermElementResponse response = this.restClient.callMyGlossaryTermPostRESTCall("undoGlossaryTermUpdate", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, effectiveTime, "undoGlossaryTermUpdate"), this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing);
        return response.getElement();
    }

    public void archiveGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, ArchiveProperties archiveProperties, Date effectiveTime, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "archiveGlossaryTerm";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "archiveGlossaryTerm");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "archiveGlossaryTerm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/archive?forDuplicateProcessing={3}";
        ArchiveRequestBody requestBody = new ArchiveRequestBody();
        requestBody.setElementProperties(archiveProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, glossaryTermExternalIdentifier, "archiveGlossaryTerm"));
        this.restClient.callVoidPostRESTCall("archiveGlossaryTerm", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, forDuplicateProcessing});
    }

    public void removeGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossaryTerm";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/remove";
        super.removeReferenceable(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, "glossaryTermGUID", glossaryTermExternalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeGlossaryTerm");
    }

    public List<GlossaryTermElement> findGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String searchString, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGlossaryTerms";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findGlossaryTerms");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGlossaryTerms");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGlossaryTerms");
        GlossarySearchStringRequestBody requestBody = new GlossarySearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setGlossaryGUID(glossaryGUID);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryTermElementsResponse restResult = this.restClient.callMyGlossaryTermsPostRESTCall("findGlossaryTerms", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryTermElement> getTermsForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTermsForGlossary";
        String guidParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTermsForGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "getTermsForGlossary");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTermsForGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/terms/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryTermElementsResponse restResult = this.restClient.callMyGlossaryTermsPostRESTCall("getTermsForGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryTermElement> getRelatedTerms(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String relationshipTypeName, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedTerms";
        String guidParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedTerms");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "getRelatedTerms");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getRelatedTerms");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/related-terms?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryTermElementsResponse restResult = this.restClient.callMyGlossaryTermsPostRESTCall("getRelatedTerms", urlTemplate, this.getGlossaryTermRelationshipRequestBody(assetManagerGUID, assetManagerName, relationshipTypeName, limitResultsByStatus, effectiveTime), this.serverName, userId, glossaryTermGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryTermElement> getTermsForGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTermsForGlossaryCategory";
        String guidParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTermsForGlossaryCategory");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "getTermsForGlossaryCategory");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTermsForGlossaryCategory");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/terms/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryTermElementsResponse restResult = this.restClient.callMyGlossaryTermsPostRESTCall("getTermsForGlossaryCategory", urlTemplate, this.getGlossaryTermRelationshipRequestBody(assetManagerGUID, assetManagerName, null, limitResultsByStatus, effectiveTime), this.serverName, userId, glossaryCategoryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String name, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryTermsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryTermsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGlossaryTermsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossaryTermsByName");
        GlossaryNameRequestBody requestBody = new GlossaryNameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setGlossaryGUID(glossaryGUID);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        GlossaryTermElementsResponse restResult = this.restClient.callMyGlossaryTermsPostRESTCall("getGlossaryTermsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public GlossaryTermElement getGlossaryTermByGUID(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryTermByGUID";
        String guidParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryTermByGUID");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "getGlossaryTermByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        GlossaryTermElementResponse restResult = this.restClient.callMyGlossaryTermPostRESTCall("getGlossaryTermByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public List<GlossaryTermElement> getGlossaryTermHistory(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, Date fromTime, Date toTime, int startFrom, int pageSize, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGlossaryTermHistory";
        String guidParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossaryTermHistory");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "getGlossaryTermHistory");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossaryTermHistory");
        HistoryRequestBody requestBody = new HistoryRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setFromTime(fromTime);
        requestBody.setToTime(toTime);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/history?startFrom={3}&pageSize={4}&oldestFirst={5}&forLineage={6}&forDuplicateProcessing={7}";
        GlossaryTermElementsResponse restResult = this.restClient.callMyGlossaryTermsPostRESTCall("getGlossaryTermHistory", urlTemplate, requestBody, this.serverName, userId, glossaryTermGUID, startFrom, validatedPageSize, oldestFirst, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public String createExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, ExternalGlossaryLinkProperties linkProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalGlossaryLink";
        String propertiesParameterName = "linkProperties";
        this.invalidParameterHandler.validateUserId(userId, "createExternalGlossaryLink");
        this.invalidParameterHandler.validateObject((Object)linkProperties, "linkProperties", "createExternalGlossaryLink");
        ExternalGlossaryLinkRequestBody requestBody = new ExternalGlossaryLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/external-links";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalGlossaryLink", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, boolean isMergeUpdate, ExternalGlossaryLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalGlossaryLink";
        String guidParameterName = "externalLinkGUID";
        String propertiesParameterName = "linkProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalGlossaryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "updateExternalGlossaryLink");
        this.invalidParameterHandler.validateObject((Object)linkProperties, "linkProperties", "updateExternalGlossaryLink");
        ExternalGlossaryLinkRequestBody requestBody = new ExternalGlossaryLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/external-links/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateExternalGlossaryLink", urlTemplate, requestBody, new Object[]{this.serverName, userId, externalLinkGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void removeExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeExternalGlossaryLink";
        String guidParameterName = "externalLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeExternalGlossaryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "removeExternalGlossaryLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/external-links/{2}/remove&forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeExternalGlossaryLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void attachExternalLinkToGlossary(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalLinkToGlossary";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachExternalLinkToGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "attachExternalLinkToGlossary");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "attachExternalLinkToGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/external-links/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("attachExternalLinkToGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void detachExternalLinkFromGlossary(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalLinkFromGlossary";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachExternalLinkFromGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "detachExternalLinkFromGlossary");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "detachExternalLinkFromGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/external-links/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("detachExternalLinkFromGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public List<ExternalGlossaryLinkElement> getExternalLinksForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalLinksForGlossary";
        String guidParameterName = "glossaryGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalLinksForGlossary");
        this.invalidParameterHandler.validateGUID(glossaryGUID, "glossaryGUID", "getExternalLinksForGlossary");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalLinksForGlossary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/{2}/external-links/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        ExternalGlossaryLinkElementsResponse restResult = this.restClient.callMyExternalGlossaryLinksPostRESTCall("getExternalLinksForGlossary", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, glossaryGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<GlossaryElement> getGlossariesForExternalLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossariesForExternalLink";
        String guidParameterName = "externalLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGlossariesForExternalLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "getGlossariesForExternalLink");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGlossariesForExternalLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/by-external-links/{2}/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        GlossaryElementsResponse restResult = this.restClient.callMyGlossariesPostRESTCall("getGlossariesForExternalLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, externalLinkGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public void attachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryCategoryGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalCategoryLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "attachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "attachExternalCategoryLink");
        ExternalGlossaryElementLinkRequestBody requestBody = new ExternalGlossaryElementLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/external-links/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("attachExternalCategoryLink", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryCategoryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void detachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryCategoryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalCategoryLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryCategoryGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, "glossaryCategoryGUID", "detachExternalCategoryLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "detachExternalCategoryLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/categories/{2}/external-links/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("detachExternalCategoryLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryCategoryGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void attachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryTermGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalTermLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachExternalTermLink");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "attachExternalTermLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "attachExternalTermLink");
        ExternalGlossaryElementLinkRequestBody requestBody = new ExternalGlossaryElementLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/external-links/{3}?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("attachExternalTermLink", urlTemplate, requestBody, new Object[]{this.serverName, userId, glossaryTermGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }

    public void detachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalTermLink";
        String guidParameterName = "externalLinkGUID";
        String glossaryGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachExternalTermLink");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "detachExternalTermLink");
        this.invalidParameterHandler.validateGUID(externalLinkGUID, "externalLinkGUID", "detachExternalTermLink");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/{2}/external-links/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("detachExternalTermLink", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, glossaryTermGUID, externalLinkGUID, forLineage, forDuplicateProcessing});
    }
}

