/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.ConnectionExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EmbeddedConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties;

public class ConnectionExchangeClient
extends ExchangeClientBase
implements ConnectionExchangeInterface {
    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public ConnectionExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public String createConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        String propertiesParameterName = "connectionProperties";
        String qualifiedNameParameterName = "connectionProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionProperties", "createConnection");
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionProperties.qualifiedName", "createConnection");
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setElementProperties(connectionProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createConnection"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createConnectionFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectionFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createConnectionFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createConnectionFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectionFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateConnection(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String connectionExternalIdentifier, boolean isMergeUpdate, ConnectionProperties connectionProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String propertiesParameterName = "connectionProperties";
        String qualifiedNameParameterName = "connectionProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "updateConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionProperties", "updateConnection");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionProperties.qualifiedName", "updateConnection");
        }
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setElementProperties(connectionProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectionExternalIdentifier, "updateConnection"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void setupConnectorType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String connectorTypeGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "setupConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/connector-types/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        RelationshipProperties properties = new RelationshipProperties();
        properties.setEffectiveFrom(effectiveFrom);
        properties.setEffectiveTo(effectiveTo);
        this.restClient.callVoidPostRESTCall("setupConnectorType", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, properties), new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearConnectorType(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String connectorTypeGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "clearConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/connector-types/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearConnectorType", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID, forLineage, forDuplicateProcessing});
    }

    public void setupEndpoint(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String endpointGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "setupEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/endpoints/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        RelationshipProperties properties = new RelationshipProperties();
        properties.setEffectiveFrom(effectiveFrom);
        properties.setEffectiveTo(effectiveTo);
        this.restClient.callVoidPostRESTCall("setupEndpoint", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, properties), new Object[]{this.serverName, userId, connectionGUID, endpointGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearEndpoint(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String endpointGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "clearEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/endpoints/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearEndpoint", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, connectionGUID, endpointGUID, forLineage, forDuplicateProcessing});
    }

    public void setupEmbeddedConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "setupEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/embedded-connections/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("setupEmbeddedConnection", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearEmbeddedConnection(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String embeddedConnectionGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "clearEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/embedded-connections/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearEmbeddedConnection", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID, forLineage, forDuplicateProcessing});
    }

    public void setupAssetConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String assetGUID, String connectionGUID, AssetConnectionProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        String assetGUIDParameterName = "assetGUID";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/connections/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("setupAssetConnection", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, assetGUID, connectionGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearAssetConnection(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String connectionGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        String assetGUIDParameterName = "assetGUID";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-assets/{2}/connections/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearAssetConnection", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, assetGUID, connectionGUID, forLineage, forDuplicateProcessing});
    }

    public void removeConnection(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String connectionExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "removeConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeConnection", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, connectionExternalIdentifier, effectiveTime, "removeConnection"), new Object[]{this.serverName, userId, connectionGUID, forLineage, forDuplicateProcessing});
    }

    public List<ConnectionElement> findConnections(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnections";
        this.invalidParameterHandler.validateUserId(userId, "findConnections");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnections");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ConnectionsResponse restResult = this.restClient.callMyConnectionsPostRESTCall("findConnections", urlTemplate, this.getSearchStringRequestBody(assetManagerGUID, assetManagerName, searchString, effectiveTime, "findConnections"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<ConnectionElement> getConnectionsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionsByName";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ConnectionsResponse restResult = this.restClient.callMyConnectionsPostRESTCall("getConnectionsByName", urlTemplate, this.getNameRequestBody(assetManagerGUID, assetManagerName, name, effectiveTime, "getConnectionsByName"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<ConnectionElement> getConnectionsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionsForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionsForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getConnectionsForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionsForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/by-asset-manager?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ConnectionsResponse restResult = this.restClient.callMyConnectionsPostRESTCall("getConnectionsForAssetManager", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public ConnectionElement getConnectionByGUID(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByGUID";
        String guidParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectionByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connections/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        ConnectionResponse restResult = this.restClient.callMyConnectionPostRESTCall("getConnectionByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, connectionGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public String createEndpoint(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpoint";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "endpointProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "createEndpoint");
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", "createEndpoint");
        EndpointRequestBody requestBody = new EndpointRequestBody();
        requestBody.setElementProperties(endpointProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createEndpoint"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createEndpointFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEndpointFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createEndpointFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createEndpointFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpointFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateEndpoint(String userId, String assetManagerGUID, String assetManagerName, String endpointGUID, String endpointExternalIdentifier, boolean isMergeUpdate, EndpointProperties endpointProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "endpointProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "updateEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "updateEndpoint");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", "updateEndpoint");
        }
        EndpointRequestBody requestBody = new EndpointRequestBody();
        requestBody.setElementProperties(endpointProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, endpointExternalIdentifier, "updateEndpoint"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, endpointGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void removeEndpoint(String userId, String assetManagerGUID, String assetManagerName, String endpointGUID, String endpointExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        String connectorTypeGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "removeEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeEndpoint", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, endpointExternalIdentifier, effectiveTime, "removeEndpoint"), new Object[]{this.serverName, userId, endpointGUID, forLineage, forDuplicateProcessing});
    }

    public List<EndpointElement> findEndpoints(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEndpoints";
        this.invalidParameterHandler.validateUserId(userId, "findEndpoints");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findEndpoints");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        EndpointsResponse restResult = this.restClient.callMyEndpointsPostRESTCall("findEndpoints", urlTemplate, this.getSearchStringRequestBody(assetManagerGUID, assetManagerName, searchString, effectiveTime, "findEndpoints"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<EndpointElement> getEndpointsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsByName";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        EndpointsResponse restResult = this.restClient.callMyEndpointsPostRESTCall("getEndpointsByName", urlTemplate, this.getNameRequestBody(assetManagerGUID, assetManagerName, name, effectiveTime, "getEndpointsByName"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<EndpointElement> getEndpointsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getEndpointsForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/by-asset-manager?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        EndpointsResponse restResult = this.restClient.callMyEndpointsPostRESTCall("getEndpointsForAssetManager", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public EndpointElement getEndpointByGUID(String userId, String assetManagerGUID, String assetManagerName, String endpointGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointByGUID";
        String guidParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointByGUID");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "getEndpointByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/endpoints/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        EndpointResponse restResult = this.restClient.callMyEndpointPostRESTCall("getEndpointByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, endpointGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public String createConnectorType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorType";
        String propertiesParameterName = "connectorTypeProperties";
        String qualifiedNameParameterName = "connectorTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectorType");
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", "createConnectorType");
        this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "connectorTypeProperties.qualifiedName", "createConnectorType");
        ConnectorTypeRequestBody requestBody = new ConnectorTypeRequestBody();
        requestBody.setElementProperties(connectorTypeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createConnectorType"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createConnectorTypeFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createConnectorTypeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createConnectorTypeFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types/from-template/{2}?assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectorTypeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateConnectorType(String userId, String assetManagerGUID, String assetManagerName, String connectorTypeGUID, String connectorTypeExternalIdentifier, boolean isMergeUpdate, ConnectorTypeProperties connectorTypeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnectorType";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        String propertiesParameterName = "connectorTypeProperties";
        String qualifiedNameParameterName = "connectorTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "updateConnectorType");
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", "updateConnectorType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "connectorTypeProperties.qualifiedName", "updateConnectorType");
        }
        ConnectorTypeRequestBody requestBody = new ConnectorTypeRequestBody();
        requestBody.setElementProperties(connectorTypeProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, connectorTypeExternalIdentifier, "updateConnectorType"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectorTypeGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void removeConnectorType(String userId, String assetManagerGUID, String assetManagerName, String connectorTypeGUID, String connectorTypeExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnectorType";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "removeConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeConnectorType", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, connectorTypeExternalIdentifier, effectiveTime, "removeConnectorType"), new Object[]{this.serverName, userId, connectorTypeGUID, forLineage, forDuplicateProcessing});
    }

    public List<ConnectorTypeElement> findConnectorTypes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnectorTypes";
        this.invalidParameterHandler.validateUserId(userId, "findConnectorTypes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnectorTypes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ConnectorTypesResponse restResult = this.restClient.callMyConnectorTypesPostRESTCall("findConnectorTypes", urlTemplate, this.getSearchStringRequestBody(assetManagerGUID, assetManagerName, searchString, effectiveTime, "findConnectorTypes"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypesByName";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ConnectorTypesResponse restResult = this.restClient.callMyConnectorTypesPostRESTCall("getConnectorTypesByName", urlTemplate, this.getNameRequestBody(assetManagerGUID, assetManagerName, name, effectiveTime, "getConnectorTypesByName"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<ConnectorTypeElement> getConnectorTypesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypesForAssetManager";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypesForAssetManager");
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", "getConnectorTypesForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypesForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types/by-asset-manager?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ConnectorTypesResponse restResult = this.restClient.callMyConnectorTypesPostRESTCall("getConnectorTypesForAssetManager", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByGUID";
        String guidParameterName = "openMetadataGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByGUID");
        this.invalidParameterHandler.validateGUID(openMetadataGUID, "openMetadataGUID", "getConnectorTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/connector-types/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        ConnectorTypeResponse restResult = this.restClient.callMyConnectorTypePostRESTCall("getConnectorTypeByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, openMetadataGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }
}

