/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.ExternalReferencesInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceProperties;

public class ExternalReferenceExchangeClient
extends ExchangeClientBase
implements ExternalReferencesInterface {
    public ExternalReferenceExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public ExternalReferenceExchangeClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public ExternalReferenceExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public ExternalReferenceExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public ExternalReferenceExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public String createExternalReference(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, String anchorGUID, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalReference";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createExternalReference");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createExternalReference");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createExternalReference");
        ExternalReferenceRequestBody requestBody = new ExternalReferenceRequestBody();
        requestBody.setElementProperties(properties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createExternalReference"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalReference", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateExternalReference(String userId, String assetManagerGUID, String assetManagerName, String externalReferenceGUID, String referenceExternalIdentifier, boolean isMergeUpdate, ExternalReferenceProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalReference";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalReference");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "updateExternalReference");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateExternalReference");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateExternalReference");
        }
        ExternalReferenceRequestBody requestBody = new ExternalReferenceRequestBody();
        requestBody.setElementProperties(properties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, referenceExternalIdentifier, "updateExternalReference"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateExternalReference", urlTemplate, requestBody, new Object[]{this.serverName, userId, externalReferenceGUID, isMergeUpdate});
    }

    public void deleteExternalReference(String userId, String assetManagerGUID, String assetManagerName, String externalReferenceGUID, String referenceExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteExternalReference");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "deleteExternalReference");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/{2}/remove";
        this.restClient.callVoidPostRESTCall("deleteExternalReference", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, referenceExternalIdentifier, effectiveTime, "deleteExternalReference"), new Object[]{this.serverName, userId, externalReferenceGUID});
    }

    public String linkExternalReferenceToElement(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String attachedToGUID, String externalReferenceGUID, ExternalReferenceLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        String attachedToGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "linkExternalReferenceToElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/{2}/links/{3}?assetManagerIsHome={4}";
        ExternalReferenceLinkRequestBody requestBody = new ExternalReferenceLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("linkExternalReferenceToElement", urlTemplate, requestBody, new Object[]{this.serverName, userId, externalReferenceGUID, attachedToGUID});
        return restResult.getGUID();
    }

    public void updateExternalReferenceToElementLink(String userId, String assetManagerGUID, String assetManagerName, String externalReferenceLinkGUID, ExternalReferenceLinkProperties linkProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        String externalReferenceGUIDParameterName = "externalReferenceLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(externalReferenceLinkGUID, "externalReferenceLinkGUID", "linkExternalReferenceToElement");
        ExternalReferenceLinkRequestBody requestBody = new ExternalReferenceLinkRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setElementProperties(linkProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/links/{2}/update";
        this.restClient.callVoidPostRESTCall("linkExternalReferenceToElement", urlTemplate, requestBody, new Object[]{this.serverName, userId, externalReferenceLinkGUID});
    }

    public void unlinkExternalReferenceFromElement(String userId, String assetManagerGUID, String assetManagerName, String externalReferenceLinkGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        String externalReferenceGUIDParameterName = "externalReferenceLinkGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(externalReferenceLinkGUID, "externalReferenceLinkGUID", "linkExternalReferenceToElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/links/{2}/remove";
        this.restClient.callVoidPostRESTCall("linkExternalReferenceToElement", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, externalReferenceLinkGUID});
    }

    public List<ExternalReferenceElement> getExternalReferences(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReferences";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferences");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferences");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/by-type?startFrom={2}&pageSize={3}";
        ExternalReferenceElementsResponse restResult = this.restClient.callMyExternalReferencesPostRESTCall("getExternalReferences", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ExternalReferenceElement> getExternalReferencesById(String userId, String assetManagerGUID, String assetManagerName, String resourceId, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReferencesById";
        String nameParameterName = "resourceId";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferencesById");
        this.invalidParameterHandler.validateName(resourceId, "resourceId", "getExternalReferencesById");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferencesById");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(resourceId);
        requestBody.setNameParameterName("resourceId");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/by-resource-id?startFrom={2}&pageSize={3}";
        ExternalReferenceElementsResponse restResult = this.restClient.callMyExternalReferencesPostRESTCall("getExternalReferencesById", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ExternalReferenceElement> getExternalReferencesByURL(String userId, String assetManagerGUID, String assetManagerName, String url, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReferencesByURL";
        String nameParameterName = "url";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferencesByURL");
        this.invalidParameterHandler.validateName(url, "url", "getExternalReferencesByURL");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferencesByURL");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(url);
        requestBody.setNameParameterName("url");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/by-url?startFrom={2}&pageSize={3}";
        ExternalReferenceElementsResponse restResult = this.restClient.callMyExternalReferencesPostRESTCall("getExternalReferencesByURL", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ExternalReferenceElement> getExternalReferencesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReferencesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferencesByName");
        this.invalidParameterHandler.validateName(name, "name", "getExternalReferencesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferencesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/by-name?startFrom={2}&pageSize={3}";
        ExternalReferenceElementsResponse restResult = this.restClient.callMyExternalReferencesPostRESTCall("getExternalReferencesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ExternalReferenceElement> getExternalReferencesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalReferencesForAssetManager";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferencesForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferencesForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/by-asset-manager?startFrom={2}&pageSize={3}";
        ExternalReferenceElementsResponse restResult = this.restClient.callMyExternalReferencesPostRESTCall("getExternalReferencesForAssetManager", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ExternalReferenceElement> findExternalReferences(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferences";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findExternalReferences");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findExternalReferences");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findExternalReferences");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/by-search-string?startFrom={2}&pageSize={3}";
        ExternalReferenceElementsResponse restResult = this.restClient.callMyExternalReferencesPostRESTCall("findExternalReferences", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ExternalReferenceLinkElement> retrieveAttachedExternalReferences(String userId, String assetManagerGUID, String assetManagerName, String attachedToGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAttachedExternalReferences";
        String guidParameterName = "attachedToGUID";
        this.invalidParameterHandler.validateUserId(userId, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "retrieveAttachedExternalReferences");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "retrieveAttachedExternalReferences");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/attached-to/{2}?startFrom={3}&pageSize={4}";
        ExternalReferenceLinkElementsResponse restResult = this.restClient.callMyExternalReferenceLinksPostRESTCall("retrieveAttachedExternalReferences", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, attachedToGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ExternalReferenceElement getExternalReferenceByGUID(String userId, String assetManagerGUID, String assetManagerName, String externalReferenceGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalReferenceByGUID";
        String guidParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferenceByGUID");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "getExternalReferenceByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/external-references/{2}/by-guid";
        ExternalReferenceElementResponse restResult = this.restClient.callExternalReferencePostRESTCall("getExternalReferenceByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, externalReferenceGUID);
        return restResult.getElement();
    }
}

