/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.LineageExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.SchemaExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFlowElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.PortProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.ProcessContainmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.ProcessProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.ControlFlowProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.DataFlowProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.LineageMappingProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.ProcessCallProperties;

public class LineageExchangeClient
extends SchemaExchangeClientBase
implements LineageExchangeInterface {
    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public LineageExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public String createProcess(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, ProcessStatus processStatus, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createProcess");
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", "createProcess");
        this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", "createProcess");
        ProcessRequestBody requestBody = new ProcessRequestBody();
        requestBody.setElementProperties(processProperties);
        requestBody.setProcessStatus(processStatus);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createProcess"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes?assetManagerIsHome={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createProcess", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetManagerIsHome});
        return restResult.getGUID();
    }

    public String createProcessFromTemplate(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createProcessFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createProcessFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createProcessFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createProcessFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createProcessFromTemplate"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/from-template/{2}assetManagerIsHome={3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createProcessFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, assetManagerIsHome});
        return restResult.getGUID();
    }

    public void updateProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String processExternalIdentifier, boolean isMergeUpdate, ProcessProperties processProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        String processGUIDParameterName = "processGUID";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "updateProcess");
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", "updateProcess");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", "updateProcess");
        }
        ProcessRequestBody requestBody = new ProcessRequestBody();
        requestBody.setElementProperties(processProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, processExternalIdentifier, "updateProcess"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}?isMergeUpdate={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("updateProcess", urlTemplate, requestBody, new Object[]{this.serverName, userId, processGUID, isMergeUpdate, forLineage, forDuplicateProcessing});
    }

    public void updateProcessStatus(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String processExternalIdentifier, ProcessStatus processStatus, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        String portGUIDParameterName = "processGUID";
        String propertiesParameterName = "processStatus";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessStatus");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "updateProcessStatus");
        this.invalidParameterHandler.validateObject((Object)processStatus, "processStatus", "updateProcessStatus");
        ProcessStatusRequestBody requestBody = new ProcessStatusRequestBody();
        requestBody.setProcessStatus(processStatus);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, processExternalIdentifier, "updateProcessStatus"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/status?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updateProcessStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, processGUID, forLineage, forDuplicateProcessing});
    }

    public void setupProcessParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentProperties containmentProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessParent";
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        String propertiesParameterName = "containmentProperties";
        String containmentTypeParameterName = "containmentProperties.containmentType";
        this.invalidParameterHandler.validateUserId(userId, "setupProcessParent");
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", "setupProcessParent");
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", "setupProcessParent");
        this.invalidParameterHandler.validateObject((Object)containmentProperties, "containmentProperties", "setupProcessParent");
        this.invalidParameterHandler.validateEnum((Object)containmentProperties.getProcessContainmentType(), "containmentProperties.containmentType", "setupProcessParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/parent/{2}/child/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("setupProcessParent", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)containmentProperties), new Object[]{this.serverName, userId, parentProcessGUID, childProcessGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearProcessParent(String userId, String assetManagerGUID, String assetManagerName, String parentProcessGUID, String childProcessGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessParent";
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearProcessParent");
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", "clearProcessParent");
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", "clearProcessParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/parent/{2}/children/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearProcessParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, parentProcessGUID, childProcessGUID, forLineage, forDuplicateProcessing});
    }

    public void publishProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishProcess";
        String processGUIDParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "publishProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/publish?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("publishProcess", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, processGUID, forLineage, forDuplicateProcessing});
    }

    public void withdrawProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawProcess";
        String processGUIDParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "withdrawProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/withdraw?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("withdrawProcess", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, processGUID, forLineage, forDuplicateProcessing});
    }

    public void removeProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String processExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeProcess";
        String processGUIDParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "removeProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removeProcess", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, processExternalIdentifier, effectiveTime, "removeProcess"), new Object[]{this.serverName, userId, processGUID, forLineage, forDuplicateProcessing});
    }

    public List<ProcessElement> findProcesses(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findProcesses";
        this.invalidParameterHandler.validateUserId(userId, "findProcesses");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findProcesses");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ProcessElementsResponse restResult = this.restClient.callMyProcessesPostRESTCall("findProcesses", urlTemplate, this.getSearchStringRequestBody(assetManagerGUID, assetManagerName, searchString, effectiveTime, "findProcesses"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<ProcessElement> getProcessesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessesForAssetManager";
        this.invalidParameterHandler.validateUserId(userId, "getProcessesForAssetManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProcessesForAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/by-asset-manager?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ProcessElementsResponse restResult = this.restClient.callMyProcessesPostRESTCall("getProcessesForAssetManager", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<ProcessElement> getProcessesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessesByName";
        this.invalidParameterHandler.validateUserId(userId, "getProcessesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProcessesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ProcessElementsResponse restResult = this.restClient.callMyProcessesPostRESTCall("getProcessesByName", urlTemplate, this.getNameRequestBody(assetManagerGUID, assetManagerName, name, effectiveTime, "getProcessesByName"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public ProcessElement getProcessByGUID(String userId, String assetManagerGUID, String assetManagerName, String processGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessByGUID";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessByGUID");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getProcessByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        ProcessElementResponse restResult = this.restClient.callMyProcessPostRESTCall("getProcessByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, processGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public ProcessElement getProcessParent(String userId, String assetManagerGUID, String assetManagerName, String processGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessParent";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessParent");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getProcessParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/parent/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        ProcessElementResponse restResult = this.restClient.callMyProcessPostRESTCall("getProcessParent", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, processGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public List<ProcessElement> getSubProcesses(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubProcesses";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSubProcesses");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getSubProcesses");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSubProcesses");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/children?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        ProcessElementsResponse restResult = this.restClient.callMyProcessesPostRESTCall("getSubProcesses", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public String createPort(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String processGUID, ExternalIdentifierProperties externalIdentifierProperties, PortProperties portProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPort";
        String processGUIDParameterName = "processGUID";
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createPort");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "createPort");
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", "createPort");
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", "createPort");
        PortRequestBody requestBody = new PortRequestBody();
        requestBody.setElementProperties(portProperties);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, externalIdentifierProperties, "createPort"));
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}processes/{2}/ports?assetManagerIsHome={3}&forLineage={4}&forDuplicateProcessing={5}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPort", urlTemplate, requestBody, new Object[]{this.serverName, userId, processGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return restResult.getGUID();
    }

    public void updatePort(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String portExternalIdentifier, PortProperties portProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePort";
        String portGUIDParameterName = "portGUID";
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updatePort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "updatePort");
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", "updatePort");
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", "updatePort");
        PortRequestBody requestBody = new PortRequestBody();
        requestBody.setElementProperties(portProperties);
        requestBody.setMetadataCorrelationProperties(this.getCorrelationProperties(assetManagerGUID, assetManagerName, portExternalIdentifier, "updatePort"));
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/update?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updatePort", urlTemplate, requestBody, new Object[]{this.serverName, userId, portGUID, forLineage, forDuplicateProcessing});
    }

    public void setupProcessPort(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String processGUID, String portGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessPort";
        String processGUIDParameterName = "processGUID";
        String portGUIDParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupProcessPort");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "setupProcessPort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "setupProcessPort");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/ports/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("setupProcessPort", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, null), new Object[]{this.serverName, userId, processGUID, portGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearProcessPort(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String portGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessPort";
        String processGUIDParameterName = "processGUID";
        String portGUIDParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearProcessPort");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "clearProcessPort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "clearProcessPort");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/ports/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearProcessPort", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, processGUID, portGUID, forLineage, forDuplicateProcessing});
    }

    public void setupPortDelegation(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portOneGUID, String portTwoGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortDelegation";
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupPortDelegation");
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", "setupPortDelegation");
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", "setupPortDelegation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/port-delegations/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("setupPortDelegation", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, null), new Object[]{this.serverName, userId, portOneGUID, portTwoGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portOneGUID, String portTwoGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortDelegation";
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearPortDelegation");
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", "clearPortDelegation");
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", "clearPortDelegation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/port-delegations/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearPortDelegation", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, portOneGUID, portTwoGUID, forLineage, forDuplicateProcessing});
    }

    public void setupPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portGUID, String schemaTypeGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortSchemaType";
        String portGUIDParameterName = "portGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupPortSchemaType");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "setupPortSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "setupPortSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/schemaType/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.restClient.callVoidPostRESTCall("setupPortSchemaType", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, null), new Object[]{this.serverName, userId, portGUID, schemaTypeGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
    }

    public void clearPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String schemaTypeGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortSchemaType";
        String portGUIDParameterName = "portGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearPortSchemaType");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "clearPortSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "clearPortSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/schemaType/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        this.restClient.callVoidPostRESTCall("clearPortSchemaType", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, portGUID, schemaTypeGUID, forLineage, forDuplicateProcessing});
    }

    public void removePort(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String portExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removePort";
        String portGUIDParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "removePort");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "removePort");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("removePort", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, portExternalIdentifier, effectiveTime, "removePort"), new Object[]{this.serverName, userId, portGUID, forLineage, forDuplicateProcessing});
    }

    public List<PortElement> findPorts(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findPorts";
        this.invalidParameterHandler.validateUserId(userId, "findPorts");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findPorts");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/by-search-string?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        PortElementsResponse restResult = this.restClient.callMyPortsPostRESTCall("findPorts", urlTemplate, this.getSearchStringRequestBody(assetManagerGUID, assetManagerName, searchString, effectiveTime, "findPorts"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<PortElement> getPortsForProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortsForProcess";
        String guidParameterName = "processGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortsForProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getPortsForProcess");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getPortsForProcess");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/processes/{2}/ports/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        PortElementsResponse restResult = this.restClient.callMyPortsPostRESTCall("getPortsForProcess", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, processGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<PortElement> getPortUse(String userId, String assetManagerGUID, String assetManagerName, String portGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortUse";
        String guidParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortUse");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "getPortUse");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getPortUse");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/used-by/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        PortElementsResponse restResult = this.restClient.callMyPortsPostRESTCall("getPortUse", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, portGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public PortElement getPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortDelegation";
        String guidParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortDelegation");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "getPortDelegation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/port-delegations/retrieve?forLineage={3}&forDuplicateProcessing={4}";
        PortElementResponse restResult = this.restClient.callMyPortPostRESTCall("getPortDelegation", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, portGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public List<PortElement> getPortsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortsByName";
        this.invalidParameterHandler.validateUserId(userId, "getPortsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getPortsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/by-name?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        PortElementsResponse restResult = this.restClient.callMyPortsPostRESTCall("getPortsByName", urlTemplate, this.getNameRequestBody(assetManagerGUID, assetManagerName, name, effectiveTime, "getPortsByName"), this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public PortElement getPortByGUID(String userId, String assetManagerGUID, String assetManagerName, String portGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortByGUID";
        String guidParameterName = "portGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPortByGUID");
        this.invalidParameterHandler.validateGUID(portGUID, "portGUID", "getPortByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/ports/{2}/retrieve?forLineage={3}&forDuplicateProcessing={3}";
        PortElementResponse restResult = this.restClient.callMyPortPostRESTCall("getPortByGUID", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, portGUID, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public void setBusinessSignificant(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setBusinessSignificant";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setBusinessSignificant");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "setBusinessSignificant");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/is-business-significant?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("setBusinessSignificant", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, elementExternalIdentifier, effectiveTime, "setBusinessSignificant"), new Object[]{this.serverName, userId, elementGUID, forLineage, forDuplicateProcessing});
    }

    public void clearBusinessSignificant(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearBusinessSignificant";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearBusinessSignificant");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "clearBusinessSignificant");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/is-business-significant/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearBusinessSignificant", urlTemplate, this.getUpdateRequestBody(assetManagerGUID, assetManagerName, elementExternalIdentifier, effectiveTime, "clearBusinessSignificant"), new Object[]{this.serverName, userId, elementGUID, forLineage, forDuplicateProcessing});
    }

    public String setupDataFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, DataFlowProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupDataFlow");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "setupDataFlow");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "setupDataFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-flows/suppliers/{2}/consumers/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupDataFlow", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, dataSupplierGUID, dataConsumerGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return results.getGUID();
    }

    public DataFlowElement getDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlow");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "getDataFlow");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "getDataFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-flows/suppliers/{2}/consumers/{3}/retrieve?forLineage={4}&forDuplicateProcessing={5}";
        DataFlowElementResponse restResult = this.restClient.callDataFlowPostRESTCall("getDataFlow", urlTemplate, this.getQualifiedNameRequestBody(assetManagerGUID, assetManagerName, qualifiedName, effectiveTime), new Object[]{this.serverName, userId, dataSupplierGUID, dataConsumerGUID, forLineage, forDuplicateProcessing});
        return restResult.getElement();
    }

    public void updateDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID, DataFlowProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataFlow";
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateDataFlow");
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", "updateDataFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-flows/{2}/update?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updateDataFlow", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, dataFlowGUID, forLineage, forDuplicateProcessing});
    }

    public void clearDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataFlow";
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearDataFlow");
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", "clearDataFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-flows/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearDataFlow", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, dataFlowGUID, forLineage, forDuplicateProcessing});
    }

    public List<DataFlowElement> getDataFlowConsumers(String userId, String assetManagerGUID, String assetManagerName, String dataSupplierGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlowConsumers";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlowConsumers");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "getDataFlowConsumers");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataFlowConsumers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-flows/suppliers/{2}/consumers/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        DataFlowElementsResponse restResult = this.restClient.callDataFlowsPostRESTCall("getDataFlowConsumers", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, dataSupplierGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return restResult.getElements();
    }

    public List<DataFlowElement> getDataFlowSuppliers(String userId, String assetManagerGUID, String assetManagerName, String dataConsumerGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlowSuppliers";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlowSuppliers");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "getDataFlowSuppliers");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataFlowSuppliers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/data-flows/consumers/{2}/suppliers/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        DataFlowElementsResponse restResult = this.restClient.callDataFlowsPostRESTCall("getDataFlowSuppliers", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, dataConsumerGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return restResult.getElements();
    }

    public String setupControlFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, ControlFlowProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupControlFlow";
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupControlFlow");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "setupControlFlow");
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", "setupControlFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/control-flows/current-steps/{2}/next-steps/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupControlFlow", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, currentStepGUID, nextStepGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return results.getGUID();
    }

    public ControlFlowElement getControlFlow(String userId, String assetManagerGUID, String assetManagerName, String currentStepGUID, String nextStepGUID, String qualifiedName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlow";
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlow");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlow");
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", "getControlFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/control-flows/current-steps/{2}/next-steps/{3}/retrieve?forLineage={4}&forDuplicateProcessing={5}";
        ControlFlowElementResponse restResult = this.restClient.callControlFlowPostRESTCall("getControlFlow", urlTemplate, this.getQualifiedNameRequestBody(assetManagerGUID, assetManagerName, qualifiedName, effectiveTime), new Object[]{this.serverName, userId, currentStepGUID, nextStepGUID, forLineage, forDuplicateProcessing});
        return restResult.getElement();
    }

    public void updateControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID, ControlFlowProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateControlFlow";
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateControlFlow");
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", "updateControlFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/control-flows/{2}/update?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updateControlFlow", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, controlFlowGUID, forLineage, forDuplicateProcessing});
    }

    public void clearControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearControlFlow";
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearControlFlow");
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", "clearControlFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/control-flows/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearControlFlow", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, controlFlowGUID, forLineage, forDuplicateProcessing});
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String userId, String assetManagerGUID, String assetManagerName, String currentStepGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlowNextSteps";
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlowNextSteps");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlowNextSteps");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getControlFlowNextSteps");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/control-flows/current-steps/{2}/next-steps/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        ControlFlowElementsResponse restResult = this.restClient.callControlFlowsPostRESTCall("getControlFlowNextSteps", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, currentStepGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return restResult.getElements();
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String userId, String assetManagerGUID, String assetManagerName, String currentStepGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlowPreviousSteps";
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlowPreviousSteps");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlowPreviousSteps");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getControlFlowPreviousSteps");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/control-flows/current-steps/{2}/previous-steps/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        ControlFlowElementsResponse restResult = this.restClient.callControlFlowsPostRESTCall("getControlFlowPreviousSteps", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, currentStepGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return restResult.getElements();
    }

    public String setupProcessCall(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String callerGUID, String calledGUID, ProcessCallProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessCall";
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupProcessCall");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "setupProcessCall");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "setupProcessCall");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/process-calls/callers/{2}/called/{3}?assetManagerIsHome={4}&forLineage={5}&forDuplicateProcessing={6}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupProcessCall", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, callerGUID, calledGUID, assetManagerIsHome, forLineage, forDuplicateProcessing});
        return results.getGUID();
    }

    public ProcessCallElement getProcessCall(String userId, String assetManagerGUID, String assetManagerName, String callerGUID, String calledGUID, String qualifiedName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCall";
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCall");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "getProcessCall");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "getProcessCall");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/process-calls/callers/{2}/called/{3}/retrieve?forLineage={4}&forDuplicateProcessing={5}";
        ProcessCallElementResponse restResult = this.restClient.callProcessCallPostRESTCall("getProcessCall", urlTemplate, this.getQualifiedNameRequestBody(assetManagerGUID, assetManagerName, qualifiedName, effectiveTime), new Object[]{this.serverName, userId, callerGUID, calledGUID, forLineage, forDuplicateProcessing});
        return restResult.getElement();
    }

    public void updateProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID, ProcessCallProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessCall";
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessCall");
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", "updateProcessCall");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/process-calls/{2}/update?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updateProcessCall", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, processCallGUID, forLineage, forDuplicateProcessing});
    }

    public void clearProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessCall";
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearProcessCall");
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", "clearProcessCall");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/process-calls/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearProcessCall", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, processCallGUID, forLineage, forDuplicateProcessing});
    }

    public List<ProcessCallElement> getProcessCalled(String userId, String assetManagerGUID, String assetManagerName, String callerGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCalled";
        String callerGUIDParameterName = "callerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCalled");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "getProcessCalled");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProcessCalled");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/process-calls/callers/{2}/called/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        ProcessCallElementsResponse restResult = this.restClient.callProcessCallsPostRESTCall("getProcessCalled", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, callerGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return restResult.getElements();
    }

    public List<ProcessCallElement> getProcessCallers(String userId, String assetManagerGUID, String assetManagerName, String calledGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCallers";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCallers");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "getProcessCallers");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getProcessCallers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/process-calls/called/{2}/callers/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        ProcessCallElementsResponse restResult = this.restClient.callProcessCallsPostRESTCall("getProcessCallers", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, calledGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return restResult.getElements();
    }

    public String setupLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, String destinationElementGUID, LineageMappingProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupLineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupLineageMapping");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "setupLineageMapping");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "setupLineageMapping");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/lineage-mappings/sources/{2}/destinations/{3}?forLineage={4}&forDuplicateProcessing={5}";
        GUIDResponse guidResponse = this.restClient.callGUIDPostRESTCall("setupLineageMapping", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, sourceElementGUID, destinationElementGUID, forLineage, forDuplicateProcessing});
        return guidResponse.getGUID();
    }

    public LineageMappingElement getLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, String destinationElementGUID, String qualifiedName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLineageMapping");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "getLineageMapping");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "getLineageMapping");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/lineage-mappings/sources/{2}/destinations/{3}/retrieve?forLineage={4}&forDuplicateProcessing={5}";
        LineageMappingElementResponse restResult = this.restClient.callLineageMappingPostRESTCall("getLineageMapping", urlTemplate, this.getQualifiedNameRequestBody(assetManagerGUID, assetManagerName, qualifiedName, effectiveTime), new Object[]{this.serverName, userId, sourceElementGUID, destinationElementGUID, forLineage, forDuplicateProcessing});
        return restResult.getElement();
    }

    public void updateLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String lineageMappingGUID, LineageMappingProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessCall";
        String processCallGUIDParameterName = "lineageMappingGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessCall");
        this.invalidParameterHandler.validateGUID(lineageMappingGUID, "lineageMappingGUID", "updateProcessCall");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/lineage-mappings/{2}/update?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("updateProcessCall", urlTemplate, this.getRelationshipRequestBody(assetManagerGUID, assetManagerName, effectiveTime, (RelationshipProperties)properties), new Object[]{this.serverName, userId, lineageMappingGUID, forLineage, forDuplicateProcessing});
    }

    public void clearLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String lineageMappingGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLineageMapping";
        String lineageMappingGUIDParameterName = "lineageMappingGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLineageMapping");
        this.invalidParameterHandler.validateGUID(lineageMappingGUID, "lineageMappingGUID", "clearLineageMapping");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/lineage-mappings/{2}/remove?forLineage={3}&forDuplicateProcessing={4}";
        this.restClient.callVoidPostRESTCall("clearLineageMapping", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, lineageMappingGUID, forLineage, forDuplicateProcessing});
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDestinationLineageMappings";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDestinationLineageMappings");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "getDestinationLineageMappings");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDestinationLineageMappings");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/lineage-mappings/sources/{2}/destinations/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        LineageMappingElementsResponse results = this.restClient.callLineageMappingsPostRESTCall("getDestinationLineageMappings", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, sourceElementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return results.getElements();
    }

    public List<LineageMappingElement> getSourceLineageMappings(String userId, String assetManagerGUID, String assetManagerName, String destinationElementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSourceLineageMappings";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSourceLineageMappings");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "getSourceLineageMappings");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSourceLineageMappings");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/lineage-mappings/destinations/{2}/sources/retrieve?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        LineageMappingElementsResponse results = this.restClient.callLineageMappingsPostRESTCall("getSourceLineageMappings", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), new Object[]{this.serverName, userId, destinationElementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing});
        return results.getElements();
    }

    public void addMementoClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearMementoClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void addIncompleteClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void clearIncompleteClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }
}

