/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.ExternalAssetManagerInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.AssetManagerProperties;

public class ExternalAssetManagerClient
extends ExchangeClientBase
implements ExternalAssetManagerInterface {
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers";

    public ExternalAssetManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public ExternalAssetManagerClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public ExternalAssetManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public ExternalAssetManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public ExternalAssetManagerClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public String createExternalAssetManager(String userId, AssetManagerProperties assetManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalAssetManager";
        String propertiesParameterName = "assetManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createExternalAssetManager");
        this.invalidParameterHandler.validateObject((Object)assetManagerProperties, "assetManagerProperties", "createExternalAssetManager");
        this.invalidParameterHandler.validateName(assetManagerProperties.getQualifiedName(), "qualifiedName", "createExternalAssetManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalAssetManager", urlTemplate, assetManagerProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String getExternalAssetManagerGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalAssetManagerGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getExternalAssetManagerGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getExternalAssetManagerGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/asset-managers/by-name/{2}";
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getExternalAssetManagerGUID", urlTemplate, new Object[]{this.serverName, userId, qualifiedName});
        return restResult.getGUID();
    }
}

