/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.StewardshipExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataRelationshipSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindNameProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindPropertyNamesProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetOriginProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.FindAssetOriginProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.OwnerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.RetentionClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SemanticAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityTagsProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class StewardshipExchangeClient
extends ExchangeClientBase
implements StewardshipExchangeInterface {
    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public StewardshipExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public void setConfidenceClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, GovernanceClassificationProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConfidenceClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidence";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setConfidenceClassification");
    }

    public void clearConfidenceClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConfidenceClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidence/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearConfidenceClassification");
    }

    public List<MetadataElementSummary> getConfidenceClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConfidenceClassifiedElements";
        if (returnSpecificLevel) {
            return super.getClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, null, levelIdentifier, OpenMetadataProperty.CONFIDENCE_LEVEL_IDENTIFIER.name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getConfidenceClassifiedElements");
        }
        return super.getClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, null, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getConfidenceClassifiedElements");
    }

    public void setCriticalityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, GovernanceClassificationProperties properties, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setCriticalityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/criticality";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setCriticalityClassification");
    }

    public void clearCriticalityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCriticalityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/criticality/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearCriticalityClassification");
    }

    public List<MetadataElementSummary> getCriticalityClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCriticalityClassifiedElements";
        if (returnSpecificLevel) {
            return super.getClassifiedElements(userId, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, null, levelIdentifier, OpenMetadataProperty.CRITICALITY_LEVEL_IDENTIFIER.name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getCriticalityClassifiedElements");
        }
        return super.getClassifiedElements(userId, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, null, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getCriticalityClassifiedElements");
    }

    public void setConfidentialityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, GovernanceClassificationProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConfidentialityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidentiality";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setConfidentialityClassification");
    }

    public void clearConfidentialityClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConfidentialityClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/confidentiality/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearConfidentialityClassification");
    }

    public List<MetadataElementSummary> getConfidentialityClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConfidentialityClassifiedElements";
        if (returnSpecificLevel) {
            return super.getClassifiedElements(userId, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, null, levelIdentifier, OpenMetadataProperty.CONFIDENTIALITY_LEVEL_IDENTIFIER.name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getConfidentialityClassifiedElements");
        }
        return super.getClassifiedElements(userId, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, null, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getConfidentialityClassifiedElements");
    }

    public void setRetentionClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, RetentionClassificationProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setRetentionClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/retention";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "setRetentionClassification");
    }

    public void clearRetentionClassification(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearRetentionClassification";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/retention/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearRetentionClassification");
    }

    public List<MetadataElementSummary> getRetentionClassifiedElements(String userId, String assetManagerGUID, String assetManagerName, boolean returnSpecificBasisIdentifier, int basisIdentifier, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRetentionClassifiedElements";
        if (returnSpecificBasisIdentifier) {
            return super.getClassifiedElements(userId, OpenMetadataType.RETENTION_CLASSIFICATION.typeName, null, basisIdentifier, OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER.name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getRetentionClassifiedElements");
        }
        return super.getClassifiedElements(userId, OpenMetadataType.RETENTION_CLASSIFICATION.typeName, null, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getRetentionClassifiedElements");
    }

    public void addSecurityTags(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, SecurityTagsProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSecurityTags";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/security-tags";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addSecurityTags");
    }

    public void clearSecurityTags(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSecurityTags";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/security-tags/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearSecurityTags");
    }

    public List<MetadataElementSummary> getSecurityTaggedElements(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSecurityTaggedElements";
        return super.getClassifiedElements(userId, OpenMetadataType.SECURITY_TAGS_CLASSIFICATION.typeName, null, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getSecurityTaggedElements");
    }

    public void addOwnership(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, OwnerProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addOwnership";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/ownership";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addOwnership");
    }

    public void clearOwnership(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearOwnership";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/ownership/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearOwnership");
    }

    public List<MetadataElementSummary> getOwnersElements(String userId, String assetManagerGUID, String assetManagerName, String owner, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getOwnersElements";
        FindNameProperties properties = new FindNameProperties();
        properties.setName(owner);
        return super.getClassifiedElements(userId, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName, null, owner, OpenMetadataProperty.OWNER.name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getOwnersElements");
    }

    public void addAssetOrigin(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String externalIdentifier, AssetOriginProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetOrigin";
        String elementGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/assets/{2}/origin";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, assetGUID, "assetGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addAssetOrigin");
    }

    public void clearAssetOrigin(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetOrigin";
        String elementGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/assets/{2}/origin/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, assetGUID, "assetGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "clearAssetOrigin");
    }

    public List<AssetElement> getAssetsByOrigin(String userId, String assetManagerGUID, String assetManagerName, FindAssetOriginProperties properties, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetsByOrigin";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/assets/by-origin";
        String requestParamsURLTemplate = "?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByOrigin");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAssetsByOrigin");
        FindByPropertiesRequestBody requestBody = new FindByPropertiesRequestBody();
        requestBody.setAssetManagerGUID(assetManagerGUID);
        requestBody.setAssetManagerName(assetManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setProperties((FindProperties)properties);
        AssetElementsResponse restResult = this.restClient.callMyAssetsPostRESTCall("getAssetsByOrigin", urlTemplate + "?startFrom={2}&pageSize={3}&forLineage={4}&forDuplicateProcessing={5}", requestBody, this.serverName, userId, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public void addElementToSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, SubjectAreaClassificationProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addElementToSubjectArea";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/subject-area-member";
        super.setReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, (ClassificationProperties)properties, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "addElementToSubjectArea");
    }

    public void removeElementFromSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String externalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeElementFromSubjectArea";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/subject-area-member/remove";
        super.removeReferenceableClassification(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", externalIdentifier, urlTemplate, effectiveTime, forLineage, forDuplicateProcessing, "removeElementFromSubjectArea");
    }

    public List<MetadataElementSummary> getMembersOfSubjectArea(String userId, String assetManagerGUID, String assetManagerName, String subjectAreaName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMembersOfSubjectArea";
        FindNameProperties properties = new FindNameProperties();
        properties.setName(subjectAreaName);
        return super.getClassifiedElements(userId, OpenMetadataType.SUBJECT_AREA_CLASSIFICATION.typeName, null, subjectAreaName, OpenMetadataProperty.SUBJECT_AREA_NAME.name, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getMembersOfSubjectArea");
    }

    public void setupSemanticAssignment(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String glossaryTermGUID, SemanticAssignmentProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSemanticAssignment";
        String elementGUIDParameterName = "elementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, "relationshipTypeName", glossaryTermGUID, "glossaryTermGUID", properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), effectiveTime, forLineage, forDuplicateProcessing, "setupSemanticAssignment");
    }

    private ElementProperties getElementProperties(SemanticAssignmentProperties relationshipProperties) {
        if (relationshipProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.EXPRESSION.name, relationshipProperties.getExpression());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.CONFIDENCE.name, relationshipProperties.getConfidence());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, relationshipProperties.getDescription());
            if (relationshipProperties.getStatus() != null) {
                elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.STATUS.name, GlossaryTermAssignmentStatus.getOpenTypeName(), relationshipProperties.getStatus().getName());
            }
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD.name, relationshipProperties.getSteward());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, relationshipProperties.getStewardTypeName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, relationshipProperties.getStewardPropertyName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SOURCE.name, relationshipProperties.getSource());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NOTES.name, relationshipProperties.getNotes());
            return elementProperties;
        }
        return null;
    }

    public void clearSemanticAssignment(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String glossaryTermGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSemanticAssignment";
        String elementGUIDParameterName = "elementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, "relationshipTypeName", glossaryTermGUID, "glossaryTermGUID", effectiveTime, forLineage, forDuplicateProcessing, "clearSemanticAssignment");
    }

    public List<GlossaryTermElement> getMeanings(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMeanings";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/glossaries/terms/by-semantic-assignment/{2}?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, "getMeanings");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMeanings");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getMeanings");
        GlossaryTermElementsResponse restResult = this.restClient.callMyGlossaryTermsPostRESTCall("getMeanings", urlTemplate, this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, elementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElementList();
    }

    public List<RelatedMetadataElementSummary> getSemanticAssignees(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSemanticAssignees";
        String elementGUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "getSemanticAssignees");
        return super.getRelatedElements(userId, glossaryTermGUID, 2, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getSemanticAssignees");
    }

    public void addGovernanceDefinitionToElement(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String elementGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addGovernanceDefinitionToElement";
        String elementGUIDParameterName = "elementGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, "relationshipTypeName", definitionGUID, "definitionGUID", null, null, null, effectiveTime, forLineage, forDuplicateProcessing, "addGovernanceDefinitionToElement");
    }

    public void removeGovernanceDefinitionFromElement(String userId, String assetManagerGUID, String assetManagerName, String definitionGUID, String elementGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceDefinitionFromElement";
        String elementGUIDParameterName = "elementGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, "relationshipTypeName", definitionGUID, "definitionGUID", effectiveTime, forLineage, forDuplicateProcessing, "removeGovernanceDefinitionFromElement");
    }

    public void addMoreInformationToElement(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String moreInformationGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addMoreInformationToElement";
        String elementGUIDParameterName = "elementGUID";
        String moreInformationGUIDParameterName = "moreInformationGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        super.setupRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName, "relationshipTypeName", moreInformationGUID, "moreInformationGUID", null, null, null, effectiveTime, forLineage, forDuplicateProcessing, "addMoreInformationToElement");
    }

    public void removeMoreInformationFromElement(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String moreInformationGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeMoreInformationFromElement";
        String elementGUIDParameterName = "elementGUID";
        String moreInformationGUIDParameterName = "moreInformationGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        super.clearRelationship(userId, assetManagerGUID, assetManagerName, elementGUID, "elementGUID", OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName, "relationshipTypeName", moreInformationGUID, "moreInformationGUID", effectiveTime, forLineage, forDuplicateProcessing, "removeMoreInformationFromElement");
    }

    public List<RelatedMetadataElementSummary> getMoreInformationForElements(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<GovernanceDefinitionElement> getGovernedByDefinitions(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernedByDefinitions";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-manager/users/{1}/elements/{2}/governed-by";
        String requestParamsURLTemplate = "?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernedByDefinitions");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getGovernedByDefinitions");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernedByDefinitions");
        GovernanceDefinitionsResponse restResult = this.restClient.callMyGovernanceDefinitionsPostRESTCall("getGovernedByDefinitions", urlTemplate + "?startFrom={3}&pageSize={4}&forLineage={5}&forDuplicateProcessing={6}", this.getEffectiveTimeQueryRequestBody(assetManagerGUID, assetManagerName, effectiveTime), this.serverName, userId, elementGUID, startFrom, validatedPageSize, forLineage, forDuplicateProcessing);
        return restResult.getElements();
    }

    public List<RelatedMetadataElementSummary> getGovernedElements(String userId, String assetManagerGUID, String assetManagerName, String governanceDefinitionGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernedElements";
        String elementGUIDParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "getGovernedElements");
        return super.getRelatedElements(userId, governanceDefinitionGUID, 2, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getGovernedElements");
    }

    public List<RelatedMetadataElementSummary> getSourceElements(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSourceElements";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getSourceElements");
        return super.getRelatedElements(userId, elementGUID, 1, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getSourceElements");
    }

    public List<RelatedMetadataElementSummary> getElementsSourceFrom(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsSourceFrom";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getElementsSourceFrom");
        return super.getRelatedElements(userId, elementGUID, 2, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, "getElementsSourceFrom");
    }

    public MetadataElementSummary getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByGUID";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMetadataElementByGUID");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, null, effectiveTime);
        return (MetadataElementSummary)this.metadataElementSummaryConverter.getNewBean(MetadataElementSummary.class, openMetadataElement, "getMetadataElementByGUID");
    }

    public MetadataElementSummary getMetadataElementByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByUniqueName";
        String elementGUIDParameterName = "uniqueName";
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementByUniqueName");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByUniqueName(userId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, null, effectiveTime);
        return (MetadataElementSummary)this.metadataElementSummaryConverter.getNewBean(MetadataElementSummary.class, openMetadataElement, "getMetadataElementByUniqueName");
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getMetadataElementGUIDByUniqueName(userId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, null, effectiveTime);
    }

    public List<MetadataElementSummary> getElements(String userId, FindProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElements";
        List openMetadataElements = findProperties == null ? this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, null, null, null, null, null, forLineage, forDuplicateProcessing, new Date(), startFrom, pageSize) : this.openMetadataStoreClient.findMetadataElements(userId, findProperties.getOpenMetadataTypeName(), null, null, findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), null, findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        return this.metadataElementSummaryConverter.getNewBeans(MetadataElementSummary.class, openMetadataElements, "getElements");
    }

    public List<MetadataElementSummary> getElementsByPropertyValue(String userId, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsByPropertyValue";
        String findPropertiesProperty = "findProperties";
        String propertyValueProperty = "propertyValue";
        String propertyNamesProperty = "propertyNames";
        this.invalidParameterHandler.validateObject((Object)findProperties, "findProperties", "getElementsByPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyValue(), "propertyValue", "getElementsByPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyNames(), "propertyNames", "getElementsByPropertyValue");
        List openMetadataElements = this.openMetadataStoreClient.getMetadataElementsByPropertyValue(userId, findProperties.getOpenMetadataTypeName(), null, findProperties.getPropertyNames(), findProperties.getPropertyValue(), findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        return this.metadataElementSummaryConverter.getNewBeans(MetadataElementSummary.class, openMetadataElements, "getElementsByPropertyValue");
    }

    public List<MetadataElementSummary> findElementsByPropertyValue(String userId, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findElementsByPropertyValue";
        String findPropertiesProperty = "findProperties";
        String propertyValueProperty = "propertyValue";
        String propertyNamesProperty = "propertyNames";
        this.invalidParameterHandler.validateObject((Object)findProperties, "findProperties", "findElementsByPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyValue(), "propertyValue", "findElementsByPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyNames(), "propertyNames", "findElementsByPropertyValue");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsByPropertyValue(userId, findProperties.getOpenMetadataTypeName(), null, findProperties.getPropertyNames(), findProperties.getPropertyValue(), findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        return this.metadataElementSummaryConverter.getNewBeans(MetadataElementSummary.class, openMetadataElements, "findElementsByPropertyValue");
    }

    public List<MetadataElementSummary> getElementsByClassification(String userId, String classificationName, FindProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsByClassification";
        String classificationNameProperty = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, "getElementsByClassification");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "getElementsByClassification");
        List elements = findProperties == null ? this.openMetadataStoreClient.getMetadataElementsByClassification(userId, null, null, classificationName, null, null, null, SequencingOrder.LAST_UPDATE_RECENT, forLineage, forDuplicateProcessing, new Date(), startFrom, pageSize) : this.openMetadataStoreClient.getMetadataElementsByClassification(userId, findProperties.getOpenMetadataTypeName(), null, classificationName, findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        return this.metadataElementSummaryConverter.getNewBeans(MetadataElementSummary.class, elements, "getElementsByClassification");
    }

    public List<MetadataElementSummary> getElementsByClassificationWithPropertyValue(String userId, String classificationName, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsByClassificationWithPropertyValue";
        String classificationNameProperty = "classificationName";
        String findPropertiesProperty = "findProperties";
        String propertyValueProperty = "propertyValue";
        String propertyNamesProperty = "propertyNames";
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "getElementsByClassificationWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties, "findProperties", "getElementsByClassificationWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyValue(), "propertyValue", "getElementsByClassificationWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyNames(), "propertyNames", "getElementsByClassificationWithPropertyValue");
        List elements = this.openMetadataStoreClient.getMetadataElementsByClassificationPropertyValue(userId, findProperties.getOpenMetadataTypeName(), null, classificationName, findProperties.getPropertyNames(), findProperties.getPropertyValue(), findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        return this.metadataElementSummaryConverter.getNewBeans(MetadataElementSummary.class, elements, "getElementsByClassificationWithPropertyValue");
    }

    public List<MetadataElementSummary> findElementsByClassificationWithPropertyValue(String userId, String classificationName, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findElementsByClassificationWithPropertyValue";
        String classificationNameProperty = "classificationName";
        String findPropertiesProperty = "findProperties";
        String propertyValueProperty = "propertyValue";
        String propertyNamesProperty = "propertyNames";
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "findElementsByClassificationWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties, "findProperties", "findElementsByClassificationWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyValue(), "propertyValue", "findElementsByClassificationWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyNames(), "propertyNames", "findElementsByClassificationWithPropertyValue");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsByClassificationPropertyValue(userId, findProperties.getOpenMetadataTypeName(), null, classificationName, findProperties.getPropertyNames(), findProperties.getPropertyValue(), findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        return this.metadataElementSummaryConverter.getNewBeans(MetadataElementSummary.class, openMetadataElements, "findElementsByClassificationWithPropertyValue");
    }

    public List<RelatedMetadataElementSummary> getRelatedElements(String userId, String elementGUID, String relationshipTypeName, int startingAtEnd, FindProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedElements";
        RelatedMetadataElementList relatedMetadataElements = findProperties == null ? this.openMetadataStoreClient.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, new Date(), startFrom, pageSize) : this.openMetadataStoreClient.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<RelatedMetadataElementSummary> results = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null || findProperties != null && findProperties.getOpenMetadataTypeName() != null && !findProperties.getOpenMetadataTypeName().equals(relatedMetadataElement.getElement().getType().getTypeName())) continue;
                results.add((RelatedMetadataElementSummary)this.relatedMetadataElementSummaryConverter.getNewBean(RelatedMetadataElementSummary.class, relatedMetadataElement, "getRelatedElements"));
            }
            return results;
        }
        return null;
    }

    public List<RelatedMetadataElementSummary> getRelatedElementsWithPropertyValue(String userId, String elementGUID, String relationshipTypeName, int startingAtEnd, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedElementsWithPropertyValue";
        String findPropertiesProperty = "findProperties";
        String propertyValueProperty = "propertyValue";
        String propertyNamesProperty = "propertyNames";
        this.invalidParameterHandler.validateObject((Object)findProperties, "findProperties", "getRelatedElementsWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyValue(), "propertyValue", "getRelatedElementsWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyNames(), "propertyNames", "getRelatedElementsWithPropertyValue");
        RelatedMetadataElementList relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<RelatedMetadataElementSummary> results = new ArrayList<RelatedMetadataElementSummary>();
            block0: for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                ElementProperties relationshipProperties;
                if (relatedMetadataElement == null || findProperties.getOpenMetadataTypeName() != null && !findProperties.getOpenMetadataTypeName().equals(relatedMetadataElement.getElement().getType().getTypeName()) || (relationshipProperties = relatedMetadataElement.getRelationshipProperties()) == null) continue;
                for (String propertyName : findProperties.getPropertyNames()) {
                    PropertyValue propertyValue;
                    if (propertyName == null || (propertyValue = relationshipProperties.getPropertyValue(propertyName)) == null || !findProperties.getPropertyValue().equals(propertyValue.valueAsString())) continue;
                    results.add((RelatedMetadataElementSummary)this.relatedMetadataElementSummaryConverter.getNewBean(RelatedMetadataElementSummary.class, relatedMetadataElement, "getRelatedElementsWithPropertyValue"));
                    continue block0;
                }
            }
            return results;
        }
        return null;
    }

    public List<RelatedMetadataElementSummary> findRelatedElementsWithPropertyValue(String userId, String elementGUID, String relationshipTypeName, int startingAtEnd, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelatedElementsWithPropertyValue";
        String findPropertiesProperty = "findProperties";
        String propertyValueProperty = "propertyValue";
        String propertyNamesProperty = "propertyNames";
        this.invalidParameterHandler.validateObject((Object)findProperties, "findProperties", "findRelatedElementsWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyValue(), "propertyValue", "findRelatedElementsWithPropertyValue");
        this.invalidParameterHandler.validateObject((Object)findProperties.getPropertyNames(), "propertyNames", "findRelatedElementsWithPropertyValue");
        RelatedMetadataElementList relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<RelatedMetadataElementSummary> results = new ArrayList<RelatedMetadataElementSummary>();
            block0: for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                ElementProperties relationshipProperties;
                if (relatedMetadataElement == null || findProperties.getOpenMetadataTypeName() != null && !findProperties.getOpenMetadataTypeName().equals(relatedMetadataElement.getElement().getType().getTypeName()) || (relationshipProperties = relatedMetadataElement.getRelationshipProperties()) == null) continue;
                for (String propertyName : findProperties.getPropertyNames()) {
                    PropertyValue propertyValue;
                    if (propertyName == null || (propertyValue = relationshipProperties.getPropertyValue(propertyName)) == null || !propertyValue.valueAsString().contains(findProperties.getPropertyValue())) continue;
                    results.add((RelatedMetadataElementSummary)this.relatedMetadataElementSummaryConverter.getNewBean(RelatedMetadataElementSummary.class, relatedMetadataElement, "findRelatedElementsWithPropertyValue"));
                    continue block0;
                }
            }
            return results;
        }
        return null;
    }

    public List<MetadataRelationshipSummary> getRelationships(String userId, String relationshipTypeName, FindProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationships";
        OpenMetadataRelationshipList openMetadataRelationships = findProperties == null ? this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, relationshipTypeName, null, null, null, null, SequencingOrder.LAST_UPDATE_RECENT, forLineage, forDuplicateProcessing, new Date(), startFrom, pageSize) : this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, relationshipTypeName, null, findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        if (openMetadataRelationships != null) {
            return this.metadataRelationshipSummaryConverter.getNewBeans(MetadataRelationshipSummary.class, openMetadataRelationships, "getRelationships");
        }
        return null;
    }

    public List<MetadataRelationshipSummary> getRelationshipsWithPropertyValue(String userId, String relationshipTypeName, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationships";
        OpenMetadataRelationshipList openMetadataRelationships = findProperties == null ? this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, relationshipTypeName, null, null, null, null, SequencingOrder.LAST_UPDATE_RECENT, forLineage, forDuplicateProcessing, new Date(), startFrom, pageSize) : this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, relationshipTypeName, this.propertyHelper.getSearchPropertiesByName(findProperties.getPropertyNames(), findProperties.getPropertyValue(), PropertyComparisonOperator.LIKE), findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        if (openMetadataRelationships != null) {
            return this.metadataRelationshipSummaryConverter.getNewBeans(MetadataRelationshipSummary.class, openMetadataRelationships, "getRelationships");
        }
        return null;
    }

    public List<MetadataRelationshipSummary> findRelationshipsWithPropertyValue(String userId, String relationshipTypeName, FindPropertyNamesProperties findProperties, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationships";
        OpenMetadataRelationshipList openMetadataRelationships = findProperties == null ? this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, relationshipTypeName, null, null, null, null, SequencingOrder.LAST_UPDATE_RECENT, forLineage, forDuplicateProcessing, new Date(), startFrom, pageSize) : this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, relationshipTypeName, this.propertyHelper.getSearchPropertiesByName(findProperties.getPropertyNames(), findProperties.getPropertyValue(), PropertyComparisonOperator.LIKE), findProperties.getLimitResultsByStatus(), findProperties.getAsOfTime(), findProperties.getSequencingProperty(), findProperties.getSequencingOrder(), forLineage, forDuplicateProcessing, findProperties.getEffectiveTime(), startFrom, pageSize);
        if (openMetadataRelationships != null) {
            return this.metadataRelationshipSummaryConverter.getNewBeans(MetadataRelationshipSummary.class, openMetadataRelationships, "getRelationships");
        }
        return null;
    }

    public ElementHeader retrieveInstanceForGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        block3: {
            try {
                OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, guid, forLineage, forDuplicateProcessing, null, effectiveTime);
                if (openMetadataElement != null) {
                    ElementHeader elementHeader = new ElementHeader((ElementControlHeader)openMetadataElement);
                    elementHeader.setGUID(openMetadataElement.getElementGUID());
                    elementHeader.setClassifications(this.metadataElementSummaryConverter.getElementClassifications(openMetadataElement.getClassifications()));
                    return elementHeader;
                }
            }
            catch (InvalidParameterException notFound) {
                OpenMetadataRelationship openMetadataRelationship = this.openMetadataStoreClient.getRelationshipByGUID(userId, guid, forLineage, forDuplicateProcessing, null, effectiveTime);
                if (openMetadataRelationship == null) break block3;
                ElementHeader elementHeader = new ElementHeader((ElementControlHeader)openMetadataRelationship);
                elementHeader.setGUID(openMetadataRelationship.getRelationshipGUID());
                return elementHeader;
            }
        }
        return null;
    }
}

