/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.client.exchange;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.ValidValuesExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.converters.ReferenceValueAssignmentDefinitionConverter;
import org.odpi.openmetadata.accessservices.assetmanager.client.converters.ReferenceValueAssignmentItemConverter;
import org.odpi.openmetadata.accessservices.assetmanager.client.converters.ValidValueConverter;
import org.odpi.openmetadata.accessservices.assetmanager.client.converters.ValidValueMemberConverter;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExchangeClientBase;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ReferenceValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ReferenceValueAssignmentItemElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ValidValueMember;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class ValidValuesExchangeClient
extends ExchangeClientBase
implements ValidValuesExchangeInterface {
    private final ValidValueConverter<ValidValueElement> validValueConverter;
    private final Class<ValidValueElement> validValueBeanClass = ValidValueElement.class;
    private final ValidValueMemberConverter<ValidValueMember> validValueMemberConverter;
    private final Class<ValidValueMember> validValueMemberClass = ValidValueMember.class;
    private final ReferenceValueAssignmentItemConverter<ReferenceValueAssignmentItemElement> referenceValueAssignmentItemConverter;
    private final Class<ReferenceValueAssignmentItemElement> referenceValueAssignmentItemBeanClass = ReferenceValueAssignmentItemElement.class;
    private final ReferenceValueAssignmentDefinitionConverter<ReferenceValueAssignmentDefinitionElement> referenceValueAssignmentDefinitionConverter;
    private final Class<ReferenceValueAssignmentDefinitionElement> referenceValueAssignmentDefinitionBeanClass = ReferenceValueAssignmentDefinitionElement.class;

    public ValidValuesExchangeClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
        this.validValueConverter = new ValidValueConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.validValueMemberConverter = new ValidValueMemberConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentItemConverter = new ReferenceValueAssignmentItemConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentDefinitionConverter = new ReferenceValueAssignmentDefinitionConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
    }

    public ValidValuesExchangeClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
        this.validValueConverter = new ValidValueConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.validValueMemberConverter = new ValidValueMemberConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentItemConverter = new ReferenceValueAssignmentItemConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentDefinitionConverter = new ReferenceValueAssignmentDefinitionConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
    }

    public ValidValuesExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
        this.validValueConverter = new ValidValueConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.validValueMemberConverter = new ValidValueMemberConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentItemConverter = new ReferenceValueAssignmentItemConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentDefinitionConverter = new ReferenceValueAssignmentDefinitionConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
    }

    public ValidValuesExchangeClient(String serverName, String serverPlatformURLRoot, AssetManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
        this.validValueConverter = new ValidValueConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.validValueMemberConverter = new ValidValueMemberConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentItemConverter = new ReferenceValueAssignmentItemConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentDefinitionConverter = new ReferenceValueAssignmentDefinitionConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
    }

    public ValidValuesExchangeClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.validValueConverter = new ValidValueConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.validValueMemberConverter = new ValidValueMemberConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentItemConverter = new ReferenceValueAssignmentItemConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
        this.referenceValueAssignmentDefinitionConverter = new ReferenceValueAssignmentDefinitionConverter(this.propertyHelper, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), serverName);
    }

    public String createValidValueSet(String userId, String assetManagerGUID, String assetManagerName, ExternalIdentifierProperties externalIdentifierProperties, ValidValueProperties validValueProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueSet";
        String validValuePropertiesName = "validValueProperties";
        String qualifiedNameParameterName = "validValueProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueSet");
        this.invalidParameterHandler.validateObject((Object)validValueProperties, "validValueProperties", "createValidValueSet");
        this.invalidParameterHandler.validateName(validValueProperties.getQualifiedName(), "validValueProperties.qualifiedName", "createValidValueSet");
        String validValueTypeName = OpenMetadataType.VALID_VALUE_SET.typeName;
        if (validValueProperties.getTypeName() != null) {
            validValueTypeName = validValueProperties.getTypeName();
        }
        String validValueGUID = this.openMetadataStoreClient.createMetadataElementInStore(userId, validValueTypeName, ElementStatus.ACTIVE, validValueProperties.getEffectiveFrom(), validValueProperties.getEffectiveTo(), this.getElementProperties(validValueProperties));
        super.addExternalIdentifier(userId, assetManagerGUID, assetManagerName, validValueGUID, validValueTypeName, externalIdentifierProperties);
        return validValueGUID;
    }

    public String createValidValueDefinition(String userId, String assetManagerGUID, String assetManagerName, String setGUID, ExternalIdentifierProperties externalIdentifierProperties, ValidValueProperties validValueProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueDefinition";
        String validValuePropertiesName = "validValueProperties";
        String qualifiedNameParameterName = "validValueProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueDefinition");
        this.invalidParameterHandler.validateObject((Object)validValueProperties, "validValueProperties", "createValidValueDefinition");
        this.invalidParameterHandler.validateName(validValueProperties.getQualifiedName(), "validValueProperties.qualifiedName", "createValidValueDefinition");
        String validValueTypeName = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        if (validValueProperties.getTypeName() != null) {
            validValueTypeName = validValueProperties.getTypeName();
        }
        String validValueGUID = this.openMetadataStoreClient.createMetadataElementInStore(userId, validValueTypeName, ElementStatus.ACTIVE, null, null, true, null, validValueProperties.getEffectiveFrom(), validValueProperties.getEffectiveTo(), this.getElementProperties(validValueProperties), setGUID, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, null, true, forLineage, forDuplicateProcessing, effectiveTime);
        super.addExternalIdentifier(userId, assetManagerGUID, assetManagerName, validValueGUID, validValueTypeName, externalIdentifierProperties);
        return validValueGUID;
    }

    public void updateValidValue(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, String validValueExternalIdentifier, boolean isMergeUpdate, ValidValueProperties validValueProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateValidValue";
        String validValuePropertiesName = "validValueProperties";
        String qualifiedNameParameterName = "validValueProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateValidValue");
        this.invalidParameterHandler.validateObject((Object)validValueProperties, "validValueProperties", "updateValidValue");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(validValueProperties.getQualifiedName(), "validValueProperties.qualifiedName", "updateValidValue");
        }
        this.openMetadataStoreClient.validateExternalIdentifier(userId, assetManagerGUID, assetManagerName, validValueGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueExternalIdentifier, forLineage, forDuplicateProcessing, effectiveTime);
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, assetManagerGUID, assetManagerName, validValueGUID, !isMergeUpdate, forLineage, forDuplicateProcessing, this.getElementProperties(validValueProperties), new Date());
    }

    public void removeValidValue(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, String validValueExternalIdentifier, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeValidValue";
        String validValueGUIDParameterName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "removeValidValue");
        this.openMetadataStoreClient.validateExternalIdentifier(userId, assetManagerGUID, assetManagerName, validValueGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueExternalIdentifier, forLineage, forDuplicateProcessing, effectiveTime);
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, assetManagerGUID, assetManagerName, validValueGUID, false, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void attachValidValueToSet(String userId, String assetManagerGUID, String assetManagerName, String setGUID, String validValueGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.attachValidValueToSet(userId, assetManagerGUID, assetManagerName, setGUID, validValueGUID, null, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void attachValidValueToSet(String userId, String assetManagerGUID, String assetManagerName, String setGUID, String validValueGUID, ValidValueMembershipProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachValidValueToSet";
        String validValueGUIDParameterName = "validValueGUID";
        String parentGUIDParameterName = "setGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "attachValidValueToSet");
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_DEFAULT_VALUE.name, properties.getDefaultValue());
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, setGUID, validValueGUID, forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), elementProperties, effectiveTime);
        } else {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, setGUID, validValueGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
        }
    }

    public void detachValidValueFromSet(String userId, String assetManagerGUID, String assetManagerName, String setGUID, String validValueGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachValidValue";
        String validValueGUIDParameterName = "validValueGUID";
        String parentGUIDParameterName = "setGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "detachValidValue");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "detachValidValue");
        this.openMetadataStoreClient.deleteRelationshipInStore(userId, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, setGUID, validValueGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void assignReferenceValueToItem(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, String referenceableGUID, ReferenceValueAssignmentProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "assignReferenceValueToItem";
        String validValueGUIDParameterName = "validValueGUID";
        String itemGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "assignReferenceValueToItem");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "assignReferenceValueToItem");
        this.invalidParameterHandler.validateGUID(referenceableGUID, "parentGUID", "assignReferenceValueToItem");
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ATTRIBUTE_NAME.name, properties.getAttributeName());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.CONFIDENCE.name, properties.getConfidence());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD.name, properties.getSteward());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, properties.getStewardTypeName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, properties.getStewardPropertyName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NOTES.name, properties.getNotes());
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, referenceableGUID, validValueGUID, forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), elementProperties, effectiveTime);
        } else {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, referenceableGUID, validValueGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
        }
    }

    public void unassignReferenceValueFromItem(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, String referenceableGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachValidValue";
        String validValueGUIDParameterName = "validValueGUID";
        String itemGUIDParameterName = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "detachValidValue");
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", "detachValidValue");
        this.openMetadataStoreClient.deleteRelationshipInStore(userId, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, referenceableGUID, validValueGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public ValidValueElement getValidValueByGUID(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByGUID";
        String guidParameterName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByGUID");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValueByGUID");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, validValueGUID, forLineage, forDuplicateProcessing, null, effectiveTime);
        return this.convertValidValue(userId, assetManagerGUID, assetManagerName, openMetadataElement, "getValidValueByGUID");
    }

    public List<ValidValueElement> getValidValueByName(String userId, String assetManagerGUID, String assetManagerName, String validValueName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValuesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getValidValuesByName");
        this.invalidParameterHandler.validateName(validValueName, "name", "getValidValuesByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValuesByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.NAME.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.COLLECTION.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, validValueName, PropertyComparisonOperator.EQ), null, null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertValidValues(userId, assetManagerGUID, assetManagerName, openMetadataElements, "getValidValuesByName");
    }

    public List<ValidValueElement> findValidValues(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findValidValues";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findValidValues");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findValidValues");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findValidValues");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertValidValues(userId, assetManagerGUID, assetManagerName, openMetadataElements, "findValidValues");
    }

    public List<ValidValueMember> getValidValueSetMembers(String userId, String assetManagerGUID, String assetManagerName, String validValueSetGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueSetMembers";
        String validValueGUIDParameterName = "validValueSetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueSetMembers");
        this.invalidParameterHandler.validateGUID(validValueSetGUID, "validValueSetGUID", "getValidValueSetMembers");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueSetMembers");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, validValueSetGUID, 1, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<ValidValueMember> validValueMembers = new ArrayList<ValidValueMember>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.VALID_VALUE_DEFINITION.typeName)) continue;
                ValidValueMember validValueMember = this.validValueMemberConverter.getNewBean(this.validValueMemberClass, relatedMetadataElement, "getValidValueSetMembers");
                if (validValueMember != null && validValueMember.getValidValueElement() != null) {
                    validValueMember.getValidValueElement().setCorrelationHeaders(this.getMetadataCorrelationHeaders(userId, assetManagerGUID, assetManagerName, validValueMember.getValidValueElement().getElementHeader().getGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName));
                }
                validValueMembers.add(validValueMember);
            }
            if (!validValueMembers.isEmpty()) {
                return validValueMembers;
            }
        }
        return null;
    }

    public List<ValidValueElement> getSetsForValidValue(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForValidValue";
        String validValueGUIDParameterName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getSetsForValidValue");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSetsForValidValue");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, validValueGUID, 2, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<ValidValueElement> validValueSets = new ArrayList<ValidValueElement>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.VALID_VALUE_SET.typeName)) continue;
                validValueSets.add(this.convertValidValue(userId, assetManagerGUID, assetManagerName, relatedMetadataElement.getElement(), "getSetsForValidValue"));
            }
            if (!validValueSets.isEmpty()) {
                return validValueSets;
            }
        }
        return null;
    }

    public List<ReferenceValueAssignmentItemElement> getReferenceValueAssignedItems(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReferenceValueAssignedItems";
        String validValueGUIDParameterName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getReferenceValueAssignedItems");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getReferenceValueAssignedItems");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getReferenceValueAssignedItems");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, validValueGUID, 2, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<ReferenceValueAssignmentItemElement> results = new ArrayList<ReferenceValueAssignmentItemElement>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                ReferenceValueAssignmentItemElement bean;
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.REFERENCEABLE.typeName) || (bean = this.referenceValueAssignmentItemConverter.getNewBean(this.referenceValueAssignmentItemBeanClass, relatedMetadataElement, "getReferenceValueAssignedItems")) == null || bean.getAssignedItem() == null) continue;
                bean.getAssignedItem().setCorrelationHeaders(this.getMetadataCorrelationHeaders(userId, assetManagerGUID, assetManagerName, bean.getAssignedItem().getElementHeader().getGUID(), OpenMetadataType.REFERENCEABLE.typeName));
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<ReferenceValueAssignmentDefinitionElement> getReferenceValueAssignments(String userId, String assetManagerGUID, String assetManagerName, String referenceableGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReferenceValueAssignments";
        String itemGUIDParameterName = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, "getReferenceValueAssignments");
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", "getReferenceValueAssignments");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getReferenceValueAssignments");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, referenceableGUID, 1, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<ReferenceValueAssignmentDefinitionElement> results = new ArrayList<ReferenceValueAssignmentDefinitionElement>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                ReferenceValueAssignmentDefinitionElement bean;
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.VALID_VALUE_DEFINITION.typeName) || (bean = this.referenceValueAssignmentDefinitionConverter.getNewBean(this.referenceValueAssignmentDefinitionBeanClass, relatedMetadataElement, "getReferenceValueAssignments")) == null || bean.getValidValueElement() == null) continue;
                bean.getValidValueElement().setCorrelationHeaders(this.getMetadataCorrelationHeaders(userId, assetManagerGUID, assetManagerName, bean.getValidValueElement().getElementHeader().getGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName));
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private ElementProperties getElementProperties(ValidValueProperties validValueProperties) {
        if (validValueProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, validValueProperties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, validValueProperties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, validValueProperties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.USAGE.name, validValueProperties.getUsage());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.CATEGORY.name, validValueProperties.getUsage());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PREFERRED_VALUE.name, validValueProperties.getPreferredValue());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DATA_TYPE.name, validValueProperties.getDataType());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SCOPE.name, validValueProperties.getScope());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_DEPRECATED.name, validValueProperties.getIsDeprecated());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_CASE_SENSITIVE.name, validValueProperties.getIsCaseSensitive());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, validValueProperties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, validValueProperties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ValidValueElement convertValidValue(String userId, String assetManagerGUID, String assetManagerName, OpenMetadataElement openMetadataElement, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ValidValueElement bean;
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.VALID_VALUE_DEFINITION.typeName) && (bean = this.validValueConverter.getNewBean(this.validValueBeanClass, openMetadataElement, methodName)) != null) {
            bean.setCorrelationHeaders(this.getMetadataCorrelationHeaders(userId, assetManagerGUID, assetManagerName, openMetadataElement.getElementGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName));
            return bean;
        }
        return null;
    }

    private List<ValidValueElement> convertValidValues(String userId, String assetManagerGUID, String assetManagerName, List<OpenMetadataElement> openMetadataElements, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<ValidValueElement> validValueElements = new ArrayList<ValidValueElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                ValidValueElement validValueElement;
                if (openMetadataElement == null || (validValueElement = this.validValueConverter.getNewBean(this.validValueBeanClass, openMetadataElement, methodName)) == null) continue;
                validValueElement.setCorrelationHeaders(this.getMetadataCorrelationHeaders(userId, assetManagerGUID, assetManagerName, openMetadataElement.getElementGUID(), OpenMetadataType.VALID_VALUE_DEFINITION.typeName));
                validValueElements.add(validValueElement);
            }
            return validValueElements;
        }
        return null;
    }
}

