/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.common.AssetManagerTestBase;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest
extends AssetManagerTestBase {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String callerId = "TestCallerId";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        thisTest.testAssetManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testAssetManagerEventClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testAssetManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new AssetManagerClient(serverName, serverPlatformRootURL, auditLog);
        new AssetManagerClient(serverName, serverPlatformRootURL);
        new AssetManagerClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new AssetManagerClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
        new AssetManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testGlossaryExchangeClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog);
        new GlossaryExchangeClient(serverName, serverPlatformRootURL);
        new GlossaryExchangeClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new GlossaryExchangeClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
        new GlossaryExchangeClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testAssetManagerEventClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new AssetManagerEventClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog, callerId);
    }
}

