/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.glossaries;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.common.AssetManagerTestBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateGlossaryTest
extends AssetManagerTestBase {
    private static final String testCaseName = "CreateGlossaryTest";
    private static final int maxPageSize = 100;
    private static final String assetManagerName = "TestGlossaryAssetManager";
    private static final String externalGlossaryIdentifier = "TestExternalIdentifier";
    private static final String externalGlossaryIdentifierName = "TestExternalIdentifierName";
    private static final String externalGlossaryIdentifierUsage = "TestExternalIdentifierUsage";
    private static final KeyPattern externalGlossaryIdentifierKeyPattern = KeyPattern.CALLERS_KEY;
    private static final String externalGlossaryIdentifierSource = "TestExternalIdentifierSource";
    private static final String externalCategoryIdentifier = "TestExternalIdentifier";
    private static final String externalCategoryIdentifierName = "TestExternalIdentifierName";
    private static final String externalCategoryIdentifierUsage = "TestExternalIdentifierUsage";
    private static final KeyPattern externalCategoryIdentifierKeyPattern = KeyPattern.RECYCLED_KEY;
    private static final String externalCategoryIdentifierSource = "TestExternalIdentifierSource";
    private static final String externalTermIdentifier = "TestExternalTermIdentifier";
    private static final String externalTermIdentifierName = "TestExternalTermIdentifierName";
    private static final String externalTermIdentifierUsage = "TestExternalTermIdentifierUsage";
    private static final KeyPattern externalTermIdentifierKeyPattern = null;
    private static final String externalTermIdentifierSource = "TestExternalTermIdentifierSource";
    private static final String glossaryName = "TestGlossary";
    private static final String glossaryDisplayName = "Glossary displayName";
    private static final String glossaryDescription = "Glossary description";
    private static final String glossaryUsage = "Glossary usage";
    private static final String glossaryLanguage = "Glossary language";
    private static final String glossaryCategoryName = "TestGlossaryCategory";
    private static final String glossaryCategoryDisplayName = "GlossaryCategory displayName";
    private static final String glossaryCategoryDescription = "GlossaryCategory description";
    private static final String glossaryTermName = "TestGlossaryTerm";
    private static final String glossaryTermDisplayName = "GlossaryTerm displayName";
    private static final String glossaryTermDescription = "GlossaryTerm description";
    private static final String glossaryTermType = "GlossaryTerm type";
    private static final String glossaryTermVersion = "GlossaryTerm version";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateGlossaryTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateGlossaryTest thisTest = new CreateGlossaryTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        String assetManagerGUID = thisTest.getAssetManager(assetManagerName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName);
        GlossaryExchangeClient client = thisTest.getGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String activityName = "getGlossary(TestGlossary)";
        String glossaryGUID = thisTest.getGlossary(client, testCaseName, activityName, userId, assetManagerGUID, assetManagerName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage, "TestExternalIdentifier", "TestExternalIdentifierName", "TestExternalIdentifierUsage", "TestExternalIdentifierSource", externalGlossaryIdentifierKeyPattern, null);
        try {
            client.removeGlossary(userId, assetManagerGUID, assetManagerName, glossaryGUID, "TestExternalIdentifier");
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, unexpectedError);
        }
        try {
            client.getGlossaryByGUID(userId, assetManagerGUID, assetManagerName, glossaryGUID);
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
        }
        catch (InvalidParameterException unexpectedError) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, unexpectedError);
        }
    }

    private String getGlossaryCategory(GlossaryExchangeClient client, String assetManagerGUID, String glossaryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getGlossaryCategory";
        try {
            GlossaryCategoryProperties properties = new GlossaryCategoryProperties();
            properties.setQualifiedName(glossaryCategoryName);
            properties.setDisplayName(glossaryCategoryDisplayName);
            properties.setDescription(glossaryCategoryDescription);
            String glossaryCategoryGUID = client.createGlossaryCategory(userId, assetManagerGUID, assetManagerName, glossaryGUID, "TestExternalIdentifier", "TestExternalIdentifierName", "TestExternalIdentifierUsage", "TestExternalIdentifierSource", externalCategoryIdentifierKeyPattern, null, properties);
            if (glossaryCategoryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GUID for schemaCreate)");
            }
            GlossaryCategoryElement retrievedElement = client.getGlossaryCategoryByGUID(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID);
            GlossaryCategoryProperties retrievedSchema = retrievedElement.getGlossaryCategoryProperties();
            if (retrievedSchema == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GlossaryCategory from Retrieve)");
            }
            if (!glossaryCategoryName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad qualifiedName from Retrieve)");
            }
            if (!glossaryCategoryDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad displayName from Retrieve)");
            }
            if (!glossaryCategoryDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad description from Retrieve)");
            }
            List glossaryCategoryList = client.getGlossaryCategoriesByName(userId, assetManagerGUID, assetManagerName, glossaryCategoryName, 0, 100);
            if (glossaryCategoryList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GlossaryCategory for RetrieveByName)");
            }
            if (glossaryCategoryList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Empty GlossaryCategory list for RetrieveByName)");
            }
            if (glossaryCategoryList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(GlossaryCategory list for RetrieveByName contains" + glossaryCategoryList.size() + " elements)");
            }
            retrievedElement = (GlossaryCategoryElement)glossaryCategoryList.get(0);
            retrievedSchema = retrievedElement.getGlossaryCategoryProperties();
            if (!glossaryCategoryName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad qualifiedName from RetrieveByName)");
            }
            if (!glossaryCategoryDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad displayName from RetrieveByName)");
            }
            if (!glossaryCategoryDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad description from RetrieveByName)");
            }
            return glossaryCategoryGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory", unexpectedError);
        }
    }

    private String getGlossaryTerm(GlossaryExchangeClient client, String assetManagerGUID, String glossaryCategoryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getGlossaryTerm";
        try {
            GlossaryTermProperties properties = new GlossaryTermProperties();
            properties.setQualifiedName(glossaryTermName);
            properties.setDisplayName(glossaryTermDisplayName);
            properties.setDescription(glossaryTermDescription);
            HashMap<String, String> mappingProperties = new HashMap<String, String>();
            mappingProperties.put("prop1", "One");
            mappingProperties.put("prop2", "Two");
            String glossaryTermGUID = client.createGlossaryTerm(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, externalTermIdentifier, externalTermIdentifierName, externalTermIdentifierUsage, externalTermIdentifierSource, externalTermIdentifierKeyPattern, mappingProperties, properties);
            if (glossaryTermGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(no GUID for tableCreate)");
            }
            GlossaryTermElement retrievedElement = client.getGlossaryTermByGUID(userId, assetManagerGUID, assetManagerName, glossaryTermGUID);
            GlossaryTermProperties retrievedTable = retrievedElement.getGlossaryTermProperties();
            if (retrievedTable == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(no GlossaryTerm from Retrieve)");
            }
            if (!glossaryTermName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(Bad qualifiedName from Retrieve)");
            }
            if (!glossaryTermDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(Bad displayName from Retrieve)");
            }
            if (!glossaryTermDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(Bad description from Retrieve)");
            }
            List glossaryTermList = client.getGlossaryTermsByName(userId, assetManagerGUID, assetManagerName, glossaryTermName, 0, 100);
            if (glossaryTermList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(no GlossaryTerm for RetrieveByName)");
            }
            if (glossaryTermList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(Empty GlossaryTerm list for RetrieveByName)");
            }
            if (glossaryTermList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(GlossaryTerm list for RetrieveByName contains" + glossaryTermList.size() + " elements)");
            }
            retrievedElement = (GlossaryTermElement)glossaryTermList.get(0);
            retrievedTable = retrievedElement.getGlossaryTermProperties();
            if (!glossaryTermName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(Bad qualifiedName from RetrieveByName)");
            }
            if (!glossaryTermDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(Bad displayName from RetrieveByName)");
            }
            if (!glossaryTermDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(Bad description from RetrieveByName)");
            }
            return glossaryTermGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm", unexpectedError);
        }
    }
}

