/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.externalidentifiers;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.common.AssetManagerTestBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class ManageExternalIdsTest
extends AssetManagerTestBase {
    private static final String testCaseName = "ManageExternalIdsTest";
    private static final String glossaryName = "TestGlossary";
    private static final String glossaryDisplayName = "Glossary displayName";
    private static final String glossaryDescription = "Glossary description";
    private static final String glossaryUsage = "Glossary usage";
    private static final String glossaryLanguage = "Glossary Language";
    private static final String glossaryTwoName = "TestGlossary Two";
    private static final String glossaryTwoDisplayName = "Glossary Two displayName";
    private static final String glossaryTwoDescription = "Glossary Two description";
    private static final String glossaryTwoUsage = "Glossary Two usage";
    private static final String glossaryTwoLanguage = "Glossary Two language";
    private static final String externalGlossaryIdentifierOne = "TestExternalIdentifierOne";
    private static final String externalGlossaryIdentifierOneName = "TestExternalIdentifierOneName";
    private static final String externalGlossaryIdentifierOneUsage = "TestExternalIdentifierOneUsage";
    private static final String externalGlossaryIdentifierOneSource = "TestExternalIdentifierOneSource";
    private static final KeyPattern externalGlossaryIdentifierOneKeyPattern = KeyPattern.AGGREGATE_KEY;
    private static final String externalGlossaryIdentifierTwo = "TestExternalIdentifierTwo";
    private static final String externalGlossaryIdentifierTwoName = "TestExternalIdentifierTwoName";
    private static final String externalGlossaryIdentifierTwoUsage = "TestExternalIdentifierTwoUsage";
    private static final String externalGlossaryIdentifierTwoSource = "TestExternalIdentifierTwoSource";
    private static final KeyPattern externalGlossaryIdentifierTwoKeyPattern = KeyPattern.MIRROR_KEY;
    private static final String assetManagerOneName = "Asset Manager One";
    private static final String assetManagerTwoName = "Asset Manager";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ManageExternalIdsTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        ManageExternalIdsTest thisTest = new ManageExternalIdsTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        thisTest.testOneToOne(serverPlatformRootURL, serverName, userId, auditLog);
        thisTest.testMultipleAssetManagers(serverPlatformRootURL, serverName, userId, auditLog);
        thisTest.testMultipleAssetManagersSameExtID(serverPlatformRootURL, serverName, userId, auditLog);
    }

    private void testOneToOne(String serverPlatformRootURL, String serverName, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testOneToOne(TestGlossary)";
        GlossaryExchangeClient client = this.getGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String assetManagerGUID = this.getAssetManager(assetManagerOneName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName);
        try {
            String glossaryGUID = this.getGlossary(client, testCaseName, activityName, userId, assetManagerGUID, assetManagerOneName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage, externalGlossaryIdentifierOne, externalGlossaryIdentifierOneName, externalGlossaryIdentifierOneUsage, externalGlossaryIdentifierOneSource, externalGlossaryIdentifierOneKeyPattern, null);
            if (glossaryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary)");
            }
            GlossaryElement retrievedElement = client.getGlossaryByGUID(userId, assetManagerGUID, assetManagerOneName, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            List metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve)");
            }
            MetadataCorrelationHeader correlationHeader = (MetadataCorrelationHeader)metadataCorrelationHeaders.get(0);
            if (correlationHeader == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties in pos 0 from Retrieve)");
            }
            if (!externalGlossaryIdentifierOne.equals(correlationHeader.getExternalIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier)");
            }
            if (!externalGlossaryIdentifierOneName.equals(correlationHeader.getExternalIdentifierName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier name)");
            }
            if (!externalGlossaryIdentifierOneUsage.equals(correlationHeader.getExternalIdentifierUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier usage)");
            }
            if (!externalGlossaryIdentifierOneSource.equals(correlationHeader.getExternalIdentifierSource())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier source)");
            }
            if (correlationHeader.getLastSynchronized() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(null last sync date)");
            }
            if (!assetManagerGUID.equals(correlationHeader.getAssetManagerGUID())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad assetManagerGUID)");
            }
            if (!assetManagerOneName.equals(correlationHeader.getAssetManagerName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad assetManagerName)");
            }
            client.removeGlossary(userId, assetManagerGUID, assetManagerOneName, glossaryGUID, externalGlossaryIdentifierOne);
            try {
                client.getGlossaryByGUID(userId, assetManagerGUID, assetManagerOneName, glossaryGUID);
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
            }
            catch (InvalidParameterException invalidParameterException) {
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, unexpectedError);
        }
    }

    private void testMultipleAssetManagers(String serverPlatformRootURL, String serverName, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String assetManagerTwoGUID;
        String activityName = "testMultipleAssetManagers(Asset Manager One, Asset Manager)";
        GlossaryExchangeClient glossaryExchangeClient = this.getGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        AssetManagerClient assetManagerClient = this.getAssetManagerClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String assetManagerOneGUID = this.getAssetManager(assetManagerOneName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName);
        if (assetManagerOneGUID.equals(assetManagerTwoGUID = this.getAssetManager(assetManagerTwoName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName))) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary)");
        }
        try {
            String glossaryGUID = this.getGlossary(glossaryExchangeClient, testCaseName, activityName, userId, assetManagerOneGUID, assetManagerOneName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage, externalGlossaryIdentifierOne, externalGlossaryIdentifierOneName, externalGlossaryIdentifierOneUsage, externalGlossaryIdentifierOneSource, externalGlossaryIdentifierOneKeyPattern, null);
            if (glossaryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary)");
            }
            assetManagerClient.addExternalIdentifier(userId, assetManagerTwoGUID, assetManagerTwoName, SynchronizationDirection.BOTH_DIRECTIONS, null, glossaryGUID, "Glossary", externalGlossaryIdentifierTwo, externalGlossaryIdentifierTwoName, externalGlossaryIdentifierTwoUsage, externalGlossaryIdentifierTwoSource, externalGlossaryIdentifierTwoKeyPattern, null);
            GlossaryElement retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerTwoGUID, assetManagerTwoName, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve of Two)");
            }
            List metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve of Two)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve of Two)");
            }
            if (metadataCorrelationHeaders.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve of Two)");
            }
            MetadataCorrelationHeader correlationHeader = (MetadataCorrelationHeader)metadataCorrelationHeaders.get(0);
            if (correlationHeader == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties in pos 0 from Retrieve of Two)");
            }
            if (!externalGlossaryIdentifierTwo.equals(correlationHeader.getExternalIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier) of Two");
            }
            if (!externalGlossaryIdentifierTwoName.equals(correlationHeader.getExternalIdentifierName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier name of Two)");
            }
            if (!externalGlossaryIdentifierTwoUsage.equals(correlationHeader.getExternalIdentifierUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier usage of Two)");
            }
            if (!externalGlossaryIdentifierTwoSource.equals(correlationHeader.getExternalIdentifierSource())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier source of Two)");
            }
            if (correlationHeader.getLastSynchronized() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(null last sync date of Two)");
            }
            retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve)");
            }
            correlationHeader = (MetadataCorrelationHeader)metadataCorrelationHeaders.get(0);
            if (correlationHeader == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties in pos 0 from Retrieve)");
            }
            if (!externalGlossaryIdentifierOne.equals(correlationHeader.getExternalIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier)");
            }
            if (!externalGlossaryIdentifierOneName.equals(correlationHeader.getExternalIdentifierName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier name)");
            }
            if (!externalGlossaryIdentifierOneUsage.equals(correlationHeader.getExternalIdentifierUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier usage)");
            }
            if (!externalGlossaryIdentifierOneSource.equals(correlationHeader.getExternalIdentifierSource())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier source)");
            }
            if (correlationHeader.getLastSynchronized() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(null last sync date)");
            }
            retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, null, null, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.size() != 2) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve) " + metadataCorrelationHeaders.toString());
            }
            glossaryExchangeClient.removeGlossary(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID, externalGlossaryIdentifierOne);
            try {
                glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID);
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
            }
            catch (InvalidParameterException invalidParameterException) {
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, unexpectedError);
        }
    }

    private void testMultipleAssetManagersSameExtID(String serverPlatformRootURL, String serverName, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String assetManagerTwoGUID;
        String activityName = "testMultipleAssetManagersSameExtId(Asset Manager One, Asset Manager)";
        GlossaryExchangeClient glossaryExchangeClient = this.getGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        AssetManagerClient assetManagerClient = this.getAssetManagerClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String assetManagerOneGUID = this.getAssetManager(assetManagerOneName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName);
        if (assetManagerOneGUID.equals(assetManagerTwoGUID = this.getAssetManager(assetManagerTwoName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName))) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary)");
        }
        try {
            String glossaryGUID = this.getGlossary(glossaryExchangeClient, testCaseName, activityName, userId, assetManagerOneGUID, assetManagerOneName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage, externalGlossaryIdentifierOne, externalGlossaryIdentifierOneName, externalGlossaryIdentifierOneUsage, externalGlossaryIdentifierOneSource, externalGlossaryIdentifierOneKeyPattern, null);
            if (glossaryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary)");
            }
            assetManagerClient.addExternalIdentifier(userId, assetManagerTwoGUID, assetManagerTwoName, SynchronizationDirection.BOTH_DIRECTIONS, null, glossaryGUID, "Glossary", externalGlossaryIdentifierOne, externalGlossaryIdentifierOneName, externalGlossaryIdentifierOneUsage, externalGlossaryIdentifierOneSource, externalGlossaryIdentifierOneKeyPattern, null);
            GlossaryElement retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerTwoGUID, assetManagerTwoName, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve of Two)");
            }
            List metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve of Two)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve of Two)");
            }
            if (metadataCorrelationHeaders.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve of Two)");
            }
            MetadataCorrelationHeader correlationHeader = (MetadataCorrelationHeader)metadataCorrelationHeaders.get(0);
            if (correlationHeader == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties in pos 0 from Retrieve of Two)");
            }
            if (!externalGlossaryIdentifierOne.equals(correlationHeader.getExternalIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier) of Two");
            }
            if (!externalGlossaryIdentifierOneName.equals(correlationHeader.getExternalIdentifierName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier name of Two)");
            }
            if (!externalGlossaryIdentifierOneUsage.equals(correlationHeader.getExternalIdentifierUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier usage of Two)");
            }
            if (!externalGlossaryIdentifierOneSource.equals(correlationHeader.getExternalIdentifierSource())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier source of Two)");
            }
            if (correlationHeader.getLastSynchronized() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(null last sync date of Two)");
            }
            retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve)");
            }
            correlationHeader = (MetadataCorrelationHeader)metadataCorrelationHeaders.get(0);
            if (correlationHeader == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties in pos 0 from Retrieve)");
            }
            if (!externalGlossaryIdentifierOne.equals(correlationHeader.getExternalIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier)");
            }
            if (!externalGlossaryIdentifierOneName.equals(correlationHeader.getExternalIdentifierName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier name)");
            }
            if (!externalGlossaryIdentifierOneUsage.equals(correlationHeader.getExternalIdentifierUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier usage)");
            }
            if (!externalGlossaryIdentifierOneSource.equals(correlationHeader.getExternalIdentifierSource())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier source)");
            }
            if (correlationHeader.getLastSynchronized() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(null last sync date)");
            }
            retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, null, null, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.size() != 2) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve)");
            }
            glossaryExchangeClient.removeGlossary(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID, externalGlossaryIdentifierOne);
            try {
                glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID);
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
            }
            catch (InvalidParameterException invalidParameterException) {
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, unexpectedError);
        }
    }

    private void testOneToMany(String serverPlatformRootURL, String serverName, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testManyToOne(Asset Manager One)";
        GlossaryExchangeClient glossaryExchangeClient = this.getGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        AssetManagerClient assetManagerClient = this.getAssetManagerClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String assetManagerOneGUID = this.getAssetManager(assetManagerOneName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName);
        try {
            String glossaryGUID = this.getGlossary(glossaryExchangeClient, testCaseName, activityName, userId, assetManagerOneGUID, assetManagerOneName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage, externalGlossaryIdentifierOne, externalGlossaryIdentifierOneName, externalGlossaryIdentifierOneUsage, externalGlossaryIdentifierOneSource, externalGlossaryIdentifierOneKeyPattern, null);
            if (glossaryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary One)");
            }
            assetManagerClient.addExternalIdentifier(userId, assetManagerOneGUID, assetManagerOneName, SynchronizationDirection.BOTH_DIRECTIONS, null, glossaryGUID, "Glossary", externalGlossaryIdentifierTwo, externalGlossaryIdentifierTwoName, externalGlossaryIdentifierTwoUsage, externalGlossaryIdentifierTwoSource, externalGlossaryIdentifierTwoKeyPattern, null);
            GlossaryElement retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            List metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.size() != 2) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve)");
            }
            glossaryExchangeClient.removeGlossary(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID, externalGlossaryIdentifierOne);
            try {
                glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryGUID);
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
            }
            catch (InvalidParameterException invalidParameterException) {
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, unexpectedError);
        }
    }

    private void testManyToOne(String serverPlatformRootURL, String serverName, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testManyToOne(Asset Manager One)";
        GlossaryExchangeClient glossaryExchangeClient = this.getGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String assetManagerOneGUID = this.getAssetManager(assetManagerOneName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName);
        try {
            String glossaryOneGUID = this.getGlossary(glossaryExchangeClient, testCaseName, activityName, userId, assetManagerOneGUID, assetManagerOneName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage, externalGlossaryIdentifierOne, externalGlossaryIdentifierOneName, externalGlossaryIdentifierOneUsage, externalGlossaryIdentifierOneSource, externalGlossaryIdentifierOneKeyPattern, null);
            String glossaryTwoGUID = this.getGlossary(glossaryExchangeClient, testCaseName, activityName, userId, assetManagerOneGUID, assetManagerOneName, glossaryTwoName, glossaryTwoDisplayName, glossaryTwoDescription, glossaryTwoUsage, glossaryTwoLanguage, externalGlossaryIdentifierOne, externalGlossaryIdentifierOneName, externalGlossaryIdentifierOneUsage, externalGlossaryIdentifierOneSource, externalGlossaryIdentifierOneKeyPattern, null);
            if (glossaryOneGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary One)");
            }
            if (glossaryTwoGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for getGlossary Two)");
            }
            GlossaryElement retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryOneGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            List metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve)");
            }
            MetadataCorrelationHeader correlationHeader = (MetadataCorrelationHeader)metadataCorrelationHeaders.get(0);
            if (correlationHeader == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties in pos 0 from Retrieve)");
            }
            if (!externalGlossaryIdentifierOne.equals(correlationHeader.getExternalIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier)");
            }
            if (!externalGlossaryIdentifierOneName.equals(correlationHeader.getExternalIdentifierName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier name)");
            }
            if (!externalGlossaryIdentifierOneUsage.equals(correlationHeader.getExternalIdentifierUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier usage)");
            }
            if (!externalGlossaryIdentifierOneSource.equals(correlationHeader.getExternalIdentifierSource())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier source)");
            }
            if (correlationHeader.getLastSynchronized() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(null last sync date)");
            }
            retrievedElement = glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryTwoGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve of Two)");
            }
            metadataCorrelationHeaders = retrievedElement.getCorrelationHeaders();
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve of Two)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve of Two)");
            }
            if (metadataCorrelationHeaders.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong number of Correlation properties from Retrieve of Two)");
            }
            correlationHeader = (MetadataCorrelationHeader)metadataCorrelationHeaders.get(0);
            if (correlationHeader == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties in pos 0 from Retrieve of Two)");
            }
            if (!externalGlossaryIdentifierOne.equals(correlationHeader.getExternalIdentifier())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier)");
            }
            if (!externalGlossaryIdentifierOneName.equals(correlationHeader.getExternalIdentifierName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier name)");
            }
            if (!externalGlossaryIdentifierOneUsage.equals(correlationHeader.getExternalIdentifierUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier usage)");
            }
            if (!externalGlossaryIdentifierOneSource.equals(correlationHeader.getExternalIdentifierSource())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(bad external identifier source)");
            }
            glossaryExchangeClient.removeGlossary(userId, assetManagerOneGUID, assetManagerOneName, glossaryOneGUID, externalGlossaryIdentifierOne);
            try {
                glossaryExchangeClient.getGlossaryByGUID(userId, assetManagerOneGUID, assetManagerOneName, glossaryOneGUID);
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
            }
            catch (InvalidParameterException invalidParameterException) {
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, unexpectedError);
        }
    }
}

