/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.connections.CreateConnectionTest;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.externalidentifiers.ManageExternalIdsTest;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.glossaries.CreateGlossaryTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class AssetManagerOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = AssetManagerOMASFVTSuite.getUrl((String[])args);
            String serverName = AssetManagerOMASFVTSuite.getServerName((String[])args);
            String userId = AssetManagerOMASFVTSuite.getUserId((String[])args);
            AssetManagerOMASFVTSuite fvtSuite = new AssetManagerOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = ManageExternalIdsTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateGlossaryTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateConnectionTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

