/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;
    private static final String assetManagerGUID = "TestExternalSourceGUID";
    private static final String assetManagerName = "TestExternalSourceName";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        thisTest.testAssetManagerClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGlossaryExchangeClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testAssetManagerEventClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testAssetManagerClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testAssetManagerClient";
        try {
            AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
            ExternalAssetManagerClient client = new ExternalAssetManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testCreateExternalAssetManager(userId, client);
            this.testGetExternalAssetManagerGUID(userId, client);
            this.testGetAssetManagerGUID(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testAssetManagerClient", (Throwable)unexpectedError);
        }
    }

    private void testCreateExternalAssetManager(String userId, ExternalAssetManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalAssetManager";
        try {
            this.testCreateExternalAssetManagerNoUserId(client);
            this.testCreateExternalAssetManagerNoProperties(client, userId);
            this.testCreateExternalAssetManagerNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManager", (Throwable)unexpectedError);
        }
    }

    private void testCreateExternalAssetManagerNoUserId(ExternalAssetManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalAssetManagerNoUserId";
        AssetManagerProperties assetManagerProperties = new AssetManagerProperties();
        try {
            client.createExternalAssetManager(null, assetManagerProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManagerNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManagerNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateExternalAssetManagerNoProperties(ExternalAssetManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalAssetManagerNoProperties";
        try {
            client.createExternalAssetManager(userId, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManagerNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManagerNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testCreateExternalAssetManagerNoQualifiedName(ExternalAssetManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalAssetManagerNoQualifiedName";
        try {
            AssetManagerProperties assetManagerProperties = new AssetManagerProperties();
            client.createExternalAssetManager(userId, assetManagerProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManagerNoQualifiedName");
        }
        catch (InvalidParameterException assetManagerProperties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManagerNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testGetExternalAssetManagerGUID(String userId, ExternalAssetManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalAssetManager";
        try {
            this.testGetExternalAssetManagerGUIDNoUserId(client);
            this.testGetExternalAssetManagerGUIDNoProperties(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateExternalAssetManager", (Throwable)unexpectedError);
        }
    }

    private void testGetExternalAssetManagerGUIDNoUserId(ExternalAssetManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testGetExternalAssetManagerGUIDNoUserId";
        try {
            client.getExternalAssetManagerGUID(null, assetManagerName);
            throw new FVTUnexpectedCondition(testCaseName, "testGetExternalAssetManagerGUIDNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetExternalAssetManagerGUIDNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testGetExternalAssetManagerGUIDNoProperties(ExternalAssetManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testGetExternalAssetManagerGUIDNoProperties";
        try {
            client.getExternalAssetManagerGUID(userId, null);
            throw new FVTUnexpectedCondition(testCaseName, "testGetExternalAssetManagerGUIDNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetExternalAssetManagerGUIDNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testGetAssetManagerGUID(String userId, ExternalAssetManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testAssetManager";
        try {
            this.testGetAssetManagerGUIDNoUserId(client);
            this.testGetAssetManagerGUIDNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testAssetManager", (Throwable)unexpectedError);
        }
    }

    private void testGetAssetManagerGUIDNoUserId(ExternalAssetManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testGetAssetManagerGUIDNoUserId";
        try {
            client.getExternalAssetManagerGUID(null, "TestQualifiedName");
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetManagerGUIDNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetManagerGUIDNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testGetAssetManagerGUIDNoQualifiedName(ExternalAssetManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testGetAssetManagerGUIDNoQualifiedName";
        try {
            client.getExternalAssetManagerGUID(userId, null);
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetManagerGUIDNoQualifiedName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetManagerGUIDNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testGlossaryExchangeClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGlossaryExchangeClient";
        try {
            AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
            GlossaryExchangeClient client = new GlossaryExchangeClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testCreateGlossary(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGlossaryExchangeClient", (Throwable)unexpectedError);
        }
    }

    private void testCreateGlossary(String userId, GlossaryExchangeClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGlossary";
        try {
            this.testCreateGlossaryNoUserId(client);
            this.testCreateGlossaryNoProperties(client, userId);
            this.testCreateGlossaryNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateGlossary", (Throwable)unexpectedError);
        }
    }

    private void testCreateGlossaryNoUserId(GlossaryExchangeClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGlossaryNoUserId";
        GlossaryProperties properties = new GlossaryProperties();
        try {
            client.createGlossary(null, assetManagerGUID, assetManagerName, null, properties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateGlossaryNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateGlossaryNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateGlossaryNoProperties(GlossaryExchangeClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGlossaryNoQualifiedName";
        try {
            client.createGlossary(userId, assetManagerGUID, assetManagerName, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateGlossaryNoQualifiedName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateGlossaryNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testCreateGlossaryNoQualifiedName(GlossaryExchangeClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGlossaryNoQualifiedName";
        GlossaryProperties properties = new GlossaryProperties();
        try {
            client.createGlossary(userId, assetManagerGUID, assetManagerName, null, properties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateGlossaryNoQualifiedName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateGlossaryNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testAssetManagerEventClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testAssetManagerEventClient";
        try {
            AssetManagerEventClient client = new AssetManagerEventClient(serverName, serverPlatformRootURL, userId, null, 100, auditLog, "");
            this.testRegisterListener(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testAssetManagerEventClient", (Throwable)unexpectedError);
        }
    }

    private void testRegisterListener(String userId, AssetManagerEventClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFolders";
        try {
            this.testRegisterListenerNoUserId(client);
            this.testRegisterListenerNoListener(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFolders", (Throwable)unexpectedError);
        }
    }

    private void testRegisterListenerNoUserId(AssetManagerEventClient client) throws FVTUnexpectedCondition {
        String activityName = "testRegisterListenerNoUserId";
        try {
            client.registerListener(null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testRegisterListenerNoListener(AssetManagerEventClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testRegisterListenerNoListener";
        try {
            client.registerListener(userId, null);
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoListener");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoListener", (Throwable)unexpectedError);
        }
    }
}

