/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.common;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class AssetManagerTestBase {
    protected static final int maxPageSize = 100;
    private static final String assetManagerDisplayName = " AssetManager displayName";
    private static final String assetManagerDescription = " AssetManager description";
    private static final String assetManagerTypeDescription = " AssetManager type";
    private static final String assetManagerVersion = " AssetManager version";
    protected static final String GLOSSARY_TYPE_NAME = "Glossary";

    protected ExternalAssetManagerClient getAssetManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog, String testCaseName) throws FVTUnexpectedCondition {
        String activityName = "getAssetManagerClient";
        try {
            AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
            return new ExternalAssetManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetManagerClient", (Throwable)unexpectedError);
        }
    }

    protected GlossaryExchangeClient getGlossaryExchangeClient(String serverName, String serverPlatformRootURL, AuditLog auditLog, String testCaseName) throws FVTUnexpectedCondition {
        String activityName = "getGlossaryExchangeClient";
        try {
            AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
            return new GlossaryExchangeClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getGlossaryExchangeClient", (Throwable)unexpectedError);
        }
    }

    protected String getAssetManager(String assetManagerName, String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog, String testCaseName) throws FVTUnexpectedCondition {
        String activityName = "getAssetManager";
        try {
            AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
            ExternalAssetManagerClient client = new ExternalAssetManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            String assetManagerGUID = client.getExternalAssetManagerGUID(userId, assetManagerName);
            if (assetManagerGUID == null) {
                AssetManagerProperties properties = new AssetManagerProperties();
                properties.setQualifiedName(assetManagerName);
                properties.setDisplayName(assetManagerName + assetManagerDisplayName);
                properties.setDescription(assetManagerName + assetManagerDescription);
                properties.setTypeDescription(assetManagerName + assetManagerTypeDescription);
                properties.setVersion(assetManagerName + assetManagerVersion);
                assetManagerGUID = client.createExternalAssetManager(userId, properties);
            }
            if (assetManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAssetManager(no GUID for Create)");
            }
            assetManagerGUID = client.getExternalAssetManagerGUID(userId, assetManagerName);
            if (assetManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAssetManager(no GUID for Retrieve)");
            }
            return assetManagerGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetManager", (Throwable)unexpectedError);
        }
    }

    protected void validateCorrelationHeader(List<MetadataCorrelationHeader> metadataCorrelationHeaders, String testCaseName, String activityName, String assetManagerGUID, String assetManagerName, String glossaryExternalIdentifier, String glossaryExternalIdentifierName, String glossaryExternalIdentifierUsage, String glossaryExternalIdentifierSource, KeyPattern glossaryExternalIdentifierKeyPattern, Map<String, String> mappingProperties, int expectedNumberOfIdentifiers) throws FVTUnexpectedCondition {
        if (glossaryExternalIdentifier == null) {
            if (metadataCorrelationHeaders != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Unexpected correlation properties from Retrieve)");
            }
        } else {
            if (metadataCorrelationHeaders == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Correlation properties from Retrieve)");
            }
            if (metadataCorrelationHeaders.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(empty Correlation properties from Retrieve)");
            }
            boolean bl = false;
        }
    }

    protected void validateElementHeader(ElementHeader elementHeader, String testCaseName, String activityName, String guid, String typeName) throws FVTUnexpectedCondition {
        if (elementHeader == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ElementBase from Retrieve)");
        }
        if (!guid.equals(elementHeader.getGUID())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad guid from Retrieve)");
        }
        if (elementHeader.getType() == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(No type from Retrieve)");
        }
        if (!typeName.equals(elementHeader.getType().getTypeName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad typeName from Retrieve)");
        }
    }

    protected void validateGlossaryProperties(GlossaryProperties glossaryProperties, String testCaseName, String activityName, String glossaryName, String glossaryDisplayName, String glossaryDescription, String glossaryUsage, String glossaryLanguage) throws FVTUnexpectedCondition {
        if (glossaryProperties == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryProperties from Retrieve)");
        }
        if (!glossaryName.equals(glossaryProperties.getQualifiedName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
        }
        if (!glossaryDisplayName.equals(glossaryProperties.getDisplayName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
        }
        if (!glossaryDescription.equals(glossaryProperties.getDescription())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
        }
        if (!glossaryUsage.equals(glossaryProperties.getUsage())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad glossaryUsage from Retrieve)");
        }
        if (!glossaryLanguage.equals(glossaryProperties.getLanguage())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad glossaryLanguage from Retrieve)");
        }
    }

    protected String getGlossary(GlossaryExchangeClient client, String testCaseName, String activityName, String userId, String assetManagerGUID, String assetManagerName, String glossaryName, String glossaryDisplayName, String glossaryDescription, String glossaryUsage, String glossaryLanguage, String glossaryExternalIdentifier, String glossaryExternalIdentifierName, String glossaryExternalIdentifierUsage, String glossaryExternalIdentifierSource, KeyPattern glossaryExternalIdentifierKeyPattern, Map<String, String> mappingProperties) throws FVTUnexpectedCondition {
        try {
            GlossaryProperties properties = new GlossaryProperties();
            properties.setQualifiedName(glossaryName);
            properties.setDisplayName(glossaryDisplayName);
            properties.setDescription(glossaryDescription);
            properties.setUsage(glossaryUsage);
            properties.setLanguage(glossaryLanguage);
            ExternalIdentifierProperties externalIdentifierProperties = new ExternalIdentifierProperties();
            externalIdentifierProperties.setExternalIdentifier(glossaryExternalIdentifier);
            externalIdentifierProperties.setExternalIdentifierName(glossaryExternalIdentifierName);
            externalIdentifierProperties.setExternalIdentifierUsage(glossaryExternalIdentifierUsage);
            externalIdentifierProperties.setExternalIdentifierSource(glossaryExternalIdentifierSource);
            externalIdentifierProperties.setKeyPattern(glossaryExternalIdentifierKeyPattern);
            String glossaryGUID = client.createGlossary(userId, assetManagerGUID, assetManagerName, externalIdentifierProperties, properties);
            if (glossaryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for Create)");
            }
            GlossaryElement retrievedElement = client.getGlossaryByGUID(userId, assetManagerGUID, assetManagerName, glossaryGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryElement from Retrieve)");
            }
            this.validateElementHeader(retrievedElement.getElementHeader(), testCaseName, activityName, glossaryGUID, GLOSSARY_TYPE_NAME);
            this.validateGlossaryProperties(retrievedElement.getGlossaryProperties(), testCaseName, activityName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage);
            this.validateCorrelationHeader(retrievedElement.getCorrelationHeaders(), testCaseName, activityName, assetManagerGUID, assetManagerName, glossaryExternalIdentifier, glossaryExternalIdentifierName, glossaryExternalIdentifierUsage, glossaryExternalIdentifierSource, glossaryExternalIdentifierKeyPattern, mappingProperties, 1);
            List glossaryList = client.getGlossariesByName(userId, assetManagerGUID, assetManagerName, glossaryName, 0, 100);
            if (glossaryList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Glossary for RetrieveByName)");
            }
            if (glossaryList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Glossary list for RetrieveByName)");
            }
            if (glossaryList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Glossary list for RetrieveByName contains" + glossaryList.size() + " elements)");
            }
            retrievedElement = (GlossaryElement)glossaryList.get(0);
            this.validateElementHeader(retrievedElement.getElementHeader(), testCaseName, activityName, glossaryGUID, GLOSSARY_TYPE_NAME);
            this.validateGlossaryProperties(retrievedElement.getGlossaryProperties(), testCaseName, activityName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage);
            this.validateCorrelationHeader(retrievedElement.getCorrelationHeaders(), testCaseName, activityName, assetManagerGUID, assetManagerName, glossaryExternalIdentifier, glossaryExternalIdentifierName, glossaryExternalIdentifierUsage, glossaryExternalIdentifierSource, glossaryExternalIdentifierKeyPattern, mappingProperties, 1);
            return glossaryGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }
}

