/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.glossaries;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.common.AssetManagerTestBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateGlossaryTest
extends AssetManagerTestBase {
    private static final String testCaseName = "CreateGlossaryTest";
    private static final int maxPageSize = 100;
    private static final String assetManagerName = "TestGlossaryAssetManager";
    private static final String externalGlossaryIdentifier = "TestExternalIdentifier";
    private static final String externalGlossaryIdentifierName = "TestExternalIdentifierName";
    private static final String externalGlossaryIdentifierUsage = "TestExternalIdentifierUsage";
    private static final KeyPattern externalGlossaryIdentifierKeyPattern = KeyPattern.CALLERS_KEY;
    private static final String externalGlossaryIdentifierSource = "TestExternalIdentifierSource";
    private static final String externalCategoryIdentifier = "TestExternalCategoryIdentifier";
    private static final String externalCategoryIdentifierName = "TestExternalCategoryIdentifierName";
    private static final String externalCategoryIdentifierUsage = "TestExternalCategoryIdentifierUsage";
    private static final KeyPattern externalCategoryIdentifierKeyPattern = KeyPattern.RECYCLED_KEY;
    private static final String externalCategoryIdentifierSource = "TestExternalCategoryIdentifierSource";
    private static final String externalTermIdentifier = "TestExternalTermIdentifier";
    private static final String externalTermIdentifierName = "TestExternalTermIdentifierName";
    private static final String externalTermIdentifierUsage = "TestExternalTermIdentifierUsage";
    private static final KeyPattern externalTermIdentifierKeyPattern = null;
    private static final String externalTermIdentifierSource = "TestExternalTermIdentifierSource";
    private static final String glossaryName = "TestGlossaryCreate";
    private static final String glossaryDisplayName = "Glossary displayName";
    private static final String glossaryDescription = "Glossary description";
    private static final String glossaryUsage = "Glossary usage";
    private static final String glossaryLanguage = "Glossary language";
    private static final String glossaryCategoryName = "TestGlossaryCreateCategory";
    private static final String glossaryCategoryDisplayName = "GlossaryCategory displayName";
    private static final String glossaryCategoryDescription = "GlossaryCategory description";
    private static final String glossaryTermName = "TestGlossaryCreateTerm";
    private static final String glossaryTermDisplayName = "GlossaryTerm displayName";
    private static final String glossaryTermDescription = "GlossaryTerm description";
    private static final String controlledGlossaryTermName = "TestGlossaryCreateControlledTerm";
    private static final String controlledGlossaryTermDisplayName = "ControlledGlossaryTerm displayName";
    private static final String controlledGlossaryTermDescription = "ControlledGlossaryTerm description";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateGlossaryTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateGlossaryTest thisTest = new CreateGlossaryTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        String assetManagerGUID = thisTest.getAssetManager(assetManagerName, serverName, serverPlatformRootURL, userId, auditLog, testCaseName);
        GlossaryExchangeClient client = thisTest.getGlossaryExchangeClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String activityName = "getGlossary(TestGlossaryCreate)";
        String glossaryGUID = thisTest.getGlossary(client, testCaseName, activityName, userId, assetManagerGUID, assetManagerName, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage, externalGlossaryIdentifier, externalGlossaryIdentifierName, externalGlossaryIdentifierUsage, externalGlossaryIdentifierSource, externalGlossaryIdentifierKeyPattern, null);
        try {
            GlossaryElement glossaryElement = client.getGlossaryByGUID(userId, assetManagerGUID, assetManagerName, glossaryGUID);
            if (glossaryElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no glossary element)");
            }
            if (glossaryElement.getElementHeader() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no glossary header) " + glossaryElement.toString());
            }
            if (glossaryElement.getGlossaryProperties() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no glossary properties) " + glossaryElement.toString());
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        String glossaryCategoryGUID = thisTest.getGlossaryCategory(client, assetManagerGUID, glossaryGUID, userId);
        String glossaryTermGUID = thisTest.getGlossaryTerm(client, assetManagerGUID, glossaryGUID, userId);
        String controlledGlossaryTermGUID = thisTest.getControlledGlossaryTerm(client, glossaryGUID, userId);
        thisTest.addTermToCategory(client, assetManagerGUID, glossaryCategoryGUID, glossaryTermGUID, userId, "GlossaryTerm", glossaryTermName, glossaryTermDisplayName, glossaryTermDescription, ElementStatus.ACTIVE);
        thisTest.addTermToCategory(client, assetManagerGUID, glossaryCategoryGUID, controlledGlossaryTermGUID, userId, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, ElementStatus.DRAFT);
        try {
            client.removeGlossary(userId, assetManagerGUID, assetManagerName, glossaryGUID, externalGlossaryIdentifier);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " => " + glossaryGUID, (Throwable)unexpectedError);
        }
        try {
            client.getGlossaryByGUID(userId, assetManagerGUID, assetManagerName, glossaryGUID);
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
        }
        catch (InvalidParameterException unexpectedError) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getGlossaryCategory(GlossaryExchangeClient client, String assetManagerGUID, String glossaryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getGlossaryCategory";
        try {
            GlossaryCategoryProperties properties = new GlossaryCategoryProperties();
            properties.setQualifiedName(glossaryCategoryName);
            properties.setDisplayName(glossaryCategoryDisplayName);
            properties.setDescription(glossaryCategoryDescription);
            ExternalIdentifierProperties externalIdentifierProperties = new ExternalIdentifierProperties();
            externalIdentifierProperties.setExternalIdentifier(externalCategoryIdentifier);
            externalIdentifierProperties.setExternalIdentifierName(externalCategoryIdentifierName);
            externalIdentifierProperties.setExternalIdentifierUsage(externalCategoryIdentifierUsage);
            externalIdentifierProperties.setExternalIdentifierSource(externalCategoryIdentifierSource);
            externalIdentifierProperties.setKeyPattern(externalCategoryIdentifierKeyPattern);
            externalIdentifierProperties.setMappingProperties(null);
            String glossaryCategoryGUID = client.createGlossaryCategory(userId, assetManagerGUID, assetManagerName, glossaryGUID, externalIdentifierProperties, properties);
            if (glossaryCategoryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GUID for schemaCreate)");
            }
            GlossaryCategoryElement retrievedElement = client.getGlossaryCategoryByGUID(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, null, false, false);
            GlossaryCategoryProperties retrievedCategory = retrievedElement.getGlossaryCategoryProperties();
            if (retrievedCategory == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GlossaryCategory from Retrieve) " + retrievedElement.toString());
            }
            if (retrievedElement.getElementHeader() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no Header from Retrieve) " + retrievedElement.toString());
            }
            if (!glossaryCategoryName.equals(retrievedCategory.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad qualifiedName from Retrieve)");
            }
            if (!glossaryCategoryDisplayName.equals(retrievedCategory.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad displayName from Retrieve)");
            }
            if (!glossaryCategoryDescription.equals(retrievedCategory.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad description from Retrieve)");
            }
            List glossaryCategoryList = client.getGlossaryCategoriesByName(userId, assetManagerGUID, assetManagerName, glossaryCategoryName, 0, 100, null, false, false);
            if (glossaryCategoryList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GlossaryCategory for RetrieveByName)");
            }
            if (glossaryCategoryList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Empty GlossaryCategory list for RetrieveByName)");
            }
            if (glossaryCategoryList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(GlossaryCategory list for RetrieveByName contains" + glossaryCategoryList.size() + " elements)");
            }
            retrievedElement = (GlossaryCategoryElement)glossaryCategoryList.get(0);
            retrievedCategory = retrievedElement.getGlossaryCategoryProperties();
            if (!glossaryCategoryName.equals(retrievedCategory.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad qualifiedName from RetrieveByName)");
            }
            if (!glossaryCategoryDisplayName.equals(retrievedCategory.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad displayName from RetrieveByName)");
            }
            if (!glossaryCategoryDescription.equals(retrievedCategory.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad description from RetrieveByName)");
            }
            return glossaryCategoryGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory", (Throwable)unexpectedError);
        }
    }

    private void addTermToCategory(GlossaryExchangeClient client, String assetManagerGUID, String glossaryCategoryGUID, String glossaryTermGUID, String userId, String typeName, String qualifiedName, String displayName, String description, ElementStatus status) throws FVTUnexpectedCondition {
        String activityName = "addTermToCategory";
        try {
            GlossaryTermCategorization categorizationProperties = new GlossaryTermCategorization();
            categorizationProperties.setDescription("Category for " + glossaryTermGUID);
            categorizationProperties.setStatus(GlossaryTermRelationshipStatus.ACTIVE);
            client.setupTermCategory(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, glossaryTermGUID, categorizationProperties, null, false, false);
            List glossaryTermList = client.getTermsForGlossaryCategory(userId, null, null, glossaryCategoryGUID, 0, 0, null, false, false);
            this.validateGlossaryTermElements("addTermToCategory", "RetrieveByCategory", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, status);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "addTermToCategory", (Throwable)unexpectedError);
        }
    }

    private String getGlossaryTerm(GlossaryExchangeClient client, String assetManagerGUID, String glossaryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getGlossaryTerm";
        try {
            GlossaryTermProperties properties = new GlossaryTermProperties();
            properties.setQualifiedName(glossaryTermName);
            properties.setDisplayName(glossaryTermDisplayName);
            properties.setDescription(glossaryTermDescription);
            HashMap<String, String> mappingProperties = new HashMap<String, String>();
            mappingProperties.put("prop1", "One");
            mappingProperties.put("prop2", "Two");
            ExternalIdentifierProperties externalIdentifierProperties = new ExternalIdentifierProperties();
            externalIdentifierProperties.setExternalIdentifier(externalTermIdentifier);
            externalIdentifierProperties.setExternalIdentifierName(externalTermIdentifierName);
            externalIdentifierProperties.setExternalIdentifierUsage(externalTermIdentifierUsage);
            externalIdentifierProperties.setExternalIdentifierSource(externalTermIdentifierSource);
            externalIdentifierProperties.setKeyPattern(externalTermIdentifierKeyPattern);
            externalIdentifierProperties.setMappingProperties(mappingProperties);
            String glossaryTermGUID = client.createGlossaryTerm(userId, assetManagerGUID, assetManagerName, glossaryGUID, externalIdentifierProperties, properties);
            if (glossaryTermGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(no GUID for GlossaryTerm Create)");
            }
            this.validateGlossaryTerm(client, userId, assetManagerGUID, "getGlossaryTerm", glossaryGUID, glossaryTermGUID, "GlossaryTerm", glossaryTermName, glossaryTermDisplayName, glossaryTermDescription, ElementStatus.ACTIVE);
            return glossaryTermGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm", (Throwable)unexpectedError);
        }
    }

    private String getControlledGlossaryTerm(GlossaryExchangeClient client, String glossaryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getControlledGlossaryTerm";
        try {
            GlossaryTermProperties properties = new GlossaryTermProperties();
            properties.setQualifiedName(controlledGlossaryTermName);
            properties.setDisplayName(controlledGlossaryTermDisplayName);
            properties.setDescription(controlledGlossaryTermDescription);
            String glossaryTermGUID = client.createControlledGlossaryTerm(userId, null, null, glossaryGUID, null, properties, GlossaryTermStatus.DRAFT);
            if (glossaryTermGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getControlledGlossaryTerm(no GUID for ControlledGlossaryTerm Create)");
            }
            this.validateGlossaryTerm(client, userId, null, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, ElementStatus.DRAFT);
            client.updateGlossaryTermStatus(userId, null, null, glossaryTermGUID, null, GlossaryTermStatus.PROPOSED, null, false, false);
            this.validateGlossaryTerm(client, userId, null, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, ElementStatus.PROPOSED);
            client.updateGlossaryTermStatus(userId, null, null, glossaryTermGUID, null, GlossaryTermStatus.APPROVED, null, false, false);
            this.validateGlossaryTerm(client, userId, null, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, ElementStatus.APPROVED);
            client.updateGlossaryTermStatus(userId, null, null, glossaryTermGUID, null, GlossaryTermStatus.ACTIVE, null, false, false);
            this.validateGlossaryTerm(client, userId, null, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, ElementStatus.ACTIVE);
            client.updateGlossaryTermStatus(userId, null, null, glossaryTermGUID, null, GlossaryTermStatus.DRAFT, null, false, false);
            this.validateGlossaryTerm(client, userId, null, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, ElementStatus.DRAFT);
            return glossaryTermGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getControlledGlossaryTerm", (Throwable)unexpectedError);
        }
    }

    private void validateGlossaryTerm(GlossaryExchangeClient client, String userId, String assetManagerGUID, String activityName, String glossaryGUID, String glossaryTermGUID, String typeName, String qualifiedName, String displayName, String description, ElementStatus status) throws FVTUnexpectedCondition {
        try {
            GlossaryTermElement retrievedElement = client.getGlossaryTermByGUID(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, null, false, false);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryTerm from Retrieve)");
            }
            this.validateGlossaryTermElement(activityName, "Retrieve", retrievedElement, glossaryTermGUID, typeName, qualifiedName, displayName, description, status);
            List glossaryTermList = client.getGlossaryTermsByName(userId, assetManagerGUID, assetManagerName, qualifiedName, 0, 100, null, false, false);
            this.validateGlossaryTermElements(activityName, "RetrieveByQualifiedName", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, status);
            glossaryTermList = client.getGlossaryTermsByName(userId, assetManagerGUID, assetManagerName, displayName, 0, 0, null, false, false);
            this.validateGlossaryTermElements(activityName, "RetrieveTermsByGlossary", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, status);
            glossaryTermList = client.getTermsForGlossary(userId, null, null, glossaryGUID, 0, 0, null, false, false);
            this.validateGlossaryTermElements(activityName, "RetrieveTermsByGlossary", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, status);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void validateGlossaryTermElements(String activityName, String stepName, List<GlossaryTermElement> retrievedElements, String glossaryTermGUID, String typeName, String qualifiedName, String displayName, String description, ElementStatus status) throws FVTUnexpectedCondition {
        if (retrievedElements == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryTerm for " + stepName + ")");
        }
        if (retrievedElements.isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty GlossaryTerm list for " + stepName + ")");
        }
        boolean elementFound = false;
        for (GlossaryTermElement termElement : retrievedElements) {
            if (!this.validateGlossaryTermElement(activityName, stepName, termElement, glossaryTermGUID, typeName, qualifiedName, displayName, description, status)) continue;
            elementFound = true;
        }
        if (!elementFound) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Element " + glossaryTermGUID + " not found for " + stepName + ") " + retrievedElements.size() + " elements retrieved: " + retrievedElements.toString());
        }
    }

    private boolean validateGlossaryTermElement(String activityName, String stepName, GlossaryTermElement retrievedElement, String glossaryTermGUID, String typeName, String qualifiedName, String displayName, String description, ElementStatus status) throws FVTUnexpectedCondition {
        ElementHeader retrievedHeader = retrievedElement.getElementHeader();
        if (retrievedHeader == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryTerm header from " + stepName + ")" + retrievedElement.toString());
        }
        if (!glossaryTermGUID.equals(retrievedHeader.getGUID())) {
            return false;
        }
        if (!typeName.equals(retrievedHeader.getType().getTypeName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad GlossaryTerm type of " + retrievedHeader.getType().getTypeName() + " rather than " + typeName + " from " + stepName + ")");
        }
        if (retrievedHeader.getOrigin().getHomeMetadataCollectionId() == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Null GlossaryTerm metadata collection id from " + stepName + ")");
        }
        GlossaryTermProperties retrievedTerm = retrievedElement.getGlossaryTermProperties();
        if (status != retrievedHeader.getStatus()) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad GlossaryTerm status of " + retrievedHeader.getStatus() + " rather than " + status + " from " + stepName + ")");
        }
        if (retrievedTerm == null) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(No GlossaryTerm from " + stepName + ")");
        }
        if (!qualifiedName.equals(retrievedTerm.getQualifiedName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from " + stepName + ": " + retrievedTerm.getQualifiedName() + " rather than " + qualifiedName + ")");
        }
        if (!displayName.equals(retrievedTerm.getDisplayName())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from " + stepName + ": " + retrievedTerm.getDisplayName() + " rather than " + displayName + ")");
        }
        if (!description.equals(retrievedTerm.getDescription())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from " + stepName + ": " + retrievedTerm.getDescription() + " rather than " + description + ")");
        }
        return true;
    }
}

