/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.connections;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ConnectionExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateConnectionTest {
    private static final String testCaseName = "CreateConnectionTest";
    private static final int maxPageSize = 100;
    private static final ExternalIdentifierProperties externalIdProperties = null;
    private static final String externalId = null;
    private static final String assetManagerName = "TestConnectionManager";
    private static final String assetManagerDisplayName = "ConnectionManager displayName";
    private static final String assetManagerDescription = "ConnectionManager description";
    private static final String assetManagerTypeDescription = "ConnectionManager type";
    private static final String assetManagerVersion = "ConnectionManager version";
    private static final String connectionName = "TestConnection";
    private static final String connectionDisplayName = "Connection displayName";
    private static final String connectionDescription = "Connection description";
    private static final String endpointName = "TestEndpoint";
    private static final String endpointTechnicalName = "Endpoint technicalName";
    private static final String endpointTechnicalDescription = "Endpoint technicalDescription";
    private static final String endpointDisplayName = "Endpoint displayName";
    private static final String endpointDescription = "Endpoint description";
    private static final String connectorTypeName = "TestConnectorType";
    private static final String connectorTypeDisplayName = "ConnectorType displayName";
    private static final String connectorTypeDescription = "ConnectorType description";
    private static final String connectorProviderClassName = "string";
    private static final String connectorTypeTwoName = "TestConnectorType2";
    private static final String connectorTypeTwoDisplayName = "ConnectorType2 displayName";
    private static final String connectorTypeTwoDescription = "ConnectorType2 description";
    private static final Date effectiveFrom = null;
    private static final Date effectiveTo = null;
    private static final Date effectiveTime = null;
    private static final boolean forLineage = false;
    private static final boolean forDuplicateProcessing = false;
    private static final boolean assetManagerIsHome = true;
    private static final boolean isMergeUpdate = true;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateConnectionTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateConnectionTest thisTest = new CreateConnectionTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        ConnectionExchangeClient client = thisTest.getConnectionClient(serverName, serverPlatformRootURL, auditLog);
        String assetManagerGUID = thisTest.getAssetManager(serverName, serverPlatformRootURL, userId, auditLog);
        String connectionGUID = thisTest.getConnection(client, assetManagerGUID, userId);
        String endpointGUID = thisTest.createEndpoint(client, assetManagerGUID, connectionGUID, userId);
        String connectorTypeGUID = thisTest.createConnectorType(client, assetManagerGUID, connectionGUID, userId);
        String activityName = "deleteOneByOne";
        try {
            client.removeConnection(userId, assetManagerGUID, assetManagerName, connectionGUID, externalId, effectiveTime, false, false);
            activityName = "deleteOneByOne - connection gone";
            thisTest.checkConnectionGone(client, assetManagerGUID, connectionGUID, activityName, userId);
            thisTest.checkConnectorTypeOK(client, assetManagerGUID, connectorTypeGUID, null, activityName, userId);
            thisTest.checkEndpointOK(client, assetManagerGUID, endpointGUID, null, activityName, userId);
            client.removeConnectorType(userId, assetManagerGUID, assetManagerName, connectorTypeGUID, externalId, effectiveTime, false, false);
            activityName = "deleteOneByOne - connectorType gone";
            thisTest.checkConnectorTypeGone(client, assetManagerGUID, connectorTypeGUID, null, activityName, userId);
            thisTest.checkEndpointOK(client, assetManagerGUID, endpointGUID, null, activityName, userId);
            thisTest.checkConnectionGone(client, assetManagerGUID, connectionGUID, activityName, userId);
            client.removeEndpoint(userId, assetManagerGUID, assetManagerName, endpointGUID, externalId, effectiveTime, false, false);
            activityName = "deleteOneByOne - endpoint gone";
            thisTest.checkConnectorTypeGone(client, assetManagerGUID, connectorTypeGUID, null, activityName, userId);
            thisTest.checkEndpointGone(client, assetManagerGUID, endpointGUID, null, activityName, userId);
            thisTest.checkConnectionGone(client, assetManagerGUID, connectionGUID, activityName, userId);
            activityName = "updateNonExistentConnectorType";
            String connectorTypeTwoGUID = "Blah Blah";
            ConnectorTypeProperties connectorTypeProperties = new ConnectorTypeProperties();
            connectorTypeProperties.setQualifiedName(connectorTypeTwoName);
            connectorTypeProperties.setDisplayName(connectorTypeDisplayName);
            connectorTypeProperties.setDescription(connectorTypeDescription);
            connectorTypeProperties.setConnectorProviderClassName(connectorProviderClassName);
            try {
                client.updateConnectorType(userId, assetManagerGUID, assetManagerName, connectorTypeTwoGUID, externalId, true, connectorTypeProperties, effectiveTime, false, false);
                throw new FVTUnexpectedCondition(testCaseName, activityName);
            }
            catch (InvalidParameterException invalidParameterException) {
                activityName = "updateConnectorTypeWithSameProperties";
                connectorTypeTwoGUID = client.createConnectorType(userId, assetManagerGUID, assetManagerName, true, externalIdProperties, connectorTypeProperties);
                ConnectorTypeElement beforeElement = client.getConnectorTypeByGUID(userId, assetManagerGUID, assetManagerName, connectorTypeTwoGUID, effectiveTime, false, false);
                client.updateConnectorType(userId, assetManagerGUID, assetManagerName, connectorTypeTwoGUID, externalId, true, connectorTypeProperties, effectiveTime, false, false);
                ConnectorTypeElement afterElement = client.getConnectorTypeByGUID(userId, assetManagerGUID, assetManagerName, connectorTypeTwoGUID, effectiveTime, false, false);
                if (!beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(version changed from " + beforeElement.getElementHeader().getVersions() + " to " + afterElement.getElementHeader().getVersions() + ")");
                }
                activityName = "updateConnectorTypeProperties";
                connectorTypeProperties.setDisplayName(connectorTypeTwoDisplayName);
                client.updateConnectorType(userId, assetManagerGUID, assetManagerName, connectorTypeTwoGUID, externalId, true, connectorTypeProperties, effectiveTime, false, false);
                afterElement = client.getConnectorTypeByGUID(userId, assetManagerGUID, assetManagerName, connectorTypeTwoGUID, effectiveTime, false, false);
                if (beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(version did not change from " + beforeElement.getElementHeader().getVersions() + ")");
                }
                if (!connectorTypeTwoDisplayName.equals(afterElement.getConnectorTypeProperties().getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(display name should be ConnectorType2 displayName rather than " + afterElement.getConnectorTypeProperties().getDisplayName() + ")");
                }
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private ConnectionExchangeClient getConnectionClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getConnectionExchangeClient";
        try {
            AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
            return new ConnectionExchangeClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getConnectionExchangeClient", (Throwable)unexpectedError);
        }
    }

    private String getAssetManager(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetManager";
        try {
            AssetManagerRESTClient restClient = new AssetManagerRESTClient(serverName, serverPlatformRootURL);
            ExternalAssetManagerClient client = new ExternalAssetManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            AssetManagerProperties properties = new AssetManagerProperties();
            properties.setQualifiedName(assetManagerName);
            properties.setDisplayName(assetManagerDisplayName);
            properties.setDescription(assetManagerDescription);
            properties.setTypeDescription(assetManagerTypeDescription);
            properties.setVersion(assetManagerVersion);
            String assetManagerGUID = client.createExternalAssetManager(userId, properties);
            if (assetManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAssetManager(no GUID for Create)");
            }
            String retrievedAssetManagerGUID = client.getExternalAssetManagerGUID(userId, assetManagerName);
            if (retrievedAssetManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAssetManager(no GUID for Retrieve)");
            }
            if (!retrievedAssetManagerGUID.equals(assetManagerGUID)) {
                throw new FVTUnexpectedCondition(testCaseName, "getAssetManager(Inconsistent GUIDs)");
            }
            return assetManagerGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetManager", (Throwable)unexpectedError);
        }
    }

    private void checkConnectionGone(ConnectionExchangeClient client, String assetManagerGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectionElement retrievedElement = client.getConnectionByGUID(userId, assetManagerGUID, assetManagerName, connectionGUID, effectiveTime, false, false);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connection returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Retrieve returned)");
        }
        catch (InvalidParameterException retrievedElement) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkConnectionOK(ConnectionExchangeClient client, String assetManagerGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectionElement retrievedElement = client.getConnectionByGUID(userId, assetManagerGUID, assetManagerName, connectionGUID, effectiveTime, false, false);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectionElement from Retrieve)");
            }
            ConnectionProperties retrievedConnection = retrievedElement.getConnectionProperties();
            if (retrievedConnection == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectionProperties from Retrieve)");
            }
            if (!connectionName.equals(retrievedConnection.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedConnection);
            }
            if (!connectionDisplayName.equals(retrievedConnection.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedConnection);
            }
            if (!connectionDescription.equals(retrievedConnection.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedConnection);
            }
            List connectionList = client.getConnectionsByName(userId, assetManagerGUID, assetManagerName, connectionName, 0, 100, effectiveTime, false, false);
            if (connectionList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Connection for RetrieveByName)");
            }
            if (connectionList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Connection list for RetrieveByName)");
            }
            if (connectionList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connection list for RetrieveByName contains" + connectionList.size() + " elements) =>>" + connectionList);
            }
            retrievedElement = (ConnectionElement)connectionList.get(0);
            retrievedConnection = retrievedElement.getConnectionProperties();
            if (!connectionName.equals(retrievedConnection.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedConnection);
            }
            if (!connectionDisplayName.equals(retrievedConnection.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedConnection);
            }
            if (!connectionDescription.equals(retrievedConnection.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedConnection);
            }
            connectionList = client.getConnectionsByName(userId, assetManagerGUID, assetManagerName, connectionName, 1, 100, effectiveTime, false, false);
            if (connectionList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "Connection for RetrieveByName (from 1) =>>" + retrievedConnection);
            }
            connectionList = client.getConnectionsForAssetManager(userId, assetManagerGUID, assetManagerName, 0, 100, effectiveTime, false, false);
            if (connectionList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connection for getConnectionsForAssetManager) =>>" + retrievedConnection);
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getConnection(ConnectionExchangeClient client, String assetManagerGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getConnection";
        try {
            ConnectionProperties properties = new ConnectionProperties();
            properties.setQualifiedName(connectionName);
            properties.setDisplayName(connectionDisplayName);
            properties.setDescription(connectionDescription);
            properties.setEffectiveFrom(effectiveFrom);
            properties.setEffectiveTo(effectiveTo);
            String connectionGUID = client.createConnection(userId, assetManagerGUID, assetManagerName, true, externalIdProperties, properties);
            if (connectionGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getConnection(no GUID for Create)");
            }
            this.checkConnectionOK(client, assetManagerGUID, connectionGUID, "getConnection", userId);
            return connectionGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getConnection", (Throwable)unexpectedError);
        }
    }

    private void checkEndpointGone(ConnectionExchangeClient client, String assetManagerGUID, String endpointGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            EndpointElement retrievedElement = client.getEndpointByGUID(userId, assetManagerGUID, assetManagerName, endpointGUID, effectiveTime, false, false);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getEndpointByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (connectionGUID != null) {
            try {
                ConnectionElement connection = client.getConnectionByGUID(userId, assetManagerGUID, assetManagerName, connectionGUID, effectiveTime, false, false);
                ElementStub endpoint = connection.getEndpoint();
                if (endpoint != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint " + endpoint + " returned for connection)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkEndpointOK(ConnectionExchangeClient client, String assetManagerGUID, String endpointGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        block23: {
            try {
                EndpointElement retrievedElement = client.getEndpointByGUID(userId, assetManagerGUID, assetManagerName, endpointGUID, effectiveTime, false, false);
                if (retrievedElement == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EndpointElement from Retrieve)");
                }
                EndpointProperties retrievedEndpoint = retrievedElement.getEndpointProperties();
                if (retrievedEndpoint == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EndpointProperties from Retrieve)");
                }
                if (!endpointName.equals(retrievedEndpoint.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointTechnicalName.equals(retrievedEndpoint.getTechnicalName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad technicalName from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointTechnicalDescription.equals(retrievedEndpoint.getTechnicalDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad technicalDescription from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointDisplayName.equals(retrievedEndpoint.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointDescription.equals(retrievedEndpoint.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedEndpoint);
                }
                List endpointList = client.getEndpointsByName(userId, assetManagerGUID, assetManagerName, endpointName, 0, 100, effectiveTime, false, false);
                if (endpointList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Endpoint for RetrieveByName)");
                }
                if (endpointList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Endpoint list for RetrieveByName)");
                }
                if (endpointList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint list for RetrieveByName contains" + endpointList.size() + " elements)");
                }
                retrievedElement = (EndpointElement)endpointList.get(0);
                retrievedEndpoint = retrievedElement.getEndpointProperties();
                if (!endpointName.equals(retrievedEndpoint.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (!endpointDisplayName.equals(retrievedEndpoint.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (!endpointDescription.equals(retrievedEndpoint.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedEndpoint);
                }
                endpointList = client.getEndpointsForAssetManager(userId, assetManagerGUID, assetManagerName, 0, 100, effectiveTime, false, false);
                if (endpointList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint list for Asset Manager contains" + endpointList.size() + " elements)");
                }
                if (connectionGUID == null) break block23;
                try {
                    ConnectionElement connection = client.getConnectionByGUID(userId, assetManagerGUID, assetManagerName, connectionGUID, null, false, false);
                    ElementStub endpoint = connection.getEndpoint();
                    if (endpoint == null) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(No Endpoint returned for connection)");
                    }
                    if (!endpointGUID.equals(endpoint.getGUID())) {
                        System.out.println("ConnectionGUID: " + connectionGUID);
                        System.out.println("EndpointGUID: " + endpointGUID);
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong Endpoint returned for connection: " + endpoint.getGUID() + "rather than " + endpointGUID + ")");
                    }
                    if (!endpointName.equals(endpoint.getUniqueName())) {
                        System.out.println("ConnectionGUID: " + connectionGUID);
                        System.out.println("Endpoint: " + endpoint);
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong Endpoint Qualified Name returned for connection: " + endpoint.getUniqueName() + "rather than TestEndpoint)");
                    }
                }
                catch (FVTUnexpectedCondition testCaseError) {
                    throw testCaseError;
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private String createEndpoint(ConnectionExchangeClient client, String assetManagerGUID, String connectionGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createEndpoint";
        try {
            EndpointProperties properties = new EndpointProperties();
            properties.setQualifiedName(endpointName);
            properties.setTechnicalName(endpointTechnicalName);
            properties.setTechnicalDescription(endpointTechnicalDescription);
            properties.setDisplayName(endpointDisplayName);
            properties.setDescription(endpointDescription);
            properties.setEffectiveFrom(effectiveFrom);
            properties.setEffectiveTo(effectiveTo);
            String endpointGUID = client.createEndpoint(userId, assetManagerGUID, assetManagerName, true, externalIdProperties, properties);
            if (endpointGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createEndpoint(no GUID for endpointCreate)");
            }
            client.setupEndpoint(userId, assetManagerGUID, assetManagerName, true, connectionGUID, endpointGUID, effectiveFrom, effectiveTo, effectiveTime, false, false);
            this.checkEndpointOK(client, assetManagerGUID, endpointGUID, connectionGUID, "createEndpoint", userId);
            return endpointGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createEndpoint", (Throwable)unexpectedError);
        }
    }

    private void checkConnectorTypeGone(ConnectionExchangeClient client, String assetManagerGUID, String connectorTypeGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectorTypeElement retrievedElement = client.getConnectorTypeByGUID(userId, assetManagerGUID, assetManagerName, connectorTypeGUID, effectiveTime, false, false);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(ConnectorType returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getConnectorTypeByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (connectionGUID != null) {
            try {
                ConnectionElement connection = client.getConnectionByGUID(userId, assetManagerGUID, assetManagerName, connectionGUID, null, false, false);
                ElementStub connectorType = connection.getConnectorType();
                if (connectorType != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connector Type " + connectorType + " returned for Connection)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkConnectorTypeOK(ConnectionExchangeClient client, String assetManagerGUID, String connectorTypeGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        block21: {
            try {
                ConnectorTypeElement retrievedElement = client.getConnectorTypeByGUID(userId, assetManagerGUID, assetManagerName, connectorTypeGUID, effectiveTime, false, false);
                if (retrievedElement == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorTypeElement from Retrieve)");
                }
                ConnectorTypeProperties retrievedConnectorType = retrievedElement.getConnectorTypeProperties();
                if (retrievedConnectorType == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorTypeProperties from Retrieve)");
                }
                if (!connectorTypeName.equals(retrievedConnectorType.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDisplayName.equals(retrievedConnectorType.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDescription.equals(retrievedConnectorType.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedConnectorType);
                }
                List connectorTypeList = client.getConnectorTypesByName(userId, assetManagerGUID, assetManagerName, connectorTypeName, 0, 100, effectiveTime, false, false);
                if (connectorTypeList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorType for RetrieveByName)");
                }
                if (connectorTypeList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty ConnectorType list for RetrieveByName)");
                }
                if (connectorTypeList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(ConnectorType list for RetrieveByName contains" + connectorTypeList.size() + " elements)");
                }
                retrievedElement = (ConnectorTypeElement)connectorTypeList.get(0);
                retrievedConnectorType = retrievedElement.getConnectorTypeProperties();
                if (!connectorTypeName.equals(retrievedConnectorType.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDisplayName.equals(retrievedConnectorType.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDescription.equals(retrievedConnectorType.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedConnectorType);
                }
                connectorTypeList = client.getConnectorTypesForAssetManager(userId, assetManagerGUID, assetManagerName, 0, 100, effectiveTime, false, false);
                if (connectorTypeList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(ConnectorType list for getConnectorTypesForAssetManager contains" + connectorTypeList.size() + " elements)");
                }
                if (connectionGUID == null) break block21;
                try {
                    ConnectionElement connection = client.getConnectionByGUID(userId, assetManagerGUID, assetManagerName, connectionGUID, effectiveTime, false, false);
                    ElementStub connectorType = connection.getConnectorType();
                    if (connectorType == null) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(No connectorType returned for connection: " + connection + ")");
                    }
                    if (!connectorTypeGUID.equals(connectorType.getGUID())) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong connector type returned for connection: " + connectorType.getGUID() + "rather than " + connectorTypeGUID + ")");
                    }
                    if (!connectorTypeName.equals(connectorType.getUniqueName())) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong connector type Qualified Name returned for connection: " + connectorType.getUniqueName() + "rather than TestEndpoint)");
                    }
                }
                catch (FVTUnexpectedCondition testCaseError) {
                    throw testCaseError;
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private String createConnectorType(ConnectionExchangeClient client, String assetManagerGUID, String connectionGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createConnectorType";
        try {
            ConnectorTypeProperties properties = new ConnectorTypeProperties();
            properties.setQualifiedName(connectorTypeName);
            properties.setDisplayName(connectorTypeDisplayName);
            properties.setDescription(connectorTypeDescription);
            properties.setConnectorProviderClassName(connectorProviderClassName);
            properties.setEffectiveFrom(effectiveFrom);
            properties.setEffectiveTo(effectiveTo);
            String connectorTypeGUID = client.createConnectorType(userId, assetManagerGUID, assetManagerName, true, externalIdProperties, properties);
            if (connectorTypeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createConnectorType(no GUID for connectorTypeCreate)");
            }
            if (connectionGUID != null) {
                client.setupConnectorType(userId, assetManagerGUID, assetManagerName, true, connectionGUID, connectorTypeGUID, effectiveFrom, effectiveTo, effectiveTime, false, false);
            }
            this.checkConnectorTypeOK(client, assetManagerGUID, connectorTypeGUID, connectionGUID, "createConnectorType", userId);
            return connectorTypeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createConnectorType", (Throwable)unexpectedError);
        }
    }
}

