/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.fvt.glossaries;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.GlossaryManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.fvt.common.AssetManagerTestBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateManagementGlossaryTest
extends AssetManagerTestBase {
    private static final String testCaseName = "CreateManagementGlossaryTest";
    private static final int maxPageSize = 100;
    private static final String glossaryName = "ManagementTestGlossaryCreate";
    private static final String glossaryDisplayName = "ManagementGlossary displayName";
    private static final String glossaryDescription = "ManagementGlossary description";
    private static final String glossaryUsage = "ManagementGlossary usage";
    private static final String glossaryLanguage = "ManagementGlossary language";
    private static final String glossaryCategoryName = "ManagementTestGlossaryCreateCategory";
    private static final String glossaryCategoryDisplayName = "ManagementGlossaryCategory displayName";
    private static final String glossaryCategoryDescription = "ManagementGlossaryCategory description";
    private static final String glossaryTermName = "ManagementTestGlossaryCreateTerm";
    private static final String glossaryTermDisplayName = "ManagementGlossaryTerm displayName";
    private static final String glossaryTermDescription = "ManagementGlossaryTerm description";
    private static final String controlledGlossaryTermName = "ManagementTestGlossaryCreateControlledTerm";
    private static final String controlledGlossaryTermDisplayName = "ManagementControlledGlossaryTerm displayName";
    private static final String controlledGlossaryTermDescription = "ManagementControlledGlossaryTerm description";
    private static final String controlledGlossaryTermStatus = "Truly Awesome";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateManagementGlossaryTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateManagementGlossaryTest thisTest = new CreateManagementGlossaryTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        GlossaryManagementClient client = thisTest.getGlossaryManagementClient(serverName, serverPlatformRootURL, auditLog, testCaseName);
        String activityName = "getGlossary(ManagementTestGlossaryCreate)";
        String glossaryGUID = thisTest.getGlossary(client, testCaseName, activityName, userId, glossaryName, glossaryDisplayName, glossaryDescription, glossaryUsage, glossaryLanguage);
        try {
            GlossaryElement glossaryElement = client.getGlossaryByGUID(userId, glossaryGUID, null, false, false);
            if (glossaryElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no glossary element)");
            }
            if (glossaryElement.getElementHeader() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no glossary header) " + glossaryElement.toString());
            }
            if (glossaryElement.getGlossaryProperties() == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no glossary properties) " + glossaryElement.toString());
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        String glossaryCategoryGUID = thisTest.getGlossaryCategory(client, glossaryGUID, userId);
        String glossaryTermGUID = thisTest.getGlossaryTerm(client, glossaryGUID, userId);
        String controlledGlossaryTermGUID = thisTest.getControlledGlossaryTerm(client, glossaryGUID, userId);
        thisTest.addTermToCategory(client, glossaryCategoryGUID, glossaryTermGUID, userId, "GlossaryTerm", glossaryTermName, glossaryTermDisplayName, glossaryTermDescription, null, ElementStatus.ACTIVE);
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        extendedProperties.put("userDefinedStatus", controlledGlossaryTermStatus);
        thisTest.addTermToCategory(client, glossaryCategoryGUID, controlledGlossaryTermGUID, userId, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.DRAFT);
        activityName = "Bad property(ManagementTestGlossaryCreate)";
        try {
            GlossaryTermProperties properties = new GlossaryTermProperties();
            extendedProperties = new HashMap();
            extendedProperties.put("badPropertyName", controlledGlossaryTermStatus);
            properties.setQualifiedName(controlledGlossaryTermName);
            properties.setDisplayName(controlledGlossaryTermDisplayName);
            properties.setDescription(controlledGlossaryTermDescription);
            properties.setExtendedProperties(extendedProperties);
            glossaryTermGUID = client.createControlledGlossaryTerm(userId, glossaryGUID, properties, GlossaryTermStatus.DRAFT, null, false, false);
            throw new FVTUnexpectedCondition(testCaseName, activityName + " (term created with invalid property " + glossaryTermGUID + ")");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " => " + glossaryGUID, (Throwable)unexpectedError);
        }
        try {
            client.removeGlossary(userId, glossaryGUID, null, false, false);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + " => " + glossaryGUID, (Throwable)unexpectedError);
        }
        try {
            client.getGlossaryByGUID(userId, glossaryGUID, null, false, false);
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(glossary not deleted)");
        }
        catch (InvalidParameterException unexpectedError) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getGlossaryCategory(GlossaryManagementClient client, String glossaryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getGlossaryCategory";
        try {
            GlossaryCategoryProperties properties = new GlossaryCategoryProperties();
            properties.setQualifiedName(glossaryCategoryName);
            properties.setDisplayName(glossaryCategoryDisplayName);
            properties.setDescription(glossaryCategoryDescription);
            String glossaryCategoryGUID = client.createGlossaryCategory(userId, glossaryGUID, properties, true, null, false, false);
            if (glossaryCategoryGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GUID for schemaCreate)");
            }
            GlossaryCategoryElement retrievedElement = client.getGlossaryCategoryByGUID(userId, glossaryCategoryGUID, null, false, false);
            GlossaryCategoryProperties retrievedCategory = retrievedElement.getGlossaryCategoryProperties();
            if (retrievedCategory == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GlossaryCategory from Retrieve) " + retrievedElement.toString());
            }
            if (retrievedElement.getElementHeader() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no Header from Retrieve) " + retrievedElement.toString());
            }
            if (!glossaryCategoryName.equals(retrievedCategory.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad qualifiedName from Retrieve)");
            }
            if (!glossaryCategoryDisplayName.equals(retrievedCategory.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad displayName from Retrieve)");
            }
            if (!glossaryCategoryDescription.equals(retrievedCategory.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad description from Retrieve)");
            }
            List glossaryCategoryList = client.getGlossaryCategoriesByName(userId, null, glossaryCategoryName, 0, 100, null, false, false);
            if (glossaryCategoryList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(no GlossaryCategory for RetrieveByName)");
            }
            if (glossaryCategoryList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Empty GlossaryCategory list for RetrieveByName)");
            }
            if (glossaryCategoryList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(GlossaryCategory list for RetrieveByName contains" + glossaryCategoryList.size() + " elements)");
            }
            retrievedElement = (GlossaryCategoryElement)glossaryCategoryList.get(0);
            retrievedCategory = retrievedElement.getGlossaryCategoryProperties();
            if (!glossaryCategoryName.equals(retrievedCategory.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad qualifiedName from RetrieveByName)");
            }
            if (!glossaryCategoryDisplayName.equals(retrievedCategory.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad displayName from RetrieveByName)");
            }
            if (!glossaryCategoryDescription.equals(retrievedCategory.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory(Bad description from RetrieveByName)");
            }
            return glossaryCategoryGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getGlossaryCategory", (Throwable)unexpectedError);
        }
    }

    private void addTermToCategory(GlossaryManagementClient client, String glossaryCategoryGUID, String glossaryTermGUID, String userId, String typeName, String qualifiedName, String displayName, String description, Map<String, Object> extendedProperties, ElementStatus status) throws FVTUnexpectedCondition {
        String activityName = "addTermToCategory";
        try {
            GlossaryTermCategorization categorizationProperties = new GlossaryTermCategorization();
            categorizationProperties.setDescription("Category for " + glossaryTermGUID);
            categorizationProperties.setStatus(GlossaryTermRelationshipStatus.ACTIVE);
            client.setupTermCategory(userId, glossaryCategoryGUID, glossaryTermGUID, categorizationProperties, null, false, false);
            List glossaryTermList = client.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, null, 0, 0, null, false, false);
            this.validateGlossaryTermElements(testCaseName, "addTermToCategory", "RetrieveByCategory", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, extendedProperties, status);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "addTermToCategory", (Throwable)unexpectedError);
        }
    }

    private String getGlossaryTerm(GlossaryManagementClient client, String glossaryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getGlossaryTerm";
        try {
            GlossaryTermProperties properties = new GlossaryTermProperties();
            properties.setQualifiedName(glossaryTermName);
            properties.setDisplayName(glossaryTermDisplayName);
            properties.setDescription(glossaryTermDescription);
            HashMap<String, String> mappingProperties = new HashMap<String, String>();
            mappingProperties.put("prop1", "One");
            mappingProperties.put("prop2", "Two");
            String glossaryTermGUID = client.createGlossaryTerm(userId, glossaryGUID, properties, null, false, false);
            if (glossaryTermGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm(no GUID for GlossaryTerm Create)");
            }
            this.validateGlossaryTerm(client, userId, "getGlossaryTerm", glossaryGUID, glossaryTermGUID, "GlossaryTerm", glossaryTermName, glossaryTermDisplayName, glossaryTermDescription, null, ElementStatus.ACTIVE);
            return glossaryTermGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getGlossaryTerm", (Throwable)unexpectedError);
        }
    }

    private String getControlledGlossaryTerm(GlossaryManagementClient client, String glossaryGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getControlledGlossaryTerm";
        try {
            GlossaryTermProperties properties = new GlossaryTermProperties();
            HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
            extendedProperties.put("userDefinedStatus", controlledGlossaryTermStatus);
            properties.setQualifiedName(controlledGlossaryTermName);
            properties.setDisplayName(controlledGlossaryTermDisplayName);
            properties.setDescription(controlledGlossaryTermDescription);
            properties.setExtendedProperties(extendedProperties);
            String glossaryTermGUID = client.createControlledGlossaryTerm(userId, glossaryGUID, properties, GlossaryTermStatus.DRAFT, null, false, false);
            if (glossaryTermGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getControlledGlossaryTerm(no GUID for ControlledGlossaryTerm Create)");
            }
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.DRAFT);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.PROPOSED, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.PROPOSED);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.APPROVED, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.APPROVED);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.ACTIVE, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.ACTIVE);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.PREPARED, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.PREPARED);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.REJECTED, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.REJECTED);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.OTHER, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.OTHER);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.DEPRECATED, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.DEPRECATED);
            client.updateGlossaryTermStatus(userId, glossaryTermGUID, GlossaryTermStatus.DRAFT, null, false, false);
            this.validateGlossaryTerm(client, userId, "getControlledGlossaryTerm", glossaryGUID, glossaryTermGUID, "ControlledGlossaryTerm", controlledGlossaryTermName, controlledGlossaryTermDisplayName, controlledGlossaryTermDescription, extendedProperties, ElementStatus.DRAFT);
            return glossaryTermGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getControlledGlossaryTerm", (Throwable)unexpectedError);
        }
    }

    private void validateGlossaryTerm(GlossaryManagementClient client, String userId, String activityName, String glossaryGUID, String glossaryTermGUID, String typeName, String qualifiedName, String displayName, String description, Map<String, Object> extendedProperties, ElementStatus status) throws FVTUnexpectedCondition {
        try {
            GlossaryTermElement retrievedElement = client.getGlossaryTermByGUID(userId, glossaryTermGUID, null, false, false);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GlossaryTerm from Retrieve)");
            }
            this.validateGlossaryTermElement(testCaseName, activityName, "Retrieve", retrievedElement, glossaryTermGUID, typeName, qualifiedName, displayName, description, extendedProperties, status);
            List glossaryTermList = client.getGlossaryTermsByName(userId, null, qualifiedName, null, 0, 100, null, false, false);
            this.validateGlossaryTermElements(testCaseName, activityName, "RetrieveByQualifiedName", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, extendedProperties, status);
            glossaryTermList = client.getGlossaryTermsByName(userId, null, displayName, null, 0, 0, null, false, false);
            this.validateGlossaryTermElements(testCaseName, activityName, "RetrieveTermsByGlossary", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, extendedProperties, status);
            glossaryTermList = client.getTermsForGlossary(userId, glossaryGUID, 0, 0, null, false, false);
            this.validateGlossaryTermElements(testCaseName, activityName, "RetrieveTermsByGlossary", glossaryTermList, glossaryTermGUID, typeName, qualifiedName, displayName, description, extendedProperties, status);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }
}

