/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GlossaryConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GlossaryTermConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalGlossaryLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryElementLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermActivityType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermContextDefinition;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationship;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryExchangeHandler
extends ExchangeHandlerBase {
    private GlossaryHandler<GlossaryElement> glossaryHandler;
    private GlossaryCategoryHandler<GlossaryCategoryElement> glossaryCategoryHandler;
    private GlossaryTermHandler<GlossaryTermElement> glossaryTermHandler;
    private static final String glossaryGUIDParameterName = "glossaryGUID";
    private static final String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
    private static final String glossaryTermGUIDParameterName = "glossaryTermGUID";

    public GlossaryExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryHandler = new GlossaryHandler(new GlossaryConverter(repositoryHelper, serviceName, serverName), GlossaryElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryCategoryHandler = new GlossaryCategoryHandler(new GlossaryConverter(repositoryHelper, serviceName, serverName), GlossaryCategoryElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryTermHandler = new GlossaryTermHandler(new GlossaryTermConverter(repositoryHelper, serviceName, serverName), GlossaryTermElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToGlossaries(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), glossaryGUIDParameterName, "Glossary", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryCategoryElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), glossaryCategoryGUIDParameterName, "GlossaryCategory", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryTermElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), glossaryTermGUIDParameterName, "GlossaryTerm", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    public String createGlossary(String userId, MetadataCorrelationProperties correlationProperties, GlossaryProperties glossaryProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", methodName);
        String glossaryGUID = this.glossaryHandler.createGlossary(userId, glossaryProperties.getQualifiedName(), glossaryProperties.getDisplayName(), glossaryProperties.getDescription(), glossaryProperties.getLanguage(), glossaryProperties.getUsage(), glossaryProperties.getAdditionalProperties(), glossaryProperties.getTypeName(), glossaryProperties.getExtendedProperties(), methodName);
        if (glossaryGUID != null) {
            this.createExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        }
        return glossaryGUID;
    }

    public String createGlossaryFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryGUID = this.glossaryHandler.createGlossaryFromTemplate(userId, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (glossaryGUID != null) {
            this.createExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        }
        return glossaryGUID;
    }

    public void updateGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, GlossaryProperties glossaryProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        this.glossaryHandler.updateGlossary(userId, glossaryGUID, glossaryGUIDParameterName, glossaryProperties.getQualifiedName(), glossaryProperties.getDisplayName(), glossaryProperties.getDescription(), glossaryProperties.getLanguage(), glossaryProperties.getUsage(), glossaryProperties.getAdditionalProperties(), glossaryProperties.getTypeName(), glossaryProperties.getExtendedProperties(), methodName);
    }

    public void removeGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        this.glossaryHandler.removeGlossary(userId, glossaryGUID, glossaryGUIDParameterName, methodName);
    }

    public void setGlossaryAsTaxonomy(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String organizingPrinciple, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        this.glossaryHandler.addTaxonomyClassificationToGlossary(userId, glossaryGUID, glossaryGUIDParameterName, organizingPrinciple, methodName);
    }

    public void clearGlossaryAsTaxonomy(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        this.glossaryHandler.removeTaxonomyClassificationFromGlossary(userId, glossaryGUID, glossaryGUIDParameterName, methodName);
    }

    public void setGlossaryAsCanonical(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String scope, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        this.glossaryHandler.addCanonicalVocabClassificationToGlossary(userId, glossaryGUID, glossaryGUIDParameterName, scope, methodName);
    }

    public void clearGlossaryAsCanonical(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, methodName);
        this.glossaryHandler.removeCanonicalVocabClassificationFromGlossary(userId, glossaryGUID, glossaryGUIDParameterName, methodName);
    }

    public List<GlossaryElement> findGlossaries(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryHandler.findGlossaries(userId, searchString, searchStringParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaries(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryElement> getGlossariesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryHandler.getGlossariesByName(userId, name, nameParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaries(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryElement> getGlossariesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String glossaryEntityParameterName = "glossaryEntity";
        String glossaryGUIDParameterName = "glossaryEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        ArrayList<GlossaryElement> results = new ArrayList<GlossaryElement>();
        List glossaryEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", "SoftwareServerCapability", "Glossary", startFrom, pageSize, methodName);
        if (glossaryEntities != null) {
            for (EntityDetail glossaryEntity : glossaryEntities) {
                GlossaryElement glossaryElement;
                if (glossaryEntity == null || (glossaryElement = (GlossaryElement)this.glossaryHandler.getBeanFromEntity(userId, glossaryEntity, "glossaryEntity", methodName)) == null) continue;
                glossaryElement.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryEntity.getGUID(), "glossaryEntity.getGUID()", "Glossary", assetManagerGUID, assetManagerName, methodName));
                results.add(glossaryElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public GlossaryElement getGlossaryByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        GlossaryElement glossary = (GlossaryElement)this.glossaryHandler.getGlossaryByGUID(userId, openMetadataGUID, "openMetadataGUID", methodName);
        if (glossary != null) {
            glossary.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "Glossary", assetManagerGUID, assetManagerName, methodName));
        }
        return glossary;
    }

    public String createGlossaryCategory(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, GlossaryCategoryProperties glossaryCategoryProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", methodName);
        String glossaryCategoryGUID = this.glossaryCategoryHandler.createGlossaryCategory(userId, glossaryGUID, glossaryGUIDParameterName, glossaryCategoryProperties.getQualifiedName(), glossaryCategoryProperties.getDisplayName(), glossaryCategoryProperties.getDescription(), glossaryCategoryProperties.getAdditionalProperties(), glossaryCategoryProperties.getTypeName(), glossaryCategoryProperties.getExtendedProperties(), methodName);
        if (glossaryCategoryGUID != null) {
            this.createExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, methodName);
        }
        return glossaryCategoryGUID;
    }

    public String createGlossaryCategoryFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryCategoryGUID = this.glossaryCategoryHandler.createGlossaryCategoryFromTemplate(userId, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (glossaryCategoryGUID != null) {
            this.createExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, methodName);
        }
        return glossaryCategoryGUID;
    }

    public void updateGlossaryCategory(String userId, MetadataCorrelationProperties correlationProperties, String glossaryCategoryGUID, GlossaryCategoryProperties glossaryCategoryProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, methodName);
        this.glossaryCategoryHandler.updateGlossaryCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryCategoryProperties.getQualifiedName(), glossaryCategoryProperties.getDisplayName(), glossaryCategoryProperties.getDescription(), glossaryCategoryProperties.getAdditionalProperties(), glossaryCategoryProperties.getTypeName(), glossaryCategoryProperties.getExtendedProperties(), methodName);
    }

    public void setupCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryParentCategoryGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildCategoryGUIDParameterName = "glossaryChildCategoryGUID";
        this.glossaryCategoryHandler.setupCategoryParent(userId, glossaryParentCategoryGUID, "glossaryParentCategoryGUID", glossaryChildCategoryGUID, "glossaryChildCategoryGUID", methodName);
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, "CategoryHierarchyLink", glossaryParentCategoryGUID, "GlossaryCategory", glossaryChildCategoryGUID, "GlossaryCategory", methodName);
    }

    public void clearCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryParentCategoryGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildCategoryGUIDParameterName = "glossaryChildCategoryGUID";
        this.glossaryCategoryHandler.clearCategoryParent(userId, glossaryParentCategoryGUID, "glossaryParentCategoryGUID", glossaryChildCategoryGUID, "glossaryChildCategoryGUID", methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, "CategoryHierarchyLink", glossaryParentCategoryGUID, "GlossaryCategory", glossaryChildCategoryGUID, "GlossaryCategory", methodName);
    }

    public void removeGlossaryCategory(String userId, MetadataCorrelationProperties correlationProperties, String glossaryCategoryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validateExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, methodName);
        this.glossaryCategoryHandler.removeGlossaryCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.findGlossaryCategories(userId, searchString, searchStringParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryCategoryElement> getCategoriesForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getCategoriesForGlossary(userId, glossaryGUID, glossaryGUIDParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getGlossaryCategoriesByName(userId, name, nameParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public GlossaryCategoryElement getGlossaryCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GlossaryCategoryElement glossaryCategory = (GlossaryCategoryElement)this.glossaryCategoryHandler.getGlossaryCategoryParent(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        if (glossaryCategory != null) {
            glossaryCategory.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", assetManagerGUID, assetManagerName, methodName));
        }
        return glossaryCategory;
    }

    public List<GlossaryCategoryElement> getGlossarySubCategories(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getGlossarySubCategories(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public GlossaryCategoryElement getGlossaryCategoryByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        GlossaryCategoryElement glossaryCategory = (GlossaryCategoryElement)this.glossaryCategoryHandler.getGlossaryCategoryByGUID(userId, openMetadataGUID, "openMetadataGUID", methodName);
        if (glossaryCategory != null) {
            glossaryCategory.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "GlossaryCategory", assetManagerGUID, assetManagerName, methodName));
        }
        return glossaryCategory;
    }

    public String createGlossaryTerm(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, GlossaryTermProperties glossaryTermProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        String glossaryTermGUID = this.glossaryTermHandler.createGlossaryTerm(userId, glossaryGUID, glossaryGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getAdditionalProperties(), glossaryTermProperties.getTypeName(), glossaryTermProperties.getExtendedProperties(), InstanceStatus.ACTIVE, methodName);
        if (glossaryTermGUID != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        }
        return glossaryTermGUID;
    }

    private InstanceStatus getInstanceStatus(GlossaryTermStatus status) {
        if (status != null) {
            switch (status) {
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
            }
        }
        return InstanceStatus.UNKNOWN;
    }

    public String createControlledGlossaryTerm(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, GlossaryTermProperties glossaryTermProperties, GlossaryTermStatus initialStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermGUID;
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        String initialStatusParameterName = "initialStatus";
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateObject((Object)initialStatus, "initialStatus", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        String typeName = "ControlledGlossaryTerm";
        if (glossaryTermProperties.getTypeName() != null) {
            typeName = glossaryTermProperties.getTypeName();
        }
        if ((glossaryTermGUID = this.glossaryTermHandler.createGlossaryTerm(userId, glossaryGUID, glossaryGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getAdditionalProperties(), typeName, glossaryTermProperties.getExtendedProperties(), this.getInstanceStatus(initialStatus), methodName)) != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        }
        return glossaryTermGUID;
    }

    public String createGlossaryTermFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryTermGUID = this.glossaryTermHandler.createGlossaryTermFromTemplate(userId, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (glossaryTermGUID != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        }
        return glossaryTermGUID;
    }

    public void updateGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermProperties glossaryTermProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.updateGlossaryTerm(userId, glossaryTermGUID, glossaryTermGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getAdditionalProperties(), "GlossaryTerm", glossaryTermProperties.getExtendedProperties(), methodName);
    }

    public void updateGlossaryTermStatus(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermStatus glossaryTermStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermStatusParameterName = "glossaryTermStatus";
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryTermStatus, "glossaryTermStatus", methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.updateGlossaryTermStatus(userId, glossaryTermGUID, glossaryTermGUIDParameterName, this.getInstanceStatus(glossaryTermStatus), "glossaryTermStatus", methodName);
    }

    private int getTermRelationshipStatus(GlossaryTermRelationshipStatus status) {
        if (status != null) {
            return status.getOpenTypeOrdinal();
        }
        return GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal();
    }

    public void setupTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, GlossaryTermCategorization categorizationProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryCategoryGUIDParameterName = glossaryCategoryGUIDParameterName;
        String glossaryTermGUIDParameterName = glossaryTermGUIDParameterName;
        if (categorizationProperties != null) {
            this.glossaryTermHandler.setupTermCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryTermGUID, glossaryTermGUIDParameterName, categorizationProperties.getDescription(), this.getTermRelationshipStatus(categorizationProperties.getStatus()), methodName);
        } else {
            this.glossaryTermHandler.setupTermCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryTermGUID, glossaryTermGUIDParameterName, null, GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal(), methodName);
        }
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, "TermCategorization", glossaryCategoryGUID, "GlossaryCategory", glossaryTermGUID, "GlossaryTerm", methodName);
    }

    public void clearTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryCategoryGUIDParameterName = glossaryCategoryGUIDParameterName;
        String glossaryTermGUIDParameterName = glossaryTermGUIDParameterName;
        this.glossaryTermHandler.clearTermCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, "TermCategorization", glossaryCategoryGUID, "GlossaryCategory", glossaryTermGUID, "GlossaryTerm", methodName);
    }

    public void setupTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermOneGUIDParameterName = "glossaryTermOneGUID";
        String glossaryTermTwoGUIDParameterName = "glossaryTermTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        if (relationshipsProperties != null) {
            this.glossaryTermHandler.setupTermRelationship(userId, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", relationshipsProperties.getExpression(), relationshipsProperties.getDescription(), this.getTermRelationshipStatus(relationshipsProperties.getStatus()), relationshipsProperties.getSteward(), relationshipsProperties.getSource(), methodName);
        } else {
            this.glossaryTermHandler.setupTermRelationship(userId, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", null, null, GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal(), null, null, methodName);
        }
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, relationshipTypeName, glossaryTermOneGUID, "GlossaryTerm", glossaryTermTwoGUID, "GlossaryTerm", methodName);
    }

    public void updateTermRelationship(String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermOneGUIDParameterName = "glossaryTermOneGUID";
        String glossaryTermTwoGUIDParameterName = "glossaryTermTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        if (relationshipsProperties != null) {
            this.glossaryTermHandler.updateTermRelationship(userId, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", relationshipsProperties.getExpression(), relationshipsProperties.getDescription(), this.getTermRelationshipStatus(relationshipsProperties.getStatus()), relationshipsProperties.getSteward(), relationshipsProperties.getSource(), methodName);
        } else {
            this.glossaryTermHandler.updateTermRelationship(userId, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", null, null, GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal(), null, null, methodName);
        }
    }

    public void clearTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermOneGUIDParameterName = "glossaryTermOneGUID";
        String glossaryTermTwoGUIDParameterName = "glossaryTermTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.glossaryTermHandler.clearTermRelationship(userId, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, relationshipTypeName, glossaryTermOneGUID, "GlossaryTerm", glossaryTermTwoGUID, "GlossaryTerm", methodName);
    }

    public void setTermAsAbstractConcept(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.setTermAsAbstractConcept(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void clearTermAsAbstractConcept(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.clearTermAsAbstractConcept(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void setTermAsDataValue(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.setTermAsDataValue(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void clearTermAsDataValue(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.clearTermAsDataValue(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    private int getActivityType(GlossaryTermActivityType activityType) {
        if (activityType != null) {
            return activityType.getOpenTypeOrdinal();
        }
        return GlossaryTermActivityType.ACTION.getOpenTypeOrdinal();
    }

    public void setTermAsActivity(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermActivityType activityType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.setTermAsActivity(userId, glossaryTermGUID, glossaryTermGUIDParameterName, this.getActivityType(activityType), methodName);
    }

    public void clearTermAsActivity(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.clearTermAsActivity(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void setTermAsContext(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermContextDefinition contextDefinition, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        if (contextDefinition != null) {
            this.glossaryTermHandler.setTermAsContext(userId, glossaryTermGUID, glossaryTermGUIDParameterName, contextDefinition.getDescription(), contextDefinition.getScope(), methodName);
        } else {
            this.glossaryTermHandler.setTermAsContext(userId, glossaryTermGUID, glossaryTermGUIDParameterName, null, null, methodName);
        }
    }

    public void clearTermAsContext(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.clearTermAsContext(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void setTermAsSpineObject(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.setTermAsSpineObject(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void clearTermAsSpineObject(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.clearTermAsSpineObject(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void setTermAsSpineAttribute(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.setTermAsSpineAttribute(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void clearTermAsSpineAttribute(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.clearTermAsSpineAttribute(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void setTermAsObjectIdentifier(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.setTermAsObjectIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void clearTermAsObjectIdentifier(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.clearTermAsObjectIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public void removeGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, methodName);
        this.glossaryTermHandler.removeGlossaryTerm(userId, glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
    }

    public List<GlossaryTermElement> findGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.findTerms(userId, searchString, searchStringParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryTermElement> getTermsForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsForGlossary(userId, glossaryGUID, glossaryGUIDParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryTermElement> getTermsForGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsByName(userId, name, nameParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public GlossaryTermElement getGlossaryTermByGUID(String userId, String assetManagerGUID, String assetManagerName, String guid, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        GlossaryTermElement glossaryTerm = (GlossaryTermElement)this.glossaryTermHandler.getTerm(userId, guid, "guid", methodName);
        if (glossaryTerm != null) {
            glossaryTerm.setCorrelationHeaders(this.getCorrelationProperties(userId, guid, "guid", "GlossaryTerm", assetManagerGUID, assetManagerName, methodName));
        }
        return glossaryTerm;
    }

    public String createExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, ExternalGlossaryLinkProperties linkProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, ExternalGlossaryLinkProperties linkProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void attachExternalLinkToGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String externalLinkGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void detachExternalLinkFromGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String externalLinkGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<ExternalGlossaryLinkElement> getExternalLinksForGlossary(String userId, String glossaryGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<GlossaryElement> getGlossariesForExternalLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void attachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String externalLinkGUID, ExternalGlossaryElementLinkProperties linkProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void detachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String externalLinkGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void attachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String externalLinkGUID, ExternalGlossaryElementLinkProperties linkProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void detachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String externalLinkGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }
}

