/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.GlossaryExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ActivityTermClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CanonicalVocabularyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CategorizationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ContextDefinitionClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryElementLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TaxonomyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class GlossaryExchangeRESTServices {
    private static AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryExchangeRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGlossary(String serverName, String userId, GlossaryRequestBody requestBody) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossary");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossary");
                response.setGUID(handler.createGlossary(userId, requestBody.getMetadataCorrelationProperties(), requestBody.getElementProperties(), "createGlossary"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossary", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryFromTemplate");
                response.setGUID(handler.createGlossaryFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), templateGUID, requestBody.getElementProperties(), "createGlossaryFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createGlossaryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossary(String serverName, String userId, String glossaryGUID, GlossaryRequestBody requestBody) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossary");
                handler.updateGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, requestBody.getElementProperties(), "updateGlossary");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossary", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossary(String serverName, String userId, String glossaryGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeGlossary");
            handler.removeGlossary(userId, requestBody, glossaryGUID, "removeGlossary");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsTaxonomy(String serverName, String userId, String glossaryGUID, TaxonomyClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsTaxonomy");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsTaxonomy");
                handler.setGlossaryAsTaxonomy(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, requestBody.getOrganizingPrinciple(), "setGlossaryAsTaxonomy");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsTaxonomy", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsTaxonomy(String serverName, String userId, String glossaryGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsTaxonomy");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearGlossaryAsTaxonomy");
            handler.clearGlossaryAsTaxonomy(userId, requestBody, glossaryGUID, "clearGlossaryAsTaxonomy");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsCanonical(String serverName, String userId, String glossaryGUID, CanonicalVocabularyClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsCanonical");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsCanonical");
                handler.setGlossaryAsCanonical(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, requestBody.getScope(), "setGlossaryAsCanonical");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsCanonical", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsCanonical(String serverName, String userId, String glossaryGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsCanonical");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearGlossaryAsCanonical");
            handler.clearGlossaryAsCanonical(userId, requestBody, glossaryGUID, "clearGlossaryAsCanonical");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse findGlossaries(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGlossaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaries");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaries");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "findGlossaries");
                response.setElementList(handler.findGlossaries(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, "findGlossaries"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGlossaries", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findGlossaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGlossariesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossariesByName");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesByName");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossariesByName");
                response.setElementList(handler.getGlossariesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, "getGlossariesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGlossariesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossariesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesForAssetManager(String serverName, String userId, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getGlossariesForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossariesForAssetManager");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesForAssetManager");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossariesForAssetManager");
            if (requestBody != null) {
                response.setElementList(handler.getGlossariesForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, "getGlossariesForAssetManager"));
            } else {
                response.setElementList(handler.getGlossariesForAssetManager(userId, null, null, startFrom, pageSize, "getGlossariesForAssetManager"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossariesForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryByGUID(String serverName, String userId, String openMetadataGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getGlossaryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryByGUID");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryByGUID");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), openMetadataGUID, "getGlossaryByGUID"));
            } else {
                response.setElement(handler.getGlossaryByGUID(userId, null, null, openMetadataGUID, "getGlossaryByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossaryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategory(String serverName, String userId, String glossaryGUID, GlossaryCategoryRequestBody requestBody) {
        String methodName = "createGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryCategory");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategory");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryCategory");
                response.setGUID(handler.createGlossaryCategory(userId, glossaryGUID, requestBody.getMetadataCorrelationProperties(), requestBody.getElementProperties(), "createGlossaryCategory"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategory", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategoryFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryCategoryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryCategoryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategoryFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryCategoryFromTemplate");
                response.setGUID(handler.createGlossaryCategoryFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), templateGUID, requestBody.getElementProperties(), "createGlossaryCategoryFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategoryFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createGlossaryCategoryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, GlossaryCategoryRequestBody requestBody) {
        String methodName = "updateGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryCategory");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossaryCategory");
                handler.updateGlossaryCategory(userId, requestBody.getMetadataCorrelationProperties(), glossaryCategoryGUID, requestBody.getElementProperties(), "updateGlossaryCategory");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryCategory", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCategoryParent(String serverName, String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "setupCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupCategoryParent");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setupCategoryParent");
            if (requestBody != null) {
                handler.setupCategoryParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryParentCategoryGUID, glossaryChildCategoryGUID, "setupCategoryParent");
            } else {
                handler.setupCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, "setupCategoryParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCategoryParent(String serverName, String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCategoryParent");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearCategoryParent");
            if (requestBody != null) {
                handler.clearCategoryParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryParentCategoryGUID, glossaryChildCategoryGUID, "clearCategoryParent");
            } else {
                handler.clearCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, "clearCategoryParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryCategory");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeGlossaryCategory");
            handler.removeGlossaryCategory(userId, requestBody, glossaryCategoryGUID, "removeGlossaryCategory");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse findGlossaryCategories(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGlossaryCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaryCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryCategories");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "findGlossaryCategories");
                response.setElementList(handler.findGlossaryCategories(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, "findGlossaryCategories"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGlossaryCategories", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findGlossaryCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getCategoriesForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoriesForGlossary");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getCategoriesForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, startFrom, pageSize, "getCategoriesForGlossary"));
            } else {
                response.setElementList(handler.getCategoriesForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, "getCategoriesForGlossary"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getCategoriesForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGlossaryCategoriesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoriesByName");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoriesByName");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryCategoriesByName");
                response.setElementList(handler.getGlossaryCategoriesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, "getGlossaryCategoriesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGlossaryCategoriesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossaryCategoriesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(String serverName, String userId, String glossaryCategoryGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getGlossaryCategoryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoryByGUID");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryByGUID");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryCategoryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, "getGlossaryCategoryByGUID"));
            } else {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, null, null, glossaryCategoryGUID, "getGlossaryCategoryByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossaryCategoryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryParent(String serverName, String userId, String glossaryCategoryGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getGlossaryCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoryParent");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryParent");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryCategoryParent");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, "getGlossaryCategoryParent"));
            } else {
                response.setElement(handler.getGlossaryCategoryParent(userId, null, null, glossaryCategoryGUID, "getGlossaryCategoryParent"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossaryCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossarySubCategories(String serverName, String userId, String glossaryCategoryGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getGlossarySubCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossarySubCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossarySubCategories");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossarySubCategories");
            if (requestBody != null) {
                response.setElementList(handler.getGlossarySubCategories(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, startFrom, pageSize, "getGlossarySubCategories"));
            } else {
                response.setElementList(handler.getGlossarySubCategories(userId, null, null, glossaryCategoryGUID, startFrom, pageSize, "getGlossarySubCategories"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossarySubCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryTerm(String serverName, String userId, String glossaryGUID, GlossaryTermRequestBody requestBody) {
        String methodName = "createGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryTerm");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryTerm");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryTerm");
                response.setGUID(handler.createGlossaryTerm(userId, glossaryGUID, requestBody.getMetadataCorrelationProperties(), requestBody.getElementProperties(), "createGlossaryTerm"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createControlledGlossaryTerm(String serverName, String userId, String glossaryGUID, ControlledGlossaryTermRequestBody requestBody) {
        String methodName = "createControlledGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createControlledGlossaryTerm");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createControlledGlossaryTerm");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createControlledGlossaryTerm");
                response.setGUID(handler.createControlledGlossaryTerm(userId, glossaryGUID, requestBody.getMetadataCorrelationProperties(), requestBody.getElementProperties(), requestBody.getInitialStatus(), "createControlledGlossaryTerm"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createControlledGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createControlledGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryTermFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryTermFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryTermFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryTermFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryTermFromTemplate");
                response.setGUID(handler.createGlossaryTermFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), templateGUID, requestBody.getElementProperties(), "createGlossaryTermFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryTermFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createGlossaryTermFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTerm(String serverName, String userId, String glossaryTermGUID, GlossaryTermRequestBody requestBody) {
        String methodName = "updateGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTerm");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossaryTerm");
                handler.updateGlossaryTerm(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getElementProperties(), "updateGlossaryTerm");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTermStatus(String serverName, String userId, String glossaryTermGUID, GlossaryTermStatusRequestBody requestBody) {
        String methodName = "updateGlossaryTermStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTermStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTermStatus");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossaryTermStatus");
                handler.updateGlossaryTermStatus(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getGlossaryTermStatus(), "updateGlossaryTermStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTermStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateGlossaryTermStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermCategory(String serverName, String userId, String glossaryCategoryGUID, String glossaryTermGUID, CategorizationRequestBody requestBody) {
        String methodName = "setupTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermCategory");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setupTermCategory");
                handler.setupTermCategory(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, glossaryTermGUID, requestBody.getCategorizationProperties(), "setupTermCategory");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupTermCategory", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermCategory(String serverName, String userId, String glossaryCategoryGUID, String glossaryTermGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermCategory");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermCategory");
            if (requestBody != null) {
                handler.clearTermCategory(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, glossaryTermGUID, "clearTermCategory");
            } else {
                handler.clearTermCategory(userId, null, null, glossaryCategoryGUID, glossaryTermGUID, "clearTermCategory");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, TermRelationshipRequestBody requestBody) {
        String methodName = "setupTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermRelationship");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setupTermRelationship");
                handler.setupTermRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, requestBody.getProperties(), "setupTermRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupTermRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, TermRelationshipRequestBody requestBody) {
        String methodName = "updateTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTermRelationship");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateTermRelationship");
                handler.updateTermRelationship(userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, requestBody.getProperties(), "updateTermRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTermRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermRelationship");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermRelationship");
            if (requestBody != null) {
                handler.clearTermRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, "clearTermRelationship");
            } else {
                handler.clearTermRelationship(userId, null, null, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, "clearTermRelationship");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsAbstractConcept(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsAbstractConcept");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsAbstractConcept");
            handler.setTermAsAbstractConcept(userId, requestBody, glossaryTermGUID, "setTermAsAbstractConcept");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsAbstractConcept(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsAbstractConcept");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsAbstractConcept");
            handler.clearTermAsAbstractConcept(userId, requestBody, glossaryTermGUID, "clearTermAsAbstractConcept");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsDataValue(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsDataValue");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsDataValue");
            handler.setTermAsDataValue(userId, requestBody, glossaryTermGUID, "setTermAsDataValue");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsDataValue(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsDataValue");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsDataValue");
            handler.clearTermAsDataValue(userId, requestBody, glossaryTermGUID, "clearTermAsDataValue");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsActivity(String serverName, String userId, String glossaryTermGUID, ActivityTermClassificationRequestBody requestBody) {
        String methodName = "setTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsActivity");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsActivity");
                handler.setTermAsActivity(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getActivityType(), "setTermAsActivity");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsActivity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsActivity(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsActivity");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsActivity");
            handler.clearTermAsActivity(userId, requestBody, glossaryTermGUID, "clearTermAsActivity");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsContext(String serverName, String userId, String glossaryTermGUID, ContextDefinitionClassificationRequestBody requestBody) {
        String methodName = "setTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsContext");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsContext");
                handler.setTermAsContext(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getContextDefinition(), "setTermAsContext");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsContext", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsContext(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsContext");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsContext");
            handler.clearTermAsContext(userId, requestBody, glossaryTermGUID, "clearTermAsContext");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineObject(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineObject");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsSpineObject");
            handler.setTermAsSpineObject(userId, requestBody, glossaryTermGUID, "setTermAsSpineObject");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineObject(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineObject");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsSpineObject");
            handler.clearTermAsSpineObject(userId, requestBody, glossaryTermGUID, "clearTermAsSpineObject");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineAttribute(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineAttribute");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsSpineAttribute");
            handler.setTermAsSpineAttribute(userId, requestBody, glossaryTermGUID, "setTermAsSpineAttribute");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineAttribute(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineAttribute");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsSpineAttribute");
            handler.clearTermAsSpineAttribute(userId, requestBody, glossaryTermGUID, "clearTermAsSpineAttribute");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsObjectIdentifier(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsObjectIdentifier");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsObjectIdentifier");
            handler.setTermAsObjectIdentifier(userId, requestBody, glossaryTermGUID, "setTermAsObjectIdentifier");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsObjectIdentifier(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsObjectIdentifier");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsObjectIdentifier");
            handler.clearTermAsObjectIdentifier(userId, requestBody, glossaryTermGUID, "clearTermAsObjectIdentifier");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryTerm(String serverName, String userId, String glossaryTermGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryTerm");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeGlossaryTerm");
            handler.removeGlossaryTerm(userId, requestBody, glossaryTermGUID, "removeGlossaryTerm");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse findGlossaryTerms(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGlossaryTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaryTerms");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryTerms");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "findGlossaryTerms");
                response.setElementList(handler.findGlossaryTerms(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, "findGlossaryTerms"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGlossaryTerms", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findGlossaryTerms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getTermsForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermsForGlossary");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getTermsForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, startFrom, pageSize, "getTermsForGlossary"));
            } else {
                response.setElementList(handler.getTermsForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, "getTermsForGlossary"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getTermsForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getTermsForGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermsForGlossaryCategory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossaryCategory");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getTermsForGlossaryCategory");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, startFrom, pageSize, "getTermsForGlossaryCategory"));
            } else {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, null, null, glossaryCategoryGUID, startFrom, pageSize, "getTermsForGlossaryCategory"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getTermsForGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGlossaryTermsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermsByName");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermsByName");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryTermsByName");
                response.setElementList(handler.getGlossaryTermsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, "getGlossaryTermsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossaryTermsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse getGlossaryTermByGUID(String serverName, String userId, String guid, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getGlossaryTermByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermByGUID");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermByGUID");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryTermByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryTermByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), guid, "getGlossaryTermByGUID"));
            } else {
                response.setElement(handler.getGlossaryTermByGUID(userId, null, null, guid, "getGlossaryTermByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossaryTermByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createExternalGlossaryLink(String serverName, String userId, ExternalGlossaryLinkRequestBody requestBody) {
        String methodName = "createExternalGlossaryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalGlossaryLink");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalGlossaryLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createExternalGlossaryLink");
                response.setGUID(handler.createExternalGlossaryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getElementProperties(), "createExternalGlossaryLink"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalGlossaryLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createExternalGlossaryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalGlossaryLink(String serverName, String userId, String externalLinkGUID, ExternalGlossaryLinkRequestBody requestBody) {
        String methodName = "updateExternalGlossaryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateExternalGlossaryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateExternalGlossaryLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateExternalGlossaryLink");
                handler.updateExternalGlossaryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalLinkGUID, requestBody.getElementProperties(), "updateExternalGlossaryLink");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateExternalGlossaryLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateExternalGlossaryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeExternalGlossaryLink(String serverName, String userId, String externalLinkGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "removeExternalGlossaryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeExternalGlossaryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeExternalGlossaryLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeExternalGlossaryLink");
            if (requestBody != null) {
                handler.removeExternalGlossaryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalLinkGUID, "removeExternalGlossaryLink");
            } else {
                handler.removeExternalGlossaryLink(userId, null, null, externalLinkGUID, "removeExternalGlossaryLink");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeExternalGlossaryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachExternalLinkToGlossary(String serverName, String userId, String glossaryGUID, String externalLinkGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "attachExternalLinkToGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachExternalLinkToGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachExternalLinkToGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "attachExternalLinkToGlossary");
            if (requestBody != null) {
                handler.attachExternalLinkToGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, externalLinkGUID, "attachExternalLinkToGlossary");
            } else {
                handler.attachExternalLinkToGlossary(userId, null, null, glossaryGUID, externalLinkGUID, "attachExternalLinkToGlossary");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "attachExternalLinkToGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachExternalLinkFromGlossary(String serverName, String userId, String externalLinkGUID, String glossaryGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "detachExternalLinkFromGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachExternalLinkFromGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachExternalLinkFromGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "detachExternalLinkFromGlossary");
            if (requestBody != null) {
                handler.detachExternalLinkFromGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, externalLinkGUID, "detachExternalLinkFromGlossary");
            } else {
                handler.detachExternalLinkFromGlossary(userId, null, null, glossaryGUID, externalLinkGUID, "detachExternalLinkFromGlossary");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "detachExternalLinkFromGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalGlossaryLinkElementsResponse getExternalLinksForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize) {
        String methodName = "getExternalLinksForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalLinksForGlossary");
        ExternalGlossaryLinkElementsResponse response = new ExternalGlossaryLinkElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalLinksForGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getExternalLinksForGlossary");
            response.setElementList(handler.getExternalLinksForGlossary(userId, glossaryGUID, startFrom, pageSize, "getExternalLinksForGlossary"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getExternalLinksForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesForExternalLink(String serverName, String userId, String externalLinkGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getGlossariesForExternalLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossariesForExternalLink");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesForExternalLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossariesForExternalLink");
            if (requestBody != null) {
                response.setElementList(handler.getGlossariesForExternalLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalLinkGUID, startFrom, pageSize, "getGlossariesForExternalLink"));
            } else {
                response.setElementList(handler.getGlossariesForExternalLink(userId, null, null, externalLinkGUID, startFrom, pageSize, "getGlossariesForExternalLink"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGlossariesForExternalLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachExternalCategoryLink(String serverName, String userId, String glossaryCategoryGUID, String externalLinkGUID, ExternalGlossaryElementLinkRequestBody requestBody) {
        String methodName = "attachExternalCategoryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachExternalCategoryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachExternalCategoryLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "attachExternalCategoryLink");
                handler.attachExternalCategoryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, externalLinkGUID, requestBody.getElementProperties(), "attachExternalCategoryLink");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "attachExternalCategoryLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "attachExternalCategoryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachExternalCategoryLink(String serverName, String userId, String externalLinkGUID, String glossaryCategoryGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "detachExternalCategoryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachExternalCategoryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachExternalCategoryLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "detachExternalCategoryLink");
            if (requestBody != null) {
                handler.detachExternalCategoryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, externalLinkGUID, "detachExternalCategoryLink");
            } else {
                handler.detachExternalCategoryLink(userId, null, null, glossaryCategoryGUID, externalLinkGUID, "detachExternalCategoryLink");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "detachExternalCategoryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachExternalTermLink(String serverName, String userId, String externalLinkGUID, String glossaryTermGUID, ExternalGlossaryElementLinkRequestBody requestBody) {
        String methodName = "attachExternalTermLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachExternalTermLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachExternalTermLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "attachExternalTermLink");
                handler.attachExternalTermLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermGUID, externalLinkGUID, requestBody.getElementProperties(), "attachExternalTermLink");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "attachExternalTermLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "attachExternalTermLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachExternalTermLink(String serverName, String userId, String externalLinkGUID, String glossaryTermGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "detachExternalTermLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachExternalTermLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachExternalTermLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "detachExternalTermLink");
            if (requestBody != null) {
                handler.detachExternalTermLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermGUID, externalLinkGUID, "detachExternalTermLink");
            } else {
                handler.detachExternalTermLink(userId, null, null, glossaryTermGUID, externalLinkGUID, "detachExternalTermLink");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "detachExternalTermLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

