/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataAssetExchangeHandler
extends ExchangeHandlerBase {
    private AssetHandler<AssetElement> assetHandler;
    private static final String assetGUIDParameterName = "assetGUID";

    public DataAssetExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.assetHandler = new AssetHandler(new AssetConverter(repositoryHelper, serviceName, serverName), AssetElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToDataAssets(String userId, String assetManagerGUID, String assetManagerName, List<AssetElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), assetGUIDParameterName, "Asset", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    public String createAsset(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, AssetProperties assetProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUID;
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        String typeName = "Asset";
        if (assetProperties.getTypeName() != null) {
            typeName = assetProperties.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Asset", this.serviceName, methodName, this.repositoryHelper);
        int ownerCategory = OwnerCategory.USER_ID.getOpenTypeOrdinal();
        if (assetProperties.getOwnerCategory() != null) {
            ownerCategory = assetProperties.getOwnerCategory().getOpenTypeOrdinal();
        }
        if ((assetGUID = this.assetHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, assetProperties.getQualifiedName(), assetProperties.getTechnicalName(), assetProperties.getTechnicalDescription(), assetProperties.getZoneMembership(), assetProperties.getOwner(), ownerCategory, assetProperties.getOriginOrganizationGUID(), assetProperties.getOriginBusinessCapabilityGUID(), assetProperties.getOtherOriginValues(), assetProperties.getAdditionalProperties(), typeGUID, typeName, assetProperties.getExtendedProperties(), methodName)) != null) {
            this.maintainSupplementaryProperties(userId, assetGUID, assetProperties.getQualifiedName(), (SupplementaryProperties)assetProperties, false, methodName);
            this.createExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        }
        return assetGUID;
    }

    public String createAssetFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String assetGUID = this.assetHandler.addAssetFromTemplate(userId, null, null, templateGUID, "templateGUID", "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", templateProperties.getQualifiedName(), "templateProperties.qualifiedName", templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (assetGUID != null) {
            this.createExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        }
        return assetGUID;
    }

    public void updateAsset(String userId, MetadataCorrelationProperties correlationProperties, String assetGUID, boolean isMergeUpdate, AssetProperties assetProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        this.assetHandler.updateAsset(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetProperties.getQualifiedName(), assetProperties.getTechnicalName(), assetProperties.getTechnicalDescription(), assetProperties.getAdditionalProperties(), "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", assetProperties.getExtendedProperties(), methodName);
        this.maintainSupplementaryProperties(userId, assetGUID, assetProperties.getQualifiedName(), (SupplementaryProperties)assetProperties, isMergeUpdate, methodName);
    }

    public void publishAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.assetHandler.publishAsset(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public void withdrawAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.withdrawAsset(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public void removeAsset(String userId, MetadataCorrelationProperties correlationProperties, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        this.validateExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        this.assetHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", null, null, methodName);
    }

    public void setAssetAsReferenceData(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.classifyAssetAsReferenceData(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public void clearAssetAsReferenceData(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.classifyAssetAsReferenceData(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public List<AssetElement> findAssets(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        List results = this.assetHandler.findAssets(userId, searchString, "searchString", startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<AssetElement> getAssetsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        List results = this.assetHandler.findAssetsByName(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", name, "name", startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<AssetElement> getAssetsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String assetEntityParameterName = "assetEntity";
        String assetGUIDParameterName = "assetEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        ArrayList<AssetElement> results = new ArrayList<AssetElement>();
        List assetEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", "SoftwareServerCapability", "Asset", startFrom, pageSize, methodName);
        if (assetEntities != null) {
            for (EntityDetail assetEntity : assetEntities) {
                AssetElement assetElement;
                if (assetEntity == null || (assetElement = (AssetElement)this.assetHandler.getBeanFromEntity(userId, assetEntity, "assetEntity", methodName)) == null) continue;
                assetElement.setCorrelationHeaders(this.getCorrelationProperties(userId, assetEntity.getGUID(), "assetEntity.getGUID()", "Asset", assetManagerGUID, assetManagerName, methodName));
                results.add(assetElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public AssetElement getAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        AssetElement asset = (AssetElement)this.assetHandler.getBeanFromRepository(userId, openMetadataGUID, "openMetadataGUID", "Asset", methodName);
        if (asset != null) {
            asset.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "Asset", assetManagerGUID, assetManagerName, methodName));
        }
        return asset;
    }
}

